<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
      <script language="JavaScript">
      	<%@ include file="/database/utils.js"%>
      </script>
     
    </uix:metaContainer>
    <uix:body>
	<db:form name="dirobj" method="POST" destination="/console/database/security/dirObject" copyParams="target,type,cancelURL,oname,otype">
     	   <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
		<uix:formValue name="pageName" value="/database/security/dirobject/viewPage"/>
		 <%@ include file="/database/global.jspf" %>

                 <%-- Warning/Error display --%>
                 <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
                 <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

                 <uix:header textBinding="GENERAL_TAB@uixDirectoryObjectBundle@servletRequest">
    			
     			   	 <uix:rowLayout >
       					<uix:cellFormat hAlign="right">
        					<uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" />
     				 	</uix:cellFormat>
						<uix:spacer width="10"/>
      					<uix:cellFormat hAlign="left">
        					<uix:styledText styleClass="OraDataText" textBinding="doName@objectBean@servletRequest"/>
      					</uix:cellFormat>
      				</uix:rowLayout>
                     <uix:spacer height="5"/>
      				<uix:rowLayout>
      					<uix:cellFormat hAlign="right">
       						<uix:messagePrompt promptBinding="PATH@uixDBObjectBundle@servletRequest"/>
     					 </uix:cellFormat>
						 <uix:spacer width="10"/>
      					<uix:cellFormat hAlign="left">
        					<uix:styledText styleClass="OraDataText" textBinding="doPath@objectBean@servletRequest" />
      					</uix:cellFormat>
       				</uix:rowLayout>

		</uix:header>
                <uix:header textBinding="PRIVILEGE_TAB@uixDirectoryObjectBundle@servletRequest"
                             renderedBinding="sysdbaPriv@objectBean@servletRequest">
			<uix:tableLayout cellSpacing="5">
      				<uix:rowLayout>
        				<oem:table name="dirObjUsersTableUI" beanKey="userDataSource"
             				blockSize="10"  formSubmitted="true"
            	 			dataSourceProp="dirObjectUsersTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" 
					summaryBinding="VIEW_PRIVILEGE_SUMMARY@uixDBObjectBundle@servletRequest" width="100%" copyParams="target,type"/>
      				</uix:rowLayout>
    			</uix:tableLayout>
                </uix:header>
		<uix:pageButtons>
			<uix:pageButtonBar>
				<uix:submitButton textBinding="EDIT@uixDBObjectBundle@servletRequest"  name="event"  value="editFromView" shortDescBinding="EDIT@uixDBObjectBundle@servletRequest"/>
				
				<uix:submitButton textBinding="RETURN@uixDBObjectBundle@servletRequest" name="event"  value="cancel" shortDescBinding="RETURN@uixDBObjectBundle@servletRequest"/>
				<uix:spacer width="10"/>
			</uix:pageButtonBar>
		</uix:pageButtons>
           </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
