<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource"%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="sdkMessageBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMessageBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="dvMsgs" class="oracle.sysman.db.rsc.sec.dv.DVMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body > 
      <script>

	function disableDAYSorHRS(){
                var selValue;
                for(i =0; i < document.forms[0].searchChoice.length; i++ ){
                    if(document.forms[0].searchChoice[i].checked){
                        selValue = document.forms[0].searchChoice[i].value;
                    }
                }
                if(selValue == 'hrs'){
	             disableDaysFields();       
                }else if(selValue == 'days'){
                  disableHrsFields();
                }
                
            }
	
	function disableDaysFields(){
		document.forms[0].pastHrs.disabled=false; 
    	document.forms[0].fromDate.disabled=true; 
        document.forms[0].fromHour.disabled=true; 
        document.forms[0].fromMinute.disabled=true; 
        document.forms[0].fromAmPm[0].disabled=true; 
        document.forms[0].fromAmPm[1].disabled=true;
	document.forms[0].toDate.disabled=true;
        document.forms[0].toHour.disabled=true; 
        document.forms[0].toMinute.disabled=true; 
        document.forms[0].toAmPm[0].disabled=true; 
        document.forms[0].toAmPm[1].disabled=true;
	}

	function disableHrsFields(){

		document.forms[0].pastHrs.disabled=true; 
    	document.forms[0].fromDate.disabled=false; 
        document.forms[0].fromHour.disabled=false; 
        document.forms[0].fromMinute.disabled=false; 
        document.forms[0].fromAmPm[0].disabled=false; 
        document.forms[0].fromAmPm[1].disabled=false;
	document.forms[0].toDate.disabled=false;
        document.forms[0].toHour.disabled=false; 
        document.forms[0].toMinute.disabled=false; 
        document.forms[0].toAmPm[0].disabled=false; 
        document.forms[0].toAmPm[1].disabled=false;
	}
	

	</script>
      <db:form name="dvVoliationsForm" method="POST"
               destination="/console/database/security/dv/DVViolationSummary"
               copyParams="target,type">
        <uix:formValue name="pageName"
                       value="/database/security/dv/dvViolationsSummary"/>
        <uix:contents>
          <uix:pageLayout titleBinding="VIOLATIONS_REPORT_HEADER@dvMsgs">
            <%@ include file="/database/global.jspf"%>
	<uix:messages>
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
            
	</uix:messages>
         <uix:flowLayout>
          <uix:tableLayout width="100%" >
            <uix:rowLayout>
                
              <uix:cellFormat hAlign="right" >
                <uix:flowLayout>
                    <uix:styledText styleClass="OraTipText"
                      textBinding="PAGE_REFRESHED_TIME@sdkMessageBundle"/>
                    <uix:spacer width="5" />
                    <uix:styledText styleClass="OraTipLabel"
                      textBinding="refreshTime@servletRequest"/>
                    <uix:spacer width="10" />
                    
                 </uix:flowLayout>
                </uix:cellFormat>  
              </uix:rowLayout>
              <%--<uix:rowLayout hAlign="right" >
                  <uix:cellFormat hAlign="right" >
                  
                  <uix:messageRadioButton name="maxDisplayableRows"
                                     value="500"
                                     text="500"
                                     prompt ="Maximum Results Size"
                                     selectedValueBinding="maxDisplayableRowsStr@defaultBean@servletRequest"/>
                   <uix:messageRadioButton name="maxDisplayableRows"
                                     value="1000"
                                     text="1000"
                                     selectedValueBinding="maxDisplayableRowsStr@defaultBean@servletRequest"/> 
                    <uix:messageRadioButton name="maxDisplayableRows"
                                     value="5000"
                                     text="5000"
                                     selectedValueBinding="maxDisplayableRowsStr@defaultBean@servletRequest">                                      
                        
                      </uix:messageRadioButton>
                     
                  </uix:cellFormat>
                </uix:rowLayout> --%>
        </uix:tableLayout>
      </uix:flowLayout>
            <uix:contents>
              <uix:spacer height="10" width="10"/>
              <uix:tableLayout width="100%" >
                <uix:rowLayout hAlign="left" width="100%">
                  <uix:cellFormat hAlign="left">
                    <uix:labeledFieldLayout labelWidth="30%" fieldWidth="70%"
                                            width="20%" columns="2">
                      <uix:messageRadioButton name="searchChoice" value="hrs"
                                              selectedBinding="hrsSel@defaultBean@servletRequest"
                                              />
                      <uix:messageTextInput name="pastHrs"
                                            promptBinding="VIOLATION_REPORT_LAST@dvMsgs"
                                            columns="5"
                                            textBinding="pastHrs@defaultBean@servletRequest"
                                            tipBinding="VIOLATIONS_REPORT_HRS_TEXT@dvMsgs" 
                                            shortDescBinding="REPORT_SHORT_DESC_HRS@dvMsgs">
                      </uix:messageTextInput>
                      
                    </uix:labeledFieldLayout>
                    
                  </uix:cellFormat>
                  <%--<uix:cellFormat hAlign="right">
                  <uix:messageChoice name="maxDisplayableRows"
                                           prompt="Maximum Results Size"
                                           selectedValueBinding="maxDisplayableRowsStr@defaultBean@servletRequest">
                          <uix:contents>
                            <uix:option text="500"
                                        value="500"/>
                            <uix:option text="1000"
                                        value="1000"/>
                            <uix:option text="5000"
                                        value="5000"/>
                          </uix:contents>
                        </uix:messageChoice>
                  </uix:cellFormat>--%>
                  
                </uix:rowLayout>
                <uix:rowLayout hAlign="left" width="100%" >
                  <uix:cellFormat columnSpan="2">
                    <uix:spacer height="10" width="10"/>
                    <uix:labeledFieldLayout labelWidth="30%" fieldWidth="70%"
                                            width="20%" columns="8">
                      <uix:contents>
                        <uix:messageRadioButton name="searchChoice" value="days"
                                                selectedBinding="daysSel@defaultBean@servletRequest"
                                                />
                        <uix:messageDateField columns="15" name="fromDate"
                                              promptBinding="FROM_DATE_PROMPT_TEXT@dvMsgs"
                                              valueBinding="fromDate@defaultBean@servletRequest"
                                              tipBinding="dateFormat@defaultBean@servletRequest"
                                              shortDescBinding="REPORT_SHORT_DESC_FROM_DATE@dvMsgs">
                          <uix:onSubmitValidater>
                            <uix:date dateStyle="medium"/>
                          </uix:onSubmitValidater>
                        </uix:messageDateField>
                        <uix:tableLayout>
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <%--<uix:cellFormat vAlign="top">
                                  <uix:contents>
                                    <uix:messagePrompt prompt="Time "/>
                                  </uix:contents>
                                </uix:cellFormat>--%>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                      
                                        <uix:cellFormat vAlign="top"
                                                        wrappingDisabled="true">
                                          <uix:contents>
                                            <%--<uix:messageTextInput name="fromHour"
                                                                  columns="2"
                                                                  maximumLength="2"
                                                                  vAlign="top"
                                                                  textBinding="fromHour@defaultBean@servletRequest"
                                                                  shortDesc="Hours">
                                              <uix:contents>
                                                <uix:onSubmitValidater>
                                                  <uix:contents>
                                                    <uix:regExp pattern="[0-9]+"/>
                                                  </uix:contents>
                                                </uix:onSubmitValidater>
                                              </uix:contents>
                                            </uix:messageTextInput>--%>
                                            <uix:messageChoice name="fromHour"
                                           selectedValueBinding="fromHour@defaultBean@servletRequest" shortDescBinding="REPORT_SHORT_DESC_HRS@dvMsgs" promptBinding="REPORT_PROMPT_TIME@dvMsgs">
                                              <uix:contents>
                                              <%
                                              for (int i=1;i<13;i++){
                                              String str = Integer.toString(i);
                                              %>
                                                <uix:option text='<%=str%>'
                                                            value='<%=str%>'/>
                                               <%}%>             
                                              </uix:contents>
                                            </uix:messageChoice>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat vAlign="top">
                                          <uix:contents>
                                            <uix:rowLayout vAlign="top">
                                              <uix:contents>
                                                <uix:cellFormat width="4%"
                                                                hAlign="center"
                                                                vAlign="top"
                                                                wrappingDisabled="true">
                                                  <uix:contents>
                                                    <uix:spacer height="2"/>
                                                    <uix:styledText text=":"/>
                                                    <uix:spacer height="2"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="96%" vAlign="top"
                                                        wrappingDisabled="true">
                                          <uix:contents>
                                            <uix:rowLayout vAlign="top">
                                              <uix:contents>
                                                <uix:cellFormat width="30%"
                                                                hAlign="right"
                                                                vAlign="top"
                                                                wrappingDisabled="true">
                                                  <uix:contents>
                                                    <%--<uix:messageTextInput name="fromMinute"
                                                                          columns="2"
                                                                          maximumLength="2"
                                                                          vAlign="top"
                                                                          textBinding="fromMinute@defaultBean@servletRequest"
                                                                          shortDesc="Minutes">
                                                      <uix:contents>
                                                        <uix:onSubmitValidater>
                                                          <uix:contents>
                                                            <uix:regExp pattern="[0-9]+"/>
                                                          </uix:contents>
                                                        </uix:onSubmitValidater>
                                                      </uix:contents>
                                                    </uix:messageTextInput>--%>
                                                    <uix:messageChoice name="fromMinute"
                                           selectedValueBinding="fromMinute@defaultBean@servletRequest" shortDescBinding="REPORT_SHORT_DESC_MINS@dvMsgs">
                                              <uix:contents>
                                              <%
                                              for (int j=0;j<60;j++){
                                              String str = Integer.toString(j);
                                              %>
                                                <uix:option text='<%=str%>'
                                                            value='<%=str%>'/>
                                               <%}%>             
                                              </uix:contents>
                                            </uix:messageChoice>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <uix:spacer height="5"/>
                                                <uix:cellFormat width="70%"
                                                                vAlign="top">
                                                  <uix:contents>
                                              
                                                    <%--<uix:radioButton name="fromAmPm"
                                                                     value="0"
                                                                     text="AM"
                                                                     selectedValueBinding="fromAmPm@defaultBean@servletRequest"/>--%>
                                                    <uix:messageChoice name="fromAmPm"
                                                   selectedValueBinding="fromAmPm@defaultBean@servletRequest" shortDescBinding="REPORT_SHORT_AMPM@dvMsgs">
                                                      <uix:contents>
                                                        <uix:option textBinding="REPORT_TEXT_AM@dvMsgs"
                                                                    value="0"/>
                                                        <uix:option textBinding="REPORT_TEXT_PM@dvMsgs"
                                                                    value="1"/>
                                                       </uix:contents>
                                                    </uix:messageChoice>                                                                     
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <%--<uix:cellFormat width="70%"
                                                                vAlign="top">
                                                  <uix:contents>
                                                    <uix:radioButton name="fromAmPm"
                                                                     value="1"
                                                                     text="PM"
                                                                     selectedValueBinding="fromAmPm@defaultBean@servletRequest"/>
                                                  </uix:contents>
                                                </uix:cellFormat>--%>
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:messageDateField columns="15" name="toDate"
                                              promptBinding="TO_DATE_PROMPT_TEXT@dvMsgs"
                                              valueBinding="toDate@defaultBean@servletRequest"
                                              tipBinding="dateFormat@defaultBean@servletRequest"
                                              shortDescBinding="REPORT_SHORT_DESC_TO_DATE@dvMsgs">
                          <uix:onSubmitValidater>
                            <uix:date dateStyle="medium"/>
                          </uix:onSubmitValidater>
                        </uix:messageDateField>
                        <uix:tableLayout>
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                               <%-- <uix:cellFormat vAlign="top">
                                  <uix:contents>
                                    <uix:messagePrompt prompt="Time "/>
                                  </uix:contents>
                                </uix:cellFormat>--%>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat vAlign="top"
                                                        wrappingDisabled="true">
                                          <uix:contents>
                                            <%--<uix:messageTextInput name="toHour"
                                                                  columns="2"
                                                                  maximumLength="2"
                                                                  vAlign="top"
                                                                  textBinding="toHour@defaultBean@servletRequest"
                                                                  shortDesc="Hours">
                                              <uix:contents>
                                                <uix:onSubmitValidater>
                                                  <uix:contents>
                                                    <uix:regExp pattern="[0-9]+"/>
                                                  </uix:contents>
                                                </uix:onSubmitValidater>
                                              </uix:contents>
                                            </uix:messageTextInput>--%>
                                             <uix:messageChoice name="toHour"
                                           selectedValueBinding="toHour@defaultBean@servletRequest" shortDescBinding="REPORT_SHORT_DESC_HRS@dvMsgs" promptBinding="REPORT_PROMPT_TIME@dvMsgs">
                                              <uix:contents>
                                              <%
                                              for (int k=1;k<13;k++){
                                              String str = Integer.toString(k);
                                              %>
                                                <uix:option text='<%=str%>'
                                                            value='<%=str%>'/>
                                               <%}%>             
                                              </uix:contents>
                                            </uix:messageChoice>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat vAlign="top">
                                          <uix:contents>
                                            <uix:rowLayout vAlign="top">
                                              <uix:contents>
                                                <uix:cellFormat width="4%"
                                                                hAlign="center"
                                                                vAlign="top"
                                                                wrappingDisabled="true">
                                                  <uix:contents>
                                                  <uix:spacer height="2"/>
                                                    <uix:styledText text=":"/>
                                                    <uix:spacer height="2"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="96%" vAlign="top"
                                                        wrappingDisabled="true">
                                          <uix:contents>
                                            <uix:rowLayout vAlign="top">
                                              <uix:contents>
                                                <uix:cellFormat width="30%"
                                                                hAlign="right"
                                                                vAlign="top"
                                                                wrappingDisabled="true">
                                                  <uix:contents>
                                                   <%-- <uix:messageTextInput name="toMinute"
                                                                          columns="2"
                                                                          maximumLength="2"
                                                                          vAlign="top"
                                                                          textBinding="toMinute@defaultBean@servletRequest"
                                                                          shortDesc="Minutes">
                                                      <uix:contents>
                                                        <uix:onSubmitValidater>
                                                          <uix:contents>
                                                            <uix:regExp pattern="[0-9]+"/>
                                                          </uix:contents>
                                                        </uix:onSubmitValidater>
                                                      </uix:contents>
                                                    </uix:messageTextInput>--%>
                                                     <uix:messageChoice name="toMinute"
                                           selectedValueBinding="toMinute@defaultBean@servletRequest" shortDescBinding="REPORT_SHORT_DESC_MINS@dvMsgs">
                                              <uix:contents>
                                              <%
                                              for (int l=0;l<60;l++){
                                              String str = Integer.toString(l);
                                              %>
                                                <uix:option text='<%=str%>'
                                                            value='<%=str%>'/>
                                               <%}%>             
                                              </uix:contents>
                                            </uix:messageChoice>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <uix:spacer height="5"/>
                                                <uix:cellFormat width="70%"
                                                                vAlign="top">
                                                  <uix:contents>
                                                    <%--<uix:radioButton name="toAmPm"
                                                                     value="0"
                                                                     text="AM"
                                                                     selectedValueBinding="toAmPm@defaultBean@servletRequest"/>--%>
                                                   <uix:messageChoice name="toAmPm"
                                                   selectedValueBinding="toAmPm@defaultBean@servletRequest" shortDescBinding="REPORT_SHORT_AMPM@dvMsgs">
                                                      <uix:contents>
                                                        <uix:option textBinding="REPORT_TEXT_AM@dvMsgs"
                                                                    value="0"/>
                                                        <uix:option textBinding="REPORT_TEXT_PM@dvMsgs"
                                                                    value="1"/>
                                                       </uix:contents>
                                                    </uix:messageChoice> 
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <%--<uix:cellFormat width="70%"
                                                                vAlign="top">
                                                  <uix:contents>
                                                    <uix:radioButton name="toAmPm"
                                                                     value="1"
                                                                     text="PM"
                                                                     selectedValueBinding="toAmPm@defaultBean@servletRequest"/>
                                                  </uix:contents>
                                                </uix:cellFormat>--%>
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="left" width="100%">
                  <uix:cellFormat columnSpan="2">
                    <uix:spacer height="10" width="10"/>
                    <uix:labeledFieldLayout labelWidth="30%" fieldWidth="70%"
                                            width="20%" columns="2">
                      <uix:contents>
                        <uix:messageChoice name="violationType"
                                           promptBinding="VIOLATION_TYPE_PROMPT_TEXT@dvMsgs"
                                           shortDescBinding="VIOLATION_TYPE_PROMPT_TEXT@dvMsgs"
                                           selectedValueBinding="violationType@defaultBean@servletRequest">
                          <uix:contents>
                            <uix:option textBinding="VIOLATION_TYPE_TEXT_ALL@dvMsgs"
                                        value="%"/>
                            <uix:option textBinding="VIOLATION_TYPE_TEXT_REALM@dvMsgs"
                                        value="REALM$"/>
                            <uix:option textBinding="VIOLATION_TYPE_TEXT_CMD_RULE@dvMsgs"
                                        value="CODE$"/>
                            <uix:option text="Factor" value="FACTOR$"/>
                            <uix:option textBinding="VIOLATION_TYPE_TEXT_SEC_APP_ROLE@dvMsgs"
                                        value="ROLE$"/>
                          </uix:contents>
                        </uix:messageChoice>
                        <uix:messageTextInput columns="20"
                                              promptBinding="VIOLATION_REPORT_PROMPT_NAME@dvMsgs"
                                              name="componentName"
                                              textBinding="componentName@defaultBean@servletRequest"
                                              shortDescBinding="VIOLATION_REPORT_PROMPT_NAME@dvMsgs"/>
                        <uix:messageTextInput columns="20"
                                              promptBinding="VIOLATION_COLUMN_HEADER_DB_USER_NAME@dvMsgs"
                                              name="dbuserName"
                                              textBinding="dbuserName@defaultBean@servletRequest"
                                              shortDescBinding="VIOLATION_COLUMN_HEADER_DB_USER_NAME@dvMsgs"/>
                        <uix:messageTextInput columns="20"
                                              promptBinding="VIOLATION_COLUMN_HEADER_CLIENT_HOST@dvMsgs"
                                              name="userHost"
                                              textBinding="userHost@defaultBean@servletRequest"
                                              shortDescBinding="VIOLATION_COLUMN_HEADER_CLIENT_HOST@dvMsgs"/>
                        <uix:messageChoice name="maxDisplayableRows"
                                           promptBinding="REPORT_SHORT_DESC_MAX_RESULTS_SIZE@dvMsgs"
                                           selectedValueBinding="maxDisplayableRowsStr@defaultBean@servletRequest"
                                           shortDescBinding="REPORT_SHORT_DESC_MAX_RESULTS_SIZE@dvMsgs">
                          <uix:contents>
                            <uix:option text="500"
                                        value="500"/>
                            <uix:option text="1000"
                                        value="1000"/>
                            <uix:option text="5000"
                                        value="5000"/>
                          </uix:contents>
                          <uix:end>
                            <uix:submitButton textBinding="REPORT_SHORT_DESC_GO_BUTTON@dvMsgs" name="event"
                                              value="searchViolations" shortDescBinding="REPORT_SHORT_DESC_GO_BUTTON@dvMsgs"/>
                          </uix:end>
                        </uix:messageChoice>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                
              </uix:tableLayout>
              <uix:spacer height="10" width="10"/>
              <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="center" width="100%">
                  <uix:cellFormat>
                    <uix:tableLayout cellPadding="2" cellSpacing="2"
                                     hAlign="center" width="100%">
                      <uix:rowLayout width="100%" hAlign="left">                                     
                      <uix:messagePrompt messageType="warning" promptBinding="invalidQuerymsg@defaultBean@servletRequest" renderedBinding="invalidMsgShow@defaultBean@servletRequest"/>                            
                      </uix:rowLayout>
                      <uix:rowLayout width="100%" hAlign="left">  
                        <%--<uix:formattedText styleUsage="instruction" textBinding="resultsCriteria@defaultBean@servletRequest"/>--%>
                      </uix:rowLayout>
                      <uix:rowLayout width="100%" hAlign="center">
                        <uix:cellFormat hAlign="center" width="100%">
                          <uix:dataScope currentDataBinding="violationsSummary@servletRequest">
                            <uix:table width="100%" formSubmitted="true"
                                       id="VIOLATIONS_SUMMARY_TABLE"
                                       tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                       valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                       maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                       blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                       summaryBinding="VIOLATIONS_REPORT_HEADER@dvMsgs"
                                       shortDescBinding="VIOLATIONS_REPORT_HEADER@dvMsgs"
                                       alternateTextBinding="REPORT_NO_ITEMS_FOUND@dvMsgs">
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="VIOLATION_COLUMN_HEADER_DATETIME@dvMsgs"
                                                      shortDescBinding="VIOLATION_COLUMN_HEADER_DATETIME@dvMsgs"
                                                      sortableBinding="violationDateTimeSortStatus"/>
                                </uix:columnHeader>
                                <uix:styledText textBinding="TIMESTAMP_INDEX"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="VIOLATION_TYPE_PROMPT_TEXT@dvMsgs"
                                                      shortDescBinding="VIOLATION_TYPE_PROMPT_TEXT@dvMsgs"
                                                      sortableBinding="violationTypeSortStatus"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText textBinding="OBJ_NAME_INDEX"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="VIOLATION_REPORT_PROMPT_NAME@dvMsgs"
                                                      shortDescBinding="VIOLATION_REPORT_PROMPT_NAME@dvMsgs"
                                                      sortableBinding="violationNameSortStatus"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText textBinding="ACTION_OBJECT_NAME_INDEX"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="VIOLATION_COLUMN_HEADER_DB_USER_NAME@dvMsgs"
                                                      shortDescBinding="VIOLATION_COLUMN_HEADER_DB_USER_NAME@dvMsgs"
                                                      sortableBinding="violationDBUsernameSortStatus"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText textBinding="USERNAME_INDEX"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="VIOLATION_COLUMN_HEADER_CLIENT_HOST@dvMsgs"
                                                      shortDescBinding="VIOLATION_COLUMN_HEADER_CLIENT_HOST@dvMsgs"
                                                      sortableBinding="violationClientHostSortStatus"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText textBinding="USERHOST_INDEX"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="VIOLATION_COLUMN_HEADER_CLIENT_HOST_USER_NAME@dvMsgs"
                                                      shortDescBinding="VIOLATION_COLUMN_HEADER_CLIENT_HOST_USER_NAME@dvMsgs"
                                                      sortableBinding="violationClientHostUsernameSortStatus"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText textBinding="OS_USERNAME_INDEX"/>
                              </uix:column>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="VIOLATION_COLUMN_HEADER_CLIENT_ACT_CMD@dvMsgs"
                                                      shortDescBinding="VIOLATION_COLUMN_HEADER_CLIENT_ACT_CMD@dvMsgs"
                                                      sortableBinding="violationActCmdSortStatus"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText textBinding="ACTION_COMMAND_INDEX"/>
                              </uix:column>
                            </uix:table>
                          </uix:dataScope>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

        <uix:header textBinding="RELATED_LINKS@DBMsgBundle@servletRequest">
          <uix:tableLayout width="100%" cellSpacing="2">
            <uix:rowLayout>

              <uix:cellFormat>
                       <db:link textBinding="VIEW_TRANSACTION@DBMsgBundle@servletRequest"
                              destination="/console/database/lm/logminer?event=doLoad"
                              copyParams="target,type"/>

              </uix:cellFormat>


            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>

            </uix:contents>
            <uix:pageStatus>
              <uix:formattedText styleUsage="instruction"
                                 textBinding="VIOLATION_REPORT_DESC@dvMsgs"/>
            </uix:pageStatus>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:submitButton disabled="false"
                                    textBinding="OK@sdkMessageBundle"
                                    shortDescBinding="OK@sdkMessageBundle"
                                    name="event" value="dvHomePage"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>
          </uix:pageLayout>
        </uix:contents>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
