<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">  

  <uix:bundle name="sdkMessageBundle"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMessageBundle"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="dvMsgs"
              class="oracle.sysman.db.rsc.sec.dv.DVMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

	  <script>
		function LaunchDVA(){
			dvaURL = document.forms[0].dvaURL.value;
			if(dvaURL != "" ){
			window.open(dvaURL,'dvaWindow');
			}
	  }

	  </script>
    <uix:body>
      <db:form name="dvForm" method="POST" destination="/console/database/security/dv/DV" copyParams="target,type,otype">
	  <uix:formValue name="pageName" value="/database/security/dv/dvaURLPromptPage"/>
	  <uix:formValue name="isCheckDone" valueBinding="IS_DUPLICATE_CHECK_DONE@servletRequest"/>
        <uix:contents>
          <uix:pageLayout titleBinding="DVA_URL_PROMPT_PAGE_TITLE@dvMsgs"> 
		  <%@ include file="/database/global.jspf" %>
		<uix:messages>
                    <uix:flowLayout>
                    <uix:contents>
			 <oem:messageBox messageType="info" 
		        errorTableBinding="info@servletRequest"
		        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        </uix:contents>
                        </uix:flowLayout>
                    </uix:messages>
			 <uix:contents>
				<uix:tableLayout width="100%" cellPadding="2" cellSpacing="2" >
                                <uix:rowLayout>
                                    <uix:cellFormat hAlign="left">
                                        <uix:messageTextInput name="dvaURL" textBinding="DVA_URL_IN_REPOS@servletRequest" 
					columns="40" tip="http://<hostname>:<port>/dva" promptBinding="DVA_URL_PROMPT_TEXT@dvMsgs"  shortDescBinding="DVA_URL_PROMPT_TEXT@dvMsgs">
					<uix:end>
					<uix:button shortDescBinding="DVA_URL_LAUNCH@dvMsgs" textBinding="DVA_URL_LAUNCH@dvMsgs"  onClick="LaunchDVA()"/>
					</uix:end>
					</uix:messageTextInput>
                                    </uix:cellFormat>
                                </uix:rowLayout>

                            </uix:tableLayout>
			 </uix:contents>
			<uix:pageStatus>
                        <uix:formattedText styleUsage="instruction" textBinding="DVA_URL_PROMPT_MSG@dvMsgs"/>
            </uix:pageStatus>

            <uix:pageButtons> 
              <uix:pageButtonBar>
                <uix:contents>
				  <uix:submitButton disabled="false"  name="event" value="cancelDVAUrl" textBinding="CANCEL@sdkMessageBundle" shortDescBinding="CANCEL@sdkMessageBundle"/>
                  <uix:submitButton disabled="false"  name="event" value="saveDVAUrl" textBinding="SAVE_CONFIG_ALT@sdkMessageBundle" shortDescBinding="SAVE_CONFIG_ALT@sdkMessageBundle"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:contents>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
