<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.inst.DBMsgID"%>
<%@ page import="oracle.sysman.db.adm.ParameterNames"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
   <oem:setURLEncoder id="renderingContext"/>
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dvPolicyMgmtMsgs" class="oracle.sysman.db.rsc.sec.dv.DVPolicyMgmtMsg"/>
    <uix:bundle name="dvAdminMsgs" class="oracle.sysman.db.rsc.sec.dv.DVAdminMsg"/>
         <uix:document>
   <uix:metaContainer>
            <uix:head titleBinding="ViewComponentObject_title@servletRequest"/>
        </uix:metaContainer>

             <uix:body>
                 <db:form name="dvPolicyMgmt" method="post" destination="/console/database/security/dv/DVAdmin" copyParams="target,type">
                        <uix:formValue name="pageName" value="/database/security/dv/dvcommandruleview"/>

                  <uix:contents>
                    <uix:pageLayout titleBinding="DV_VIEW_COMMAND_HEADER@dvAdminMsgs">

                    <%@ include file="/database/global.jspf" %>
                            <oem:messageBox messageType="info" 
                                     errorTableBinding="info@servletRequest"
                                         titleTextKey="titleText" mainTextKey="mainText"/>
							<oem:messageBox messageType="error" 
									errorTableBinding="errors@servletRequest"
									  titleTextKey="titleText" mainTextKey="mainText"/>

                      <uix:contents>
			 <uix:header  textBinding="DV_VIEW_GENERAL_HEADER@dvAdminMsgs">
                          <uix:contents>                       
				<uix:tableLayout width="50%"  cellPadding="2" cellSpacing="5">
					<uix:rowLayout>
                            			<uix:cellFormat hAlign="right">
			                                <uix:formattedText textBinding="DV_VIEW_NAME_TXT@dvAdminMsgs" styleUsage="instruction"/>
                       			       </uix:cellFormat>
                              			<uix:cellFormat hAlign="left">
                                			<uix:styledText textBinding="commandName@ViewComponentObject@servletRequest" styleClass="OraDataText"/>
		                              </uix:cellFormat>
					</uix:rowLayout>
					<uix:rowLayout>
		                            <uix:cellFormat hAlign="right">
               			                 <uix:formattedText textBinding="DV_VIEW_STATUS_TXT@dvAdminMsgs" styleUsage="instruction"/>
                              		     </uix:cellFormat>
		                              <uix:cellFormat hAlign="left">
						<uix:switcher childNameBinding="commandStatus@ViewComponentObject@servletRequest">
							<uix:case name="Y">
								<uix:styledText textBinding="DV_STATUS_ENABLED_TXT@dvPolicyMgmtMsgs" 
												styleClass="OraDataText"/>

							</uix:case>
							<uix:case name="N">
								<uix:styledText textBinding="DV_STATUS_DISABLED_TXT@dvPolicyMgmtMsgs" 
												styleClass="OraDataText"/>

							</uix:case>
						</uix:switcher>

		                              </uix:cellFormat>
					</uix:rowLayout>
					<uix:rowLayout>
		                            <uix:cellFormat hAlign="right">
               			                 <uix:formattedText textBinding="DV_VIEW_APPLICABLE_OBJ_OWNER_TXT@dvAdminMsgs" styleUsage="instruction"/>
	                                    </uix:cellFormat>
             		                   <uix:cellFormat hAlign="left">
                         		       <uix:styledText textBinding="applicableObjectOwner@ViewComponentObject@servletRequest" styleClass="OraDataText"/>
                              		</uix:cellFormat>
					</uix:rowLayout>
					<uix:rowLayout>
		                            <uix:cellFormat hAlign="right">
               			                 <uix:formattedText textBinding="DV_VIEW_APPLICABLE_OBJ_NAME_TXT@dvAdminMsgs" styleUsage="instruction"/>
		                              </uix:cellFormat>
		                              <uix:cellFormat hAlign="left">
               			                 <uix:styledText textBinding="applicableObjectName@ViewComponentObject@servletRequest" styleClass="OraDataText"/>
		                              </uix:cellFormat>
					</uix:rowLayout>
					<uix:rowLayout>
		                            <uix:cellFormat hAlign="right">
               			                 <uix:formattedText textBinding="DV_VIEW_APPLICABLE_RULE_SET_TXT@dvAdminMsgs" styleUsage="instruction"/>
		                              </uix:cellFormat>
		                              <uix:cellFormat hAlign="left">
               			                 <uix:styledText textBinding="applicableRuleSet@ViewComponentObject@servletRequest" styleClass="OraDataText"/>
		                              </uix:cellFormat>
					</uix:rowLayout>
				</uix:tableLayout>
                          </uix:contents>                       
			  </uix:header>
                          </uix:contents>                       
		       <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton 
					textBinding="DV_POLICY_MGMT_OK_TXT@dvPolicyMgmtMsgs" 
					shortDescBinding="DV_POLICY_MGMT_OK_TXT@dvPolicyMgmtMsgs" 
					name="event" value="CANCEL_VIEW_DV_COMPONENT"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                      <uix:pageStatus>
                                    <uix:formattedText styleUsage="instruction"
						        textBinding="DV_VIEW_COMMAND_INS_TXT@dvAdminMsgs"/>
                      </uix:pageStatus>                      


		</uix:pageLayout>
                  </uix:contents>
                </db:form>
   </uix:body>
   </uix:document>
   </uix:renderingContext>
