<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.inst.DBMsgID"%>
<%@ page import="oracle.sysman.db.rsc.inst.DBMsgID"%>
<%@ page import="oracle.sysman.db.adm.ParameterNames"%>
<%@ page import="oracle.sysman.emo.adm.security.dv.policymgmt.DVEnabledTargetsDS"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
   <oem:setURLEncoder id="renderingContext"/>
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dvPolicyMgmtMsgs" class="oracle.sysman.db.rsc.sec.dv.DVPolicyMgmtMsg"/>
  	 <uix:document>
   <uix:metaContainer>
            <uix:head titleBinding="DV_POLICY_MGMT_TARGETS_LOV_HDR_TXT@dvPolicyMgmtMsgs"/>
        </uix:metaContainer>

  	     <uix:body>
		 <db:form name="dvavailabletargets" method="post" 
							destination="/console/database/security/dv/DVPolicymgmt" 
							copyParams="target,type">

            <uix:script text="function cancel()
                                  {
                                    top.close();
                                  }
                                  
                              function submitCurrentForm(sSearchURL)    
                              {
                                  document.forms[0].action=sSearchURL;
                                  document.forms[0].submit();
                              }
                                  
                              function submitMainForm(sFinalUrl)
                                  {
                                    var iNumberOfCheckBoxes=0;
                                    var iCheckBoxCount=0;
                                    var sCheckBoxNamePrefix='availabletargets:selected:';
                                    var sToBeAddedSubComponentsIndexes='';
                                    var iSelectedCheckBoxCount=0;
                                    for(var i=0;i<document.forms[0].elements.length;i++)
                                    {
                                      var sElemenetName=document.forms[0].elements[i].name;
                                      var sCheckBoxName=sCheckBoxNamePrefix+iCheckBoxCount;
                                      if(sCheckBoxName==sElemenetName)
                                      {
                                        if(document.forms[0].elements[i].checked)
                                        {
                                          if(iSelectedCheckBoxCount==0)
                                          {
                                            sToBeAddedSubComponentsIndexes=document.forms[0].elements[i].value;  
                                          }
                                          else
                                          {
                                            sToBeAddedSubComponentsIndexes = sToBeAddedSubComponentsIndexes + ',' + document.forms[0].elements[i].value;
                                          }
                                          iSelectedCheckBoxCount++;
                                        }                                          
                                        iCheckBoxCount++;
                                      }
                                    }
				    //alert(sToBeAddedSubComponentsIndexes);
                                    top.window.opener.document.forms[0].addedTargets.value=sToBeAddedSubComponentsIndexes;
                                    top.window.opener.document.forms[0].action=sFinalUrl;
                                    top.window.opener.document.forms[0].submit();
                                    top.close();
                                  }" />

		<uix:formValue name="pageName" value="/database/security/dv/dvenabledtargetslov"/>

                  <uix:contents>
                    <uix:pageLayout titleBinding="DV_POLICY_MGMT_TARGETS_LOV_HDR_TXT@dvPolicyMgmtMsgs">

	                    <oem:messageBox messageType="info" 
       			             errorTableBinding="info@servletRequest"
                   			 titleTextKey="titleText" mainTextKey="mainText"/>
                    		<oem:messageBox messageType="error" 
                    			errorTableBinding="errors@servletRequest"
                  			  titleTextKey="titleText" mainTextKey="mainText"/>

                      <uix:contents>


                                        <uix:tableLayout hAlign="center" cellPadding="2" cellSpacing="2">
                                          <uix:contents>
                                          <uix:rowLayout width="100%">
                                            <uix:contents>
                                              <uix:cellFormat   hAlign="right">
                                                <uix:contents>
                                                  <uix:styledText  
                                                                styleClass="OraInstructionText"
                                                                labeledNodeId="selectedTargetObject"
								textBinding="DV_POLICY_MGMT_TARGETS_LOV_TGT_TYPE_TXT@dvPolicyMgmtMsgs" />
                                                </uix:contents>
                                              </uix:cellFormat>
                                              <uix:cellFormat   hAlign="left">
                                                <uix:contents>
                      					<uix:choice name="selectedTargetObject"
					                                  id="selectedTargetObject"
									  selectedValueBinding="selectedTargetObject@servletRequest">
					                          <uix:option text="All"
                                      						value="%"/>
					                          <uix:option textBinding="TARGET_TYPE_oracle_database@dvPolicyMgmtMsgs"
                                      						value="oracle_database" />
					                          <uix:option textBinding="TARGET_TYPE_rac_database@dvPolicyMgmtMsgs"
                                      						value="rac_database" />
				                      </uix:choice>
                                                </uix:contents>
                                              </uix:cellFormat>
                                            </uix:contents>
                                          </uix:rowLayout>
                                          <uix:rowLayout width="100%">
                                            <uix:contents>
                                              <uix:cellFormat   hAlign="right">
                                                <uix:contents>
                                                  <uix:styledText  
                                                                styleClass="OraInstructionText"
                                                                labeledNodeId="targetSearchCriteria"
								textBinding="DV_POLICY_MGMT_TARGETS_LOV_TGT_TXT@dvPolicyMgmtMsgs" />
                                                </uix:contents>
                                              </uix:cellFormat>
                                              <uix:cellFormat   hAlign="left">
                                                <uix:contents>
                                                  <uix:textInput 
							name="targetSearchCriteria"  
							id="targetSearchCriteria"  
							columns="40" 
							textBinding="targetSearchCriteria@servletRequest" />
                                                </uix:contents>
                                              </uix:cellFormat>
                                            </uix:contents>
                                          </uix:rowLayout>
                                          <uix:rowLayout width="100%">
                                            <uix:contents>
                                              <uix:cellFormat   hAlign="right">
                                                <uix:contents>
                                                  <uix:spacer width="5"/>
                                                </uix:contents>
                                              </uix:cellFormat>
                                              <uix:cellFormat   hAlign="left">
                                                <uix:contents>
                                                  <uix:submitButton  name="event" 
									value="LIST_AVAILABLE_TARGETS" 
									textBinding="DV_POLICY_MGMT_GO_TXT@dvPolicyMgmtMsgs"
									shortDescBinding="DV_POLICY_MGMT_GO_TXT@dvPolicyMgmtMsgs"/>
                                                </uix:contents>
                                              </uix:cellFormat>
                                            </uix:contents>
                                          </uix:rowLayout>
 											</uix:contents>
                                          </uix:tableLayout>
                        <uix:tableLayout hAlign="center" 
                                    cellPadding="2" 
                                    cellSpacing="2" 
                                    width="100%">
                          <uix:contents>
                            <uix:rowLayout  width="100%">
                              <uix:contents>
                                <uix:cellFormat    width="100%" hAlign="left">
                                <uix:contents>
                                	<!-- Selkected databases section -->
					<uix:dataScope currentDataBinding="DV_ENABLED_TARGETS_DS@servletRequest"> 
                      			<uix:table width="100%"  name="availabletargets"
		                                   alternateTextBinding="DV_POLICY_MGMT_TARGETS_LOV_ALT_TXT@dvPolicyMgmtMsgs" 
               			                   tableDataBinding="rowData" 
                       			           minValue="1"
                                  		   formSubmitted="true"
		                                   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                		                   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                		   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                   shortDescBinding="DV_POLICY_MGMT_TARGETS_LOV_SUMMARY_TXT@dvPolicyMgmtMsgs"
               			                   summaryBinding="DV_POLICY_MGMT_TARGETS_LOV_SUMMARY_TXT@dvPolicyMgmtMsgs">


                               			   <uix:tableFormat tableBanding="rowBanding"/>

					    <uix:column>
                                                    <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="DV_POLICY_MGMT_TARGET_DBS_NAME@dvPolicyMgmtMsgs" 
											sortable="true" 
											shortDescBinding="DV_POLICY_MGMT_TARGET_DBS_NAME@dvPolicyMgmtMsgs" />
                                                    </uix:columnHeader>
                                                    <uix:columnFormat columnDataFormat="textFormat" />
                                                    <uix:styledText textBinding="TARGET_DATABASE_NAME" />
                                            </uix:column>

					    <uix:column>
                                                    <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="DV_POLICY_MGMT_TARGET_DBS_TYPE@dvPolicyMgmtMsgs" 
											sortable="false" 
											shortDescBinding="DV_POLICY_MGMT_TARGET_DBS_TYPE@dvPolicyMgmtMsgs" />
                                                    </uix:columnHeader>
                                                    <uix:columnFormat columnDataFormat="textFormat" />
                                                    <uix:styledText textBinding="TARGET_TYPE_LOCAL" />
                                            </uix:column>

	                                  <uix:tableSelection>
       		                             <uix:multipleSelection text="Select an item and ..."/>
               		                   </uix:tableSelection>
		                        </uix:table>
               			     </uix:dataScope>

                                </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:button 
					textBinding="DV_POLICY_MGMT_CANCEL_TXT@dvPolicyMgmtMsgs" 
					shortDescBinding="DV_POLICY_MGMT_CANCEL_TXT@dvPolicyMgmtMsgs" 
					onClick="cancel()"/>
                            <uix:button 
					textBinding="DV_POLICY_MGMT_SELECT_TXT@dvPolicyMgmtMsgs" 
					shortDescBinding="DV_POLICY_MGMT_SELECT_TXT@dvPolicyMgmtMsgs" 
					onClickBinding="AddTargetsButtonAction@servletRequest"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
                      <uix:pageStatus>
                                    <uix:formattedText styleUsage="instruction" 
							textBinding="DV_POLICY_MGMT_TARGETS_LOV_INS_TXT@dvPolicyMgmtMsgs"/>
                      </uix:pageStatus>                      
                      
                    </uix:pageLayout>
                  </uix:contents>
                </db:form>
   </uix:body>
   </uix:document>
   </uix:renderingContext>

