<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.inst.DBMsgID"%>
<%@ page import="oracle.sysman.db.adm.ParameterNames"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
   <oem:setURLEncoder id="renderingContext"/>
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dvPolicyMgmtMsgs" class="oracle.sysman.db.rsc.sec.dv.DVPolicyMgmtMsg"/>
    <uix:bundle name="dvAdminMsgs" class="oracle.sysman.db.rsc.sec.dv.DVAdminMsg"/>
         <uix:document>
   <uix:metaContainer>
            <uix:head titleBinding="ViewComponentObject_title@servletRequest"/>
        </uix:metaContainer>

             <uix:body>
                 <db:form name="dvPolicyMgmt" method="post" destination="/console/database/security/dv/DVAdmin" copyParams="target,type">
                        <uix:formValue name="pageName" value="/database/security/dv/dvrulesetview"/>

                  <uix:contents>
                    <uix:pageLayout titleBinding="DV_RULESET_HEADER@dvAdminMsgs">

                    <%@ include file="/database/global.jspf" %>
                            <oem:messageBox messageType="info" 
                                     errorTableBinding="info@servletRequest"
                                         titleTextKey="titleText" mainTextKey="mainText"/>
							<oem:messageBox messageType="error" 
									errorTableBinding="errors@servletRequest"
									  titleTextKey="titleText" mainTextKey="mainText"/>

                      <uix:contents>
			 <uix:header  textBinding="DV_VIEW_GENERAL_HEADER@dvAdminMsgs">
                          <uix:contents>                       
				<uix:tableLayout hAlign="left" width="80%"  cellPadding="2" cellSpacing="2">
					<uix:rowLayout>
                            			<uix:cellFormat hAlign="right">
			                                <uix:formattedText textBinding="DV_VIEW_NAME_TXT@dvAdminMsgs" styleUsage="instruction"/>
                       			       </uix:cellFormat>
                              			<uix:cellFormat hAlign="left">
                                			<uix:styledText textBinding="ruleSetName@ViewComponentObject@servletRequest" styleClass="OraDataText"/>
		                              </uix:cellFormat>
					</uix:rowLayout>
					<uix:rowLayout>
		                            <uix:cellFormat hAlign="right">
               			                 <uix:formattedText textBinding="DV_VIEW_DESC_TXT@dvAdminMsgs" styleUsage="instruction"/>
                              		     </uix:cellFormat>
		                              <uix:cellFormat hAlign="left">
						<uix:textInput rows="3" columns="75"  
		                                        textBinding="ruleSetDescription@ViewComponentObject@servletRequest" readOnly="true" />
		                              </uix:cellFormat>
					</uix:rowLayout>
					<uix:rowLayout>
		                            <uix:cellFormat hAlign="right">
               			                 <uix:formattedText textBinding="DV_VIEW_STATUS_TXT@dvAdminMsgs" styleUsage="instruction"/>
	                                    </uix:cellFormat>
             		                   <uix:cellFormat hAlign="left">
						<uix:switcher childNameBinding="ruleSetStatus@ViewComponentObject@servletRequest">
							<uix:case name="Y">
								<uix:styledText textBinding="DV_STATUS_ENABLED_TXT@dvPolicyMgmtMsgs" 
												styleClass="OraDataText"/>

							</uix:case>
							<uix:case name="N">
								<uix:styledText textBinding="DV_STATUS_DISABLED_TXT@dvPolicyMgmtMsgs" 
												styleClass="OraDataText"/>

							</uix:case>
						</uix:switcher>

                              		</uix:cellFormat>
					</uix:rowLayout>
					<uix:rowLayout>
		                            <uix:cellFormat hAlign="right">
               			                 <uix:formattedText textBinding="DV_VIEW_AUDIT_OPTION_TXT@dvAdminMsgs" styleUsage="instruction"/>
		                              </uix:cellFormat>
		                              <uix:cellFormat hAlign="left">
						<uix:switcher childNameBinding="ruleSetAuditOption@ViewComponentObject@servletRequest">
							<uix:case name="0">
								<uix:styledText textBinding="DV_AUDIT_DISABLED_TXT@dvPolicyMgmtMsgs" 
												styleClass="OraDataText"/>

							</uix:case>
							<uix:case name="1">
								<uix:styledText textBinding="DV_AUDIT_FAIL_TXT@dvPolicyMgmtMsgs" 
												styleClass="OraDataText"/>

							</uix:case>
							<uix:case name="2">
								<uix:styledText textBinding="DV_AUDIT_ON_SUC_FAIL_TXT@dvPolicyMgmtMsgs" 
												styleClass="OraDataText"/>

							</uix:case>
						</uix:switcher>

		                              </uix:cellFormat>
					</uix:rowLayout>
				</uix:tableLayout>
                          </uix:contents>                       
			  </uix:header>
                          <uix:header  textBinding="DV_RULESET_RULES_HEADER@dvAdminMsgs">
                          <uix:contents>                       
					<uix:dataScope currentDataBinding="rulesDS@ViewComponentObject@servletRequest">
                                        <uix:table width="70%"  name="ruleobjects"
                                                  alternateTextBinding="DV_RULESET_RULES_HEADER@dvAdminMsgs" 
                                                   tableDataBinding="rowData" 
                                                   minValue="1"
                                                   formSubmitted="true"
                                                   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                                   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                   shortDescBinding="DV_RULESET_RULES_HEADER@dvAdminMsgs"
                                                   summaryBinding="DV_RULESET_RULES_HEADER@dvAdminMsgs">


                                            <uix:tableFormat tableBanding="rowBanding"/>

                                            <uix:column>
                                                    <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="DV_VIEW_NAME_TXT@dvAdminMsgs" 
                                                                                        sortable="true" 
                                                                                        shortDescBinding="DV_VIEW_NAME_TXT@dvAdminMsgs" />
                                                    </uix:columnHeader>
                                                    <uix:columnFormat columnDataFormat="textFormat" />
                                                    <uix:styledText textBinding="RULE_NAME" />
                                            </uix:column>
                                            <uix:column>
                                                    <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="DV_RULESET_RULES_EXP@dvAdminMsgs" 
                                                                                        sortable="true" 
                                                                                        shortDescBinding="DV_RULESET_RULES_EXP@dvAdminMsgs" />
                                                    </uix:columnHeader>
                                                    <uix:columnFormat columnDataFormat="textFormat" />
                                                    <uix:styledText textBinding="RULE_EXPRESSION" />
                                            </uix:column>
                                            
										</uix:table>
								</uix:dataScope>
							</uix:contents>								
							</uix:header>
								
						</uix:contents>

		       <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton 
					textBinding="DV_POLICY_MGMT_OK_TXT@dvPolicyMgmtMsgs" 
					shortDescBinding="DV_POLICY_MGMT_OK_TXT@dvPolicyMgmtMsgs" 
					name="event" value="CANCEL_VIEW_DV_COMPONENT"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                      <uix:pageStatus>
                                    <uix:formattedText styleUsage="instruction"
						        textBinding="DV_VIEW_RULESET_INS_TXT@dvAdminMsgs"/>
                      </uix:pageStatus>                      


					</uix:pageLayout>
                  </uix:contents>
                </db:form>
   </uix:body>
   </uix:document>
   </uix:renderingContext>
                                             						
