<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
  
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
  <%@ page import="oracle.sysman.db.rsc.sec.EUSMsg"%>
  <%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSConstants"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponentsDataSourceConstants"%>  
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponents"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponentType"%>
  <%@ page import="java.util.ResourceBundle"%>
  <%@ page import="oracle.sysman.emo.util.UIXDataSource"%>
  <%@ page import="oracle.sysman.db.adm.ParameterNames"%>
  <%@ page import="java.util.Map"%>
  <%@ page import="java.util.Set"%>
  <%@ page import="java.util.List"%>
  <%@ page import="java.util.HashMap"%>
  <%@ page import="java.util.Iterator"%>
  
  
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="olsMsgs" class="oracle.sysman.db.rsc.sec.OLSOIDMsg"/>
    <uix:bundle name="eusMsgs" class="oracle.sysman.db.rsc.sec.EUSMsg"/>

  
  <uix:document>
     <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
  <uix:body>
      <%
        int iComponentType=3;
        String sComponentName="";
        if(request.getAttribute(EUSConstants.EUS_COMPONENT_TYPE) != null)
          iComponentType=((EUSComponentType)request.getAttribute(EUSConstants.EUS_COMPONENT_TYPE)).getType();
        ResourceBundle eusBundle=NLSUtil.getBundle(EUSMsg.class.getName(), request);  
        if(request.getAttribute(EUSConstants.CONFIGURE_COMPONENT_PAGE_TITLE) != null)
          sComponentName=(String) request.getAttribute(EUSConstants.CONFIGURE_COMPONENT_PAGE_TITLE);                
        String sConfirmDeleteMessage=eusBundle.getString("EUS_DOMAIN_DELETE_CONFIRM_INS_TEXT") + sComponentName + " ? ";
      %>
    <uix:form name="form0" method="POST">
        <uix:formValue name="<%=ParameterNames.PAGE_NAME%>" value="<%=EUSConstants.EUS_COMPONENT_DELTE_CONFIRM_JSP%>"/>
        <uix:formValue name="<%=EUSConstants.EUS_COMPONENT_TYPE%>" value="<%=iComponentType%>" />
        <uix:formValue name="event" value="<%=EUSConstants.EUS_REMOVE_COMPONENT_PAGE%>"/>
 <uix:formValue name="selectionMode_3" valueBinding="selectionMode_3@servletRequest"/>

    <uix:pageLayout title="<%=eusBundle.getString(\"DELETE_CONFIRMATION_PAGE_TITLE\")%>">
        <%@ include file="/enablePPR.jspf" %>
        <%@ include file="/oemGlobal.jspf" %>                  
        <%@ include file="/database/security/common/entdbseclogout.jspf" %>
        <oem:messageBox messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" mainTextKey="mainText"/>

        <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
                      
           <uix:tableLayout width="100%" cellPadding="5" cellSpacing="5">
                  <uix:rowLayout hAlign="right">
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton name="<%=EUSConstants.IS_CONFIRMED%>" value="cancel" text="<%=eusBundle.getString(\"EUS_NO_TEXT\")%>"/>
                            <uix:submitButton name="<%=EUSConstants.IS_CONFIRMED%>" value="true" text="<%=eusBundle.getString(\"EUS_YES_TEXT\")%>"/>
                          </uix:contents>
                        </uix:pageButtonBar>                       
                  </uix:rowLayout>
              </uix:tableLayout>                       
                      
                      
            <uix:tableLayout width="100%" cellPadding="1" cellSpacing="5">
                <uix:rowLayout>
                  <uix:styledText styleClass="OraDataText" text="<%=sConfirmDeleteMessage%>" />
                </uix:rowLayout>
            </uix:tableLayout>            
    
          <uix:location>
            <uix:breadCrumbs>
                         <uix:link shortDescBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" textBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" destination="/console/database/EntDBSec?event=dbLogin"/>
              <uix:link shortDescBinding="EUS_ENTERPRISE_USER_SECURITY_TEXT@eusMsgs" textBinding="EUS_ENTERPRISE_USER_SECURITY_TEXT@eusMsgs" destination="/console/database/EntDBSec?event=LAUNCHMODULE&configuremodule=/database/EntDBSec/EUS/EUSComponents" />
            
            
              <%
                String sDestination="/console/database/EntDBSec/EUS/EUSComponents?event=EUS_COMPONENTS_MAIN_PAGE&EUS_COMPONENT_TYPE="+iComponentType;
                String sBreadCrumbMainPageTitle=eusBundle.getString("COMPONENT_TYPE_"+iComponentType+"_PAGE_TITLE");                
              %>                
              <uix:link text="<%=sBreadCrumbMainPageTitle%>" destination="<%=sDestination%>" shortDesc="<%=sBreadCrumbMainPageTitle%>"  />              
              <uix:link/>
            </uix:breadCrumbs>
          </uix:location>                    
    
           <uix:tableLayout width="100%" cellPadding="5" cellSpacing="5">
                  <uix:rowLayout hAlign="right">
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton name="<%=EUSConstants.IS_CONFIRMED%>" value="cancel" text="<%=eusBundle.getString(\"EUS_NO_TEXT\")%>"/>
                            <uix:submitButton name="<%=EUSConstants.IS_CONFIRMED%>" value="true" text="<%=eusBundle.getString(\"EUS_YES_TEXT\")%>"/>
                          </uix:contents>
                        </uix:pageButtonBar>                       
                  </uix:rowLayout>
              </uix:tableLayout>                       
            
            
        </uix:pageLayout>
    </uix:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>
                    
