<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
  
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
  <%@ page import="oracle.sysman.db.rsc.sec.EUSMsg"%>
  <%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSConstants"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponentsDataSourceConstants"%>  
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponents"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponentType"%>
  <%@ page import="java.util.ResourceBundle"%>
  <%@ page import="oracle.sysman.emo.util.UIXDataSource"%>
  <%@ page import="oracle.sysman.db.adm.ParameterNames"%>
  <%@ page import="java.util.Map"%>
  <%@ page import="java.util.Set"%>
  <%@ page import="java.util.List"%>
  <%@ page import="java.util.HashMap"%>
  <%@ page import="java.util.Iterator"%>
  
  
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    
      <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
       <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
       <uix:bundle name="olsMsgs" class="oracle.sysman.db.rsc.sec.OLSOIDMsg"/>
       <uix:bundle name="eusMsgs" class="oracle.sysman.db.rsc.sec.EUSMsg"/>

  
 
                  <%
                    int iComponentType=3;
                    if(request.getAttribute(EUSConstants.EUS_COMPONENT_TYPE) != null)
                      iComponentType=((EUSComponentType)request.getAttribute(EUSConstants.EUS_COMPONENT_TYPE)).getType();
                    ResourceBundle eusBundle=NLSUtil.getBundle(EUSMsg.class.getName(), request);  
                    String sDBOIDAuthMechanism="";
                    String sIsPWDSelected="true";
                    String sIsSSLSelected="false";
                    if(request.getAttribute(EUSConstants.EUS_DB_OID_AUTH_MECHANISM) != null)  
                          sDBOIDAuthMechanism=String.valueOf(request.getAttribute(EUSConstants.EUS_DB_OID_AUTH_MECHANISM));
                    if(sDBOIDAuthMechanism.equalsIgnoreCase("SSL")) 
                    {
                        sIsPWDSelected="false";
                        sIsSSLSelected="true";
                    }
                    
 StringBuffer oemTitle =  (StringBuffer)request.getAttribute("_emSDK_PageTitle");
      oemTitle.append(" - ");
      oemTitle.append(eusBundle.getString("EUS_REALM_CONFIGURATION_PAGE_TITLE"));                    
                        
                  %>

 <uix:document>
     <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head title="<%=oemTitle%>"/>
    </uix:metaContainer>
  <uix:body>
                  
    <uix:form name="form0" method="POST">
        <uix:formValue name="<%=ParameterNames.PAGE_NAME%>" value="<%=EUSConstants.DB_OID_AUTH_MECHANISM_JSP%>"/>
        <uix:formValue name="<%=EUSConstants.EUS_COMPONENT_TYPE%>" value="<%=iComponentType%>" />
        
    <uix:pageLayout title="<%=eusBundle.getString(\"EUS_REALM_CONFIGURATION_PAGE_TITLE\")%>">
        <%@ include file="/enablePPR.jspf" %>
        <%@ include file="/oemGlobal.jspf" %>                  
        <%@ include file="/database/security/common/entdbseclogout.jspf" %>
        <oem:messageBox messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" mainTextKey="mainText"/>

        <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
                      
         <uix:tableLayout width="100%" cellPadding="5" cellSpacing="5">
                <uix:rowLayout hAlign="right">
                  <uix:cellFormat columnSpan="2">
                      <uix:pageButtonBar>
                        <uix:contents>
                          <uix:submitButton name="event" value="<%=EUSConstants.EUS_CANCEL_DB_OID_AUTH_MECHANISM_PAGE%>" 
                                            text="<%=eusBundle.getString(\"EUS_CANCEL_TEXT\")%>"
                                            shortDesc="<%=eusBundle.getString(\"EUS_CANCEL_TEXT\")%>"/>
                          <uix:submitButton name="event" value="<%=EUSConstants.EUS_COMMIT_DB_OID_AUTH_MECHANISM_PAGE%>" 
                                            text="<%=eusBundle.getString(\"EUS_OK_TEXT\")%>"
                                            shortDesc="<%=eusBundle.getString(\"EUS_OK_TEXT\")%>"/>
                        </uix:contents>
                      </uix:pageButtonBar>   
                   </uix:cellFormat>   
                </uix:rowLayout>
          </uix:tableLayout>


        <uix:header text="<%=eusBundle.getString(\"DB_OID_AUTH_HEADER_TEXT\")%>" >
          <uix:tableLayout hAlign="center" width="100%" cellPadding="2" cellSpacing="2">
          <uix:rowLayout>
              <uix:cellFormat>
                    <uix:styledText styleClass="OraInstructionText" 
                                    text="<%=eusBundle.getString(\"DB_OID_AUTH_INS_TEXT\")%>" />
              </uix:cellFormat>
          </uix:rowLayout>
           <uix:rowLayout>
                <uix:cellFormat>
                 <uix:messageChoice id="<%=EUSConstants.EUS_DB_OID_AUTH_MECHANISM%>" name="<%=EUSConstants.EUS_DB_OID_AUTH_MECHANISM%>" prompt="<%=eusBundle.getString(\"DB_OID_AUTH_HEADER_TEXT\")%>">
                   <uix:contents>
                        <uix:option text="<%=eusBundle.getString(\"EUS_AUTH_PWD_TEXT\")%>"
                                    shortDesc="<%=eusBundle.getString(\"EUS_AUTH_PWD_TEXT\")%>"
                                    value="PASSWORD" 
                                    selected="<%=sIsPWDSelected%>"/>
                        <uix:option text="<%=eusBundle.getString(\"EUS_AUTH_SSL_TEXT\")%>" 
                                    shortDesc="<%=eusBundle.getString(\"EUS_AUTH_SSL_TEXT\")%>" 
                                    value="SSL" 
                                    selected="<%=sIsSSLSelected%>"/>
                  </uix:contents>
                </uix:messageChoice>
                </uix:cellFormat>                                   
           </uix:rowLayout>
          
        </uix:tableLayout>
        </uix:header>	  	
        
        
        <uix:header text="<%=eusBundle.getString(\"DB_OID_PWD_HEADER_TEXT\")%>" >
          <uix:tableLayout hAlign="center" width="100%" cellPadding="2" cellSpacing="2">
          <uix:rowLayout>
              <uix:cellFormat>
                     <uix:styledText styleClass="OraInstructionText" 
                                    text="<%=eusBundle.getString(\"DB_OID_PWD_INS_TEXT\")%>" />
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:messageCheckBox id="AUTHENTICATION_TYPES_PWD" 
                                        name="AUTHENTICATION_TYPES_PWD" 
                                        text="<%=eusBundle.getString(\"DB_OID_PWD_HEADER_TEXT\")%>" value="PWD" />
              </uix:cellFormat>
          </uix:rowLayout>
          
        </uix:tableLayout>
        </uix:header>	  	
	
                              
      <uix:location>
            <uix:breadCrumbs>
                         <uix:link shortDescBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" textBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" destination="/console/database/EntDBSec?event=dbLogin"/>
            
              <uix:link shortDescBinding="EUS_ENTERPRISE_USER_SECURITY_TEXT@eusMsgs" textBinding="EUS_ENTERPRISE_USER_SECURITY_TEXT@eusMsgs" destination="/console/database/EntDBSec?event=LAUNCHMODULE&configuremodule=/database/EntDBSec/EUS/EUSComponents" />
            
              <%
                String sDestination="/console/database/EntDBSec/EUS/EUSComponents?event=EUS_COMPONENTS_MAIN_PAGE&EUS_COMPONENT_TYPE="+iComponentType;
                String sBreadCrumbMainPageTitle=eusBundle.getString("COMPONENT_TYPE_"+iComponentType+"_PAGE_TITLE");                
              %>                
              <uix:link text="<%=sBreadCrumbMainPageTitle%>" destination="<%=sDestination%>" shortDesc="<%=sBreadCrumbMainPageTitle%>" />              
              <uix:link />
            </uix:breadCrumbs>
          </uix:location>                    
          
         <uix:tableLayout width="100%" cellPadding="5" cellSpacing="5">
                <uix:rowLayout hAlign="right">
                  <uix:cellFormat columnSpan="2">
                      <uix:pageButtonBar>
                        <uix:contents>
                          <uix:submitButton name="event" value="<%=EUSConstants.EUS_CANCEL_DB_OID_AUTH_MECHANISM_PAGE%>" 
                                            text="<%=eusBundle.getString(\"EUS_CANCEL_TEXT\")%>"
                                            shortDesc="<%=eusBundle.getString(\"EUS_CANCEL_TEXT\")%>"/>
                          <uix:submitButton name="event" value="<%=EUSConstants.EUS_COMMIT_DB_OID_AUTH_MECHANISM_PAGE%>"
                                            text="<%=eusBundle.getString(\"EUS_OK_TEXT\")%>"
                                            shortDesc="<%=eusBundle.getString(\"EUS_OK_TEXT\")%>"/>
                        </uix:contents>
                      </uix:pageButtonBar>   
                   </uix:cellFormat>   
                </uix:rowLayout>
          </uix:tableLayout>
            
            
        </uix:pageLayout>
    </uix:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>
 
