<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.sec.EUSMsg"%>
<%@ page import="oracle.sysman.db.adm.ParameterNames"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emo.adm.security.eus.EUSConstants"%>
<%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponents"%>
<%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponentType"%>
<%@ page import="java.util.ResourceBundle"%>
<% 
  request.setAttribute("eusBundle", new BundleDataObject(NLSUtil.getBundle(EUSMsg.class.getName(), request)));
  String dbVersion = (String)request.getAttribute("DBVERSION");
  ResourceBundle eusBundle=NLSUtil.getBundle(EUSMsg.class.getName(), request);  

  StringBuffer oemTitle =  (StringBuffer)request.getAttribute("_emSDK_PageTitle");
  oemTitle.append(" - ");
  oemTitle.append(eusBundle.getString("EUS_ENTERPRISE_USER_SECURITY_TEXT"));
%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="olsMsgs" class="oracle.sysman.db.rsc.sec.OLSOIDMsg"/>
  <uix:bundle name="eusMsgs" class="oracle.sysman.db.rsc.sec.EUSMsg"/>
  
        <uix:document>
                     <%@ include file="/oemTitle.jspf" %>

          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head title="<%=oemTitle%>"/>
          </uix:metaContainer>
            <uix:body>
                <uix:form name="form0" method="POST"  destination="/console/database/EntDBSec/EUS/EUSComponents" >
                    <uix:pageLayout titleBinding="EUS_ENTERPRISE_USER_SECURITY_TEXT@eusMsgs">
                   	 <%@ include file="/enablePPR.jspf" %>
                         <%@ include file="/oemGlobal.jspf" %>       
                         <%@ include file="/database/security/common/entdbseclogout.jspf" %>
                   
                    <uix:tableLayout hAlign="center" width="100%">
                        <uix:rowLayout>
                            <uix:cellFormat width="60%">
                                <uix:tableLayout hAlign="center">
                                    <%
					EUSComponents eusComponents=(EUSComponents)request.getAttribute(EUSConstants.EUS_COMPONENTS_CACHED_OBJECT);
					EUSComponentType[] eusDistinctComponents=eusComponents.getDistinctComponents();
					int[] eusDistinctComponentsCount=eusComponents.getComponentsCount();
					String sTargetSuffix="&"+ParameterNames.TARGET+"="+request.getAttribute(ParameterNames.TARGET)+
								"&"+ParameterNames.TYPE+"="+request.getAttribute(ParameterNames.TYPE);
					EUSComponentType componentType=null;
					String 		 sComponentDisplayName="";
                                        String           sComponentInsText="";
					String 		 sComponentURL="";
					int 		 iComponentsCount=20;
					int 		 iComponentType=100;
					
					for(int i=0;i<eusDistinctComponents.length;i++)
					{
						componentType=eusDistinctComponents[i];
						iComponentType=componentType.getType();
                                                sComponentDisplayName=eusBundle.getString("EUS_LAUNCHPAGE_COMPONENT"+iComponentType);
                                                sComponentInsText=eusBundle.getString("EUS_LAUNCHPAGE_INS_TXT_COMPONENT"+iComponentType);
						sComponentURL=EUSConstants.EUS_URL_TO_COMPONENTS_MAIN_PAGE+iComponentType+sTargetSuffix;
						iComponentsCount=eusDistinctComponentsCount[i];
                                    %>
                                                <uix:rowLayout>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:styledText styleClass="OraInstructionText" text="<%=sComponentInsText%>" />  
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                                <uix:rowLayout>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:link destination="<%=sComponentURL%>" text="<%=sComponentDisplayName%>" shortDesc="<%=sComponentDisplayName%>" />                                            
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                                <uix:rowLayout>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:spacer height="10"/>                                            
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                    <%
					}                                    
                                    %>
                                  
                                </uix:tableLayout>
                            </uix:cellFormat>
                            <uix:cellFormat width="40%">
                                <uix:contentContainer textBinding="EUS_OVERVIEW_TEXT@eusMsgs" width="100%" shortDescBinding="EUS_OVERVIEW_TEXT@eusMsgs">
                                    <uix:formattedText textBinding="EUS_MAINPAGE_ABOUT_EUS@eusMsgs" styleUsage="instruction"/>
                                </uix:contentContainer>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>

          <uix:location>
            <uix:breadCrumbs>
                         <uix:link shortDescBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" textBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" destination="/console/database/EntDBSec?event=dbLogin"/>
		 <uix:link />
            </uix:breadCrumbs>
          </uix:location>                    
                    
             </uix:pageLayout>     
       </uix:form>
   </uix:body>
   </uix:document>

   </uix:renderingContext>

