<%@ include file="/sdk/oemTop.jspf" %>
  <%@ include file="/oemNoscript.jspf" %>
  
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
  <%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
  <%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
  <%@ page import="oracle.sysman.db.rsc.sec.EUSMsg"%>
  <%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSConstants"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponent"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSComponentType"%>  
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSSubComponentType"%>
  <%@ page import="oracle.sysman.emo.adm.security.eus.EUSSubComponentsDataSourceConstants"%>
  <%@ page import="oracle.sysman.emo.util.UIXDataSource"%>
  <%@ page import="oracle.sysman.db.adm.ParameterNames"%>

  
  <%@ page import="java.util.ResourceBundle"%>
  <%@ page import="java.util.Map"%>
  <%@ page import="java.util.Set"%>
  <%@ page import="java.util.Iterator"%>
  <%@ page import="java.util.TreeSet"%>
  
  <% 
    request.setAttribute("eusBundle", new BundleDataObject(NLSUtil.getBundle(EUSMsg.class.getName(), request)));
    String dbVersion = (String)request.getAttribute("DBVERSION");
  %>
  
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
  
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
    <uix:bundle name="olsMsgs" class="oracle.sysman.db.rsc.sec.OLSOIDMsg"/>
    <uix:bundle name="eusMsgs" class="oracle.sysman.db.rsc.sec.EUSMsg"/>    
    
    <%
        ResourceBundle eusBundle=NLSUtil.getBundle(EUSMsg.class.getName(), request);
        EUSComponent eusComponent=(EUSComponent)request.getAttribute(EUSConstants.EUS_COMPONENT_CACHED_OBJECT);
        int iEUSComponentType=eusComponent.getType().getType();
        String sPageTitle=eusBundle.getString("VIEW_COMPONENT_"+iEUSComponentType+"_PAGE_TITLE");
        sPageTitle = sPageTitle +  request.getAttribute("CONFIGURE_COMPONENT_PAGE_TITLE");       
        EUSSubComponentType subComponentType=null;
        EUSSubComponentType selectedSubComponentType = null;
        //String sFormDestinationURL=EUSConstants.EUS_BASE_URL_TO_COMPONENT_PAGE+iEUSComponentType;
        String sFormDestinationURL=(String)request.getAttribute(EUSConstants.EUS_BASE_URL_TO_COMPONENT);
        String sComponentPropertyNameSuffix="_FOR_COMP_"+iEUSComponentType;    
        String sCurrentJSP="/database/security/eus/eusviewcomponent";
        StringBuffer oemTitle =  (StringBuffer)request.getAttribute("_emSDK_PageTitle");
        oemTitle.append(" - ");
        oemTitle.append(sPageTitle);
        
        
    %>
    <uix:document>
        <%@ include file="/oemTitle.jspf" %>
        <uix:metaContainer>
        <!-- Set the page title -->
          <uix:head title="<%=oemTitle%>"/>
        </uix:metaContainer>
        <uix:body>
          <uix:form name="form0" method="POST"  destination="<%=sFormDestinationURL%>">
            <uix:formValue name="<%=ParameterNames.PAGE_NAME%>" value="<%=sCurrentJSP%>"/>
            <uix:formValue name="<%=EUSConstants.EUS_COMPONENT_TYPE%>" value="<%=iEUSComponentType%>" />
          
          <uix:pageLayout title="<%=sPageTitle%>">
             <%@ include file="/enablePPR.jspf" %>
             <%@ include file="/oemGlobal.jspf" %>       
             <%@ include file="/database/security/common/entdbseclogout.jspf" %>
            <uix:spacer height="10" width="10"/>
    
             <uix:tableLayout width="100%" cellPadding="1" cellSpacing="1">
                  <uix:rowLayout hAlign="right">
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton name="event" value="<%=EUSConstants.EUS_CANCEL_CONFIGURE_COMPONENT%>" text="<%=eusBundle.getString(\"EUS_OK_TEXT\")%>" shortDesc="<%=eusBundle.getString(\"EUS_OK_TEXT\")%>" />
                          </uix:contents>
                        </uix:pageButtonBar>                       
                  </uix:rowLayout>
              </uix:tableLayout>                       
    
              <uix:tableLayout width="100%" cellPadding="1" cellSpacing="1">                      
                  <uix:rowLayout>
                      <uix:cellFormat hAlign="left" width="100%">
                         <uix:tableLayout cellPadding="2" cellSpacing="2" hAlign="left" width="80%">
                                <%
                                      Map componentProperties=eusComponent.getProperties();
                                      if(componentProperties != null && componentProperties.size() > 0)  
                                      {
                                           Set keys=componentProperties.keySet();
                                           TreeSet sortedKeys=new TreeSet(keys);
                                           Iterator iterator=sortedKeys.iterator();
                                           while(iterator.hasNext())
                                           {
                                              String sKey=String.valueOf(iterator.next());
                                              Integer iKey=new Integer(sKey);
                                              String sValue=(String)componentProperties.get(iKey);
                                              
                                %>                                              
                                
                                        <uix:rowLayout>
                                            <uix:cellFormat hAlign="right" width="30%">
                                              <uix:formattedText text="<%=eusBundle.getString(\"EUS_COMPONENT_PROPERTY_\"+sKey+sComponentPropertyNameSuffix)%>" styleUsage="instruction"/>
                                            </uix:cellFormat>
                                            <uix:cellFormat hAlign="left">
                                              <uix:styledText text="<%=sValue%>" styleClass="OraDataText"/>
                                            </uix:cellFormat>
                                        </uix:rowLayout>
                                <%
                                          } 
                                      }                                          
                                %>
                          </uix:tableLayout>    
                      </uix:cellFormat>
                  </uix:rowLayout>
                              
                <%
//                  if(iEUSComponentType==3)
//                  {
                
                    EUSSubComponentType[] eusDistinctSubComponents=eusComponent.getDistinctSubComponentTypes();
                    int iSubComponetsCount=eusDistinctSubComponents.length;
                    String 		 sSubComponentDisplayName="";
                    for(int x=0;x<eusDistinctSubComponents.length;x++)
                    {
                      subComponentType=eusDistinctSubComponents[x];
                      int iSubComponentType=subComponentType.getType();
                      sSubComponentDisplayName=eusBundle.getString("SUB_COMPONENT_"+iSubComponentType+"_TAB_NAME");
                      String sSubComponentInstructionTextKey="INS_TEXT_FOR_SUBCOMP_"+iSubComponentType+"_IN_COMP_"+iEUSComponentType;
                      String sSubComponentInstructionText="";
                      String sDSSummaryText="";
                      String sDSSummaryTextKey="DS_SUMMARY_TXT_FOR_SUBCOMP_"+iSubComponentType+"_IN_COMP_"+iEUSComponentType;
                      if(eusBundle.getString(sSubComponentInstructionTextKey) != null) 
                      {
                          sSubComponentInstructionText= eusBundle.getString(sSubComponentInstructionTextKey);    
                          sDSSummaryText=eusBundle.getString(sDSSummaryTextKey);    
                      }                          
                      int iColCount = ((Integer)((Map)EUSSubComponentsDataSourceConstants.NUM_COLS_EUS_SUBCOMPONENT.get(EUSSubComponentsDataSourceConstants.NUM_COLS_EUS_SUBCOMPS_IN_COMP_STR+iEUSComponentType)).get(EUSSubComponentsDataSourceConstants.NUM_COLS_EUS_SUB_COMP_STR+iSubComponentType)).intValue();                          
                      int iColCountToBeSkippedFromStart = ((Integer)((Map)EUSSubComponentsDataSourceConstants.NUM_COLS_SKIPPED_FROM_PREFIX.get(new Integer(iEUSComponentType))).get(new Integer(iSubComponentType))).intValue();
                      int iColCountToBeSkippedFromEnd = ((Integer)((Map)EUSSubComponentsDataSourceConstants.NUM_COLS_SKIPPED_FROM_SUFFIX.get(new Integer(iEUSComponentType))).get(new Integer(iSubComponentType))).intValue();                      
                      
                %>
                <uix:rowLayout>
                      <uix:tableLayout cellPadding="1" cellSpacing="1" hAlign="left" width="80%">
                      <%
                      if(iColCount >0)
                      {
                      %>
                      <uix:rowLayout>
                          <uix:cellFormat columnSpan="3">
                              <uix:header text="<%=sSubComponentDisplayName%>" />
                          </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>  
                          <uix:cellFormat>
                              <uix:spacer width="15"/>
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:formattedText styleUsage="instruction" text="<%=sSubComponentInstructionText%>"  />                                            
                          </uix:cellFormat>
                          <uix:cellFormat>
                              <uix:spacer width="15"/>
                          </uix:cellFormat>
                       </uix:rowLayout>
                      <uix:rowLayout>  
                          <uix:cellFormat>
                              <uix:spacer width="15"/>
                          </uix:cellFormat>
                          <uix:cellFormat>    
                          <%
                            String sDataSourceBinding="EUS_SUB_COMPONENTS_DATASOURCE_"+iSubComponentType+"@servletRequest";
                            String sUIXTableName="EUS_SUB_COMPONENTS_DATASOURCE_"+iSubComponentType;                            
                          
                          %>
                          <uix:dataScope currentDataBinding="<%=sDataSourceBinding%>">
                            <uix:table name = "<%=sUIXTableName%>" 
                                 alternateTextBinding="EUS_NO_ITEMS_FOUND_TEXT@eusMsgs" width="80%" 
                                  tableDataBinding="rowData" 
                                   minValue="1"
                                   formSubmitted="true"
                                    valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                    blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                    maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                    summary="<%=sDSSummaryText%>"
                                    shortDesc="<%=sDSSummaryText%>">
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                          <%
                                              for(int i=iColCountToBeSkippedFromStart;i<(iColCount-iColCountToBeSkippedFromEnd);i++)
                                              {
                                                  String sDisplayNameKey="SUBCOMP_"+iSubComponentType+"_COMP_"+iEUSComponentType+"_COL"+i;
                                                  String sDisplayName =   eusBundle.getString(sDisplayNameKey);
                                          %>
                                                  <uix:column>
                                                          <uix:columnHeader>
                                                                  <uix:sortableHeader text="<%=sDisplayName%>" 
                                                                                     shortDesc="<%=sDisplayName%>"
                                                                                     sortable="true"/>
                                                          </uix:columnHeader>
                                                          <uix:columnFormat columnDataFormat="textFormat" />
                                                          <uix:styledText textBinding="<%=sDisplayNameKey%>" truncateAt="100" />
                                                  </uix:column>                      
                                            <%
                                              }
                                            %>  
                              </uix:table>
                          </uix:dataScope>
                          </uix:cellFormat>                                            
                          <uix:cellFormat>
                              <uix:spacer width="15"/>
                          </uix:cellFormat>
                      </uix:rowLayout>
                          <%
                          }
                          %>
                      </uix:tableLayout>
                </uix:rowLayout>                                        
                <%
                    }     
//                  }                                      
                %>
     </uix:tableLayout>                                   
     <uix:tableLayout width="100%" cellPadding="1" cellSpacing="1">
            <uix:rowLayout hAlign="right">
                  <uix:pageButtonBar>
                    <uix:contents>
                      <uix:submitButton name="event" value="<%=EUSConstants.EUS_CANCEL_CONFIGURE_COMPONENT%>" text="<%=eusBundle.getString(\"EUS_OK_TEXT\")%>" shortDesc="<%=eusBundle.getString(\"EUS_OK_TEXT\")%>"/>
                    </uix:contents>
                  </uix:pageButtonBar>                       
            </uix:rowLayout>
        </uix:tableLayout>    

          <uix:location>
            <uix:breadCrumbs>
                         <uix:link shortDescBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" textBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" destination="/console/database/EntDBSec?event=dbLogin"/>
            
              <uix:link shortDescBinding="EUS_ENTERPRISE_USER_SECURITY_TEXT@eusMsgs" textBinding="EUS_ENTERPRISE_USER_SECURITY_TEXT@eusMsgs" destination="/console/database/EntDBSec?event=LAUNCHMODULE&configuremodule=/database/EntDBSec/EUS/EUSComponents" />
            
              <%
                String sDestination="/console/database/EntDBSec/EUS/EUSComponents?event=EUS_COMPONENTS_MAIN_PAGE&EUS_COMPONENT_TYPE="+iEUSComponentType;
                String sBreadCrumbMainPageTitle=eusBundle.getString("COMPONENT_TYPE_"+iEUSComponentType+"_PAGE_TITLE");                
              %>                
              <uix:link text="<%=sBreadCrumbMainPageTitle%>" destination="<%=sDestination%>" shortDesc="<%=sBreadCrumbMainPageTitle%>" />              
              <uix:link/>
            </uix:breadCrumbs>
          </uix:location>                    

        
    </uix:pageLayout>     
    </uix:form>
  </uix:body>
  </uix:document>
</uix:renderingContext>
    
    
