<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    <uix:body>
      <db:form name="foo" method="POST" destinationBinding="destination@objectBean@servletRequest" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        
          <uix:formValue name="pageName" value="/database/security/objPrivPage"/>
          <uix:formValue name="miscCode" valueBinding="miscCode@objectBean@servletRequest" />

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="3">
              
                <uix:link textBinding="GENERAL_TAB@uixgranteeBundle@servletRequest"
                onClick="submitForm('foo', true, {event:'generalTab'})"/>
                <uix:link textBinding="ROLE_TAB@uixgranteeBundle@servletRequest" 
                 onClick="submitForm('foo', true, {event:'roleTab'})"/>
                <uix:link textBinding="SYSTEM_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'systemTab'})"/>
                <uix:link textBinding="OBJECT_TAB@uixgranteeBundle@servletRequest" />
                 <uix:switcher childNameBinding="userObject@objectBean@servletRequest">
                 <uix:case name="true">
                 <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                 <uix:case name="false">
                  <uix:link textBinding="QUOTA_TAB@uixuserBundle@servletRequest" 
                    onClick="submitForm('foo', true, {event:'quotaTab'})"/>
                 </uix:case>
                </uix:switcher>
                </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="versionEqualOrHigherTo815@objectBean@servletRequest">
                  <uix:case name="true">
                  <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                 <uix:case name="false">
                     <uix:link textBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest"
                      onClick="submitForm('foo', true, {event:'consumerGrpTab'})"/>
                  </uix:case>
                </uix:switcher>
                </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="userObject@objectBean@servletRequest">
                 <uix:case name="true">
                 <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                 <uix:case name="false">
                <uix:link textBinding="PROXY_TAB@uixuserBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'proxyTab'})"/>
                 </uix:case>
                </uix:switcher>
                </uix:case>
                </uix:switcher>
             
            </uix:subTabBar>
          </uix:subTabs>

              <uix:tableLayout width="100%">
              
          
                <uix:rowLayout hAlign="right">
                  
                    <uix:flowLayout>
                      <uix:styledText labeledNodeId="addObjType" textBinding="ADD_OBJ_PRIV_MSG@uixroleBundle@servletRequest" styleClass="OraPromptText" />
                      <oem:choice id="addObjType" name="addObjType" optionsBinding="allObjectTypes@objectPageBean@servletRequest" selectedValueBinding="addObjType@objectPageBean@servletRequest"/>
                      <uix:submitButton textBinding="ADD_OBJ_PRIV_BTN@uixgranteeBundle@servletRequest" name="event" value="addObjPriv"/>
                    </uix:flowLayout>
                   
                </uix:rowLayout>  
                
                   <uix:rowLayout>
                                     
                      <oem:table name="objPrivsTableUI" beanKey="objectPageBean" blockSize="25"
                              destinationBinding="destination@objectPageBean@servletRequest" formSubmitted="true"
                              summaryBinding="OBJECT_TAB@uixgranteeBundle@servletRequest"
                              dataSourceProp="objPrivsTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%">
                        <uix:tableSelection>
                        <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedIndex="0">
                          <uix:submitButton textBinding="DEL_OBJ_PRIV_BTN@uixgranteeBundle@servletRequest" name="event" value="deleteObjPriv"/>
                        </uix:singleSelection>
                        </uix:tableSelection>
                      </oem:table>
                  </uix:rowLayout>

                </uix:tableLayout>
               
        </uix:subTabLayout>
    
          <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" /> 
	  </uix:pageButtonBar>
        </uix:pageButtons>
        
      </uix:pageLayout>
      </db:form>
      </uix:body>
    
</uix:document>
</uix:renderingContext> 

