<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
         <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
      
        <script>
        function startUsersLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        
      </script>
        <uix:body>
            <db:form name="policyForm" method="post" destination="/console/database/security/ols/policy" copyParams="target,type,oname,objectType,otype,cancelURL,">
                <uix:formValue name="pageName" value="/database/security/ols/advancedTab"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:subTabLayout>
                          <uix:subTabs>
                                <jsp:include page="subTabsInclude.jsp" />
                                <uix:ref refID="subTabsInclude" />
                          </uix:subTabs>
                          <uix:contents>
                          
                          <uix:spacer width="10" height="10"/>
                            <uix:header textBinding="AUDITING@policyMsgs">
                              <uix:contents>
                                <uix:messageStyledText textBinding="AUDIT_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:tableLayout>
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer width="30" height="10"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:stackLayout>
                                              <uix:contents>
                                            <%--    <uix:hideShowHeader id="auditHeader"  text="AuditOptions" disclosedBinding="auditHeaderState@servletRequest" formSubmitted="true" partialRenderMode="self"> --%>
                                                <jsp:include page="auditOptionsInclude.jsp" />
                                                <uix:ref refID="auditOptionsInclude" />
                                               <%-- </uix:hideShowHeader> -- %>
                                                <uix:spacer width="10" height="10"/>
                                                <%--<header text="Related Link">
                                                  <contents>
                                                    <link text="Manage Database Auditing" destination="www"/>
                                                  </uix:contents>
                                                </uix:header> --%>
                                              </uix:contents>
                                            </uix:stackLayout>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                            <uix:header textBinding="POLICY_ADMINS@policyMsgs">
                              <uix:contents>
                                <uix:styledText textBinding="POLICY_ADMIN_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="40%">
                                  <uix:contents>
                                    <uix:rowLayout width="70%">
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer width="10" height="30"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="70%">
                                      <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:button textBinding="ADD@dbMsgs" shortDescBinding="ADD@dbMsgs" onClickBinding="lovDestForAdmins@servletRequest"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                          <uix:dataScope currentDataBinding="policyAdminsList@servletRequest">
                                            <uix:table name="policyAdminsList" 
                                            alternateTextBinding="tableAlterText"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                            minValue="1"
                                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                            summaryBinding="POLICY_LIST_SUMMARY@policyMsgs"
                                            shortDescBinding="POLICY_LIST_SUMMARY@policyMsgs">
                                            <uix:contents>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="NAME@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat"/>
                                                <uix:text textBinding="<%= PolicyMsgID.NAME %>"/>
                                                </uix:column>
                                                
                                            </uix:contents>
                                            <uix:tableSelection>
                                                <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs" >
                                                    <uix:contents>
                                                        <uix:submitButton textBinding="REMOVE@dbMsgs" shortDescBinding="REMOVE@dbMsgs" name="event" value="removeAdmins"/>                          
                                                    </uix:contents>
                                                </uix:multipleSelection>
                                            </uix:tableSelection>
                                            </uix:table>
                                          </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                            <uix:spacer width="10" height="10"/>
                          </uix:contents>
                        </uix:subTabLayout>
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="applyEdit"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>