<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>

<script type="text/javascript">

function submitApply()
{
   document.applTable.action = document.applTable.action + '&event=apply';  
   document.applTable.submit();
   
}

function enableDisableCheckBoxes()
{
  //alert( document.policyForm.enforcementOption[0].checked);
  //alert( document.policyForm.enforcementOption[1].checked);
  
  if(document.applTable.enforcementOption[0].checked || document.applTable.enforcementOption[1].checked)
  {
  
    document.applTable.readControl.checked   = false;
    document.applTable.insertControl.checked = false;
    document.applTable.updateControl.checked = false;
    document.applTable.deleteControl.checked = false;
    document.applTable.labelDefault.checked  = false;
    document.applTable.labelUpdate.checked   = false;
    document.applTable.checkControl.checked  = false;

    document.applTable.readControl.disabled   = true;
    document.applTable.insertControl.disabled = true;
    document.applTable.updateControl.disabled = true;
    document.applTable.deleteControl.disabled = true;
    document.applTable.labelDefault.disabled  = true;
    document.applTable.labelUpdate.disabled   = true;
    document.applTable.checkControl.disabled  = true;
    
    
  }else if(document.applTable.enforcementOption[2].checked){
  
    document.applTable.readControl.disabled   = false;
    document.applTable.insertControl.disabled = false;
    document.applTable.updateControl.disabled = false;
    document.applTable.deleteControl.disabled = false;
    document.applTable.labelDefault.disabled  = false;
    document.applTable.labelUpdate.disabled   = false;
    document.applTable.checkControl.disabled  = false;

  }
  
}

</script>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyApplMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyApplMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
		 <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="applTable" method="post" destination="/console/database/security/ols/policy/appl" copyParams="target,type,otype,objectType,applObjType,policyName,oname,sname">
                <uix:formValue name="pageName" value="/database/security/ols/appl/applyTable"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="policyName" valueBinding="policyName@servletRequest"/>

                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

                      <!-- Main Contents Starts-->
                      <uix:contents>
                        <uix:spacer width="10" height="10"/>
                        <uix:tableLayout width="50%" hAlign="start">
                          <uix:contents>
                            <uix:labeledFieldLayout width="70%">
                              <uix:contents>
                                
                                <uix:messageLovField 
                                    shortDescBinding="TABLE@policyApplMsgs" 
                                    searchDescBinding="TABLE@policyApplMsgs"
                                    name="tableName" 
                                    promptBinding="TABLE@policyApplMsgs" 
                                    textBinding="tableName@applMainBean@servletRequest" 
                                    required="uiOnly" 
                                    disabledBinding="editing@applMainBean@servletRequest"
                                     onClick="startLov('tableName', 'ListTable')"  />

                                <uix:messageCheckBox shortDescBinding="HIDE_COLUMN@policyApplMsgs" textBinding="HIDE_COLUMN@policyApplMsgs" name="hideColumn" messageBinding="HIDE_COLUMN_MSG@policyApplMsgs" checkedBinding="hideColumn@applMainBean@servletRequest"/>                                                                
                                <uix:messageCheckBox shortDescBinding="ENABLED@policyApplMsgs" textBinding="ENABLED@policyApplMsgs" name="enabled" checkedBinding="enabled@applMainBean@servletRequest"/>                                                                
                                
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:tableLayout>
                            <uix:header shortDescBinding="ENFORCEMENT_OPTIONS_HEADER@policyApplMsgs" textBinding="ENFORCEMENT_OPTIONS_HEADER@policyApplMsgs" >
                              <uix:contents>
                                <uix:radioSet name="enforcementOption" onClick='enableDisableCheckBoxes()' >
                              <uix:contents>

                                    <uix:option value="noControl" shortDescBinding="NO_CONTROL@policyApplMsgs" textBinding="NO_CONTROL@policyApplMsgs" selectedBinding="noControl@applMainBean@servletRequest" />
                                    <uix:option value="default" shortDescBinding="DEFAULT_ENFORCEMENT@policyApplMsgs" textBinding="DEFAULT_ENFORCEMENT@policyApplMsgs" selectedBinding="default@applMainBean@servletRequest" />
                                    <uix:option value="apply" shortDescBinding="APPLY_ENFORCEMENT@policyApplMsgs" textBinding="APPLY_ENFORCEMENT@policyApplMsgs" selectedBinding="apply@applMainBean@servletRequest" />

                                <uix:tableLayout>
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer width="10" height="10"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:labeledFieldLayout>
                                              <uix:contents>


                                                    <uix:messageCheckBox shortDescBinding="READ_CONTROL@policyApplMsgs" textBinding="READ_CONTROL@policyApplMsgs"
                                                                         name="readControl" 
                                                                         checkedBinding="readControl@applMainBean@servletRequest"
                                                                         disabledBinding="disableCheckbox@applMainBean@servletRequest" 
                                                                          />
                                                    <uix:messageCheckBox shortDescBinding="INSERT_CONTROL@policyApplMsgs" textBinding="INSERT_CONTROL@policyApplMsgs"
                                                                         name="insertControl" 
                                                                         checkedBinding="insertControl@applMainBean@servletRequest" 
                                                                         disabledBinding="disableCheckbox@applMainBean@servletRequest" 
                                                                         />
                                                    <uix:messageCheckBox shortDescBinding="UPDATE_CONTROL@policyApplMsgs" textBinding="UPDATE_CONTROL@policyApplMsgs"
                                                                         name="updateControl" 
                                                                         checkedBinding="updateControl@applMainBean@servletRequest" 
                                                                         disabledBinding="disableCheckbox@applMainBean@servletRequest" 
                                                                         />
                                                    <uix:messageCheckBox shortDescBinding="DELETE_CONTROL@policyApplMsgs" textBinding="DELETE_CONTROL@policyApplMsgs"
                                                                         name="deleteControl" 
                                                                         checkedBinding="deleteControl@applMainBean@servletRequest" 
                                                                         disabledBinding="disableCheckbox@applMainBean@servletRequest" 
                                                                         />
                                                    <uix:messageCheckBox shortDescBinding="LABEL_DEFAULT@policyApplMsgs" textBinding="LABEL_DEFAULT@policyApplMsgs"
                                                                         name="labelDefault" 
                                                                         checkedBinding="labelDefault@applMainBean@servletRequest" 
                                                                         disabledBinding="disableCheckbox@applMainBean@servletRequest" 
                                                                         />
                                                    <uix:messageCheckBox shortDescBinding="LABEL_UPDATE@policyApplMsgs" textBinding="LABEL_UPDATE@policyApplMsgs"
                                                                         name="labelUpdate" 
                                                                         checkedBinding="labelUpdate@applMainBean@servletRequest" 
                                                                         disabledBinding="disableCheckbox@applMainBean@servletRequest"
                                                                         tipBinding="LABEL_UPDATE_TIP@policyApplMsgs"
                                                                         />
                                                    <uix:messageCheckBox shortDescBinding="CHECK_CONTROL@policyApplMsgs" textBinding="CHECK_CONTROL@policyApplMsgs"
                                                                         name="checkControl" 
                                                                         checkedBinding="checkControl@applMainBean@servletRequest"
                                                                         disabledBinding="disableCheckbox@applMainBean@servletRequest"
                                                                         tipBinding="CHECK_CONTROL_TIP@policyApplMsgs"
                                                                         />


                                              </uix:contents>
                                            </uix:labeledFieldLayout>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:radioSet>
                          </uix:contents>
                        </uix:header>
                        <uix:header shortDescBinding="LABELING_FUNCTION_HEADER@policyApplMsgs" textBinding="LABELING_FUNCTION_HEADER@policyApplMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="LABELING_FUNCTION_INST@policyApplMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:labeledFieldLayout width="50%">
                              <uix:contents>

                                <uix:messageLovField 
                                searchDescBinding="FUNCTION_WITH_PARAMS@policyApplMsgs"
                                shortDescBinding="FUNCTION_WITH_PARAMS@policyApplMsgs" 
                                name="labelingFunc" 
                                promptBinding="FUNCTION_WITH_PARAMS@policyApplMsgs" 
                                textBinding="labelingFunc@applMainBean@servletRequest"  
                                tipBinding="FUNCTION_WITH_PARAMS_TIP@policyApplMsgs" 
                                onClick="startLov('labelingFunc', 'ListFunction')" 
                                />
                                
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header shortDescBinding="PREDICATE@policyApplMsgs" textBinding="PREDICATE@policyApplMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="PREDICATE_INST@policyApplMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:labeledFieldLayout width="60%">
                              <uix:contents>
                                <uix:messageTextInput  textBinding="predicate@applMainBean@servletRequest"  name="predicate" promptBinding="PREDICATE@policyApplMsgs" tipBinding="PREDICATE_TIP@policyApplMsgs" rows="5" columns="35"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:spacer width="10" height="10"/>
                      </uix:contents>
                      <!-- Main Contents Ends-->



                    <!-- navigation -->
                      <uix:pageButtons>

                        <uix:pageButtonBar>
                          <uix:contents>

                            <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                          
                                <uix:switcher defaultCase="false" childNameBinding="editing@applMainBean@servletRequest">

                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>

                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>

                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@applMainBean@servletRequest">

                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="applyEdit"/>
                                    </uix:case>

                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply" onClick="submitApply()" />
                                    </uix:case>

                                </uix:switcher>

                            </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                      <uix:pageStatus>
                        <uix:formattedText textBinding="TABLE_PAGE_STATUS@policyApplMsgs" styleClass="OraInstructionText"/>
                      </uix:pageStatus>

                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
                  
