<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="policyApplMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyApplMsg"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@uixDBObjectBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <db:form name="confirmForm"
             method="post"
             destinationBinding="action@servletRequest"
             copyParams="target,type,cancelURL,policyName,sname,oname,otype,applObjType,objectType">
      <uix:formValue name="pageName" value="/database/confirmationWithOptions"/>
      <uix:formValue name="objectType" valueBinding="objectType@servletRequest"/>
      <uix:formValue name="backURL" valueBinding="backURL@servletRequest"/>
      <uix:formValue name="msgText" valueBinding="msgText@msgTable@servletRequest"/>
      
      <uix:contents>
      
        <uix:pageLayout messageType="confirmation">
         <% if (request.getAttribute("em2goApp") != null) {%>
                    <%@ include file="/em2go/em2goGlobal.jspf" %>
                    <% } else {%>
                    <%@ include file="/database/globalPopup.jspf" %>
                    <%} %>

                    <% if (request.getAttribute("em2goApp") != null) {%>
                    <%@ include file="/em2go/em2goFooter.jspf" %>
                    <%}%>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

         <uix:stackLayout>
 

             <uix:styledText styleClass="OraDataText"
                             textBinding="msgText@msgTable@servletRequest"/>
 
            <uix:messageCheckBox shortDescBinding="DROP_COLUMN@policyApplMsgs" textBinding="DROP_COLUMN@policyApplMsgs" name="dropColumn" messageBinding="DROP_COLUMN_MSG@policyApplMsgs"  />

           
         </uix:stackLayout>   

          <uix:pageButtons>
            <uix:pageButtonBar>

    
              <uix:button textBinding="NO@uixDBObjectBundle@servletRequest" shortDescBinding="NO@uixDBObjectBundle@servletRequest"
                      destinationBinding="backURL@servletRequest"/>
                      
              <uix:submitButton textBinding="YES@uixDBObjectBundle@servletRequest" 
                                shortDescBinding="YES@uixDBObjectBundle@servletRequest"
                                name="event"
                                value="doDelete"
                                
                                />
                                
                      
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>

      </uix:contents>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>



