<%--
  -- Page:       subTabsInclude.jsp
  -- Controller: db/adm/sec/ols/PolicyController.java
  -- 
  -- Description: This handles all of the policy subtabs.
  --              All events should be named: subTab<tabName>.
  --              In onEvent any event that starts with "subTab"
  --              will be forwarded to the onSubTab function where
  --              it will be handled.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="subTabsInclude">

<%-- Define Msg Bundles --%>
<uix:dataScope>

<uix:subTabBar selectedIndexBinding="selectedTab@servletRequest">

  <%-- General Tab --%>
  <db:link textBinding="TABLES@policyApplMsgs"
           shortDescBinding="TABLES@policyApplMsgs"
           onClick="submitForm('applList', true, {event:'subTabTables'})"
           copyParams="target,type,oname,otype,objectType,policyName" />

  <%-- Storage Tab --%>
  
      <db:link textBinding="SCHEMAS@policyMsgs"
           shortDescBinding="SCHEMAS@policyMsgs"
           onClick="submitForm('applList', true, {event:'subTabSchemas'})"
           copyParams="target,type,oname,otype,objectType,policyName" />
               
 
 

</uix:subTabBar>
</uix:dataScope>
</uix:buildTree>