<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyApplMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyApplMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="applList" method="post" destination="/console/database/security/ols/policy/appl" copyParams="target,type,otype,objectType,applObjType,policyName">
                <uix:formValue name="pageName" value="/database/security/ols/appl/tablesList"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:subTabLayout>
                            <uix:subTabs>
                                <jsp:include page="subTabsInclude.jsp" />
                                <uix:ref refID="subTabsInclude" />
                            </uix:subTabs>
                          <uix:contents>
                          <uix:messageStyledText textBinding="TABLE_APPLY_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                        <uix:header textBinding="SEARCH@dbMsgs">
                            <uix:contents>
                                <uix:tableLayout width="100%">
                                    <uix:contents>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:cellFormat width="60%" vAlign="top">
                                                    <uix:contents>
                                                        <uix:styledText textBinding="TABLES_SEARCH_TIP@policyApplMsgs" styleClass="OraInstructionText"/>
                                                        <uix:rowLayout>
                                                            <uix:contents>
                                                                <uix:cellFormat>
                                                                    <uix:contents>
                                                                        <uix:spacer width="10" height="10"/>
                                                                    </uix:contents>
                                                                </uix:cellFormat>
                                                            </uix:contents>
                                                        </uix:rowLayout>
                                                        <uix:tableLayout width="45%" cellSpacing="5">
                                                            <uix:contents>
                                                                <uix:rowLayout width="100%">
                                                                    <uix:contents>
                                                                        <uix:cellFormat hAlign="right">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText labeledNodeId="tableSchemaName" styleClass="OraInstructionText" textBinding="SCHEMA@dbMsgs"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat/>
                                                                        <uix:cellFormat hAlign="left">
                                                                            <uix:contents>
                                                                                <uix:messageLovField shortDescBinding="SCHEMA@dbMsgs" 
                                                                                searchDescBinding="SCHEMA@dbMsgs"
                                                                                id="tableSchemaName" name="tableSchemaName" onClick="startLov('tableSchemaName','ListSchema')"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout width="100%">
                                                                    <uix:contents>
                                                                        <uix:cellFormat hAlign="right">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText labeledNodeId="applObjSearchName" styleClass="OraInstructionText" textBinding="TABLE@dbMsgs"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat/>
                                                                        <uix:cellFormat hAlign="left">
                                                                            <uix:contents>
                                                                                <uix:messageTextInput shortDescBinding="TABLE@dbMsgs" id="applObjSearchName" name="applObjSearchName"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat> 
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout width="100%">
                                                                    <uix:contents>
                                                                        <uix:cellFormat/>
                                                                        <uix:cellFormat/>
                                                                        <uix:cellFormat hAlign="left" width="75%">
                                                                            <uix:contents>
                                                                                <uix:submitButton shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                        
                                                        <uix:spacer width="10" height="10"/>
                                                        <uix:separator/>
                                                        <uix:spacer width="10" height="20"/>
                                                        <uix:tableLayout width="85%">
                                                            <uix:contents>
                                                         
                                                                <uix:rowLayout width="100%">
                                                                    <uix:contents>
                                                                        <uix:cellFormat hAlign="right">
                                                                            <uix:contents>
                                                                                <uix:submitButton  shortDescBinding="CREATE@dbMsgs" textBinding="CREATE@dbMsgs" name="event" value="create"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout width="100%">
                                                                    <uix:contents>
                                                                        <uix:cellFormat width="90%">
                                                                            <uix:contents>
                                                                             <uix:dataScope currentDataBinding="tablesList@servletRequest">
                                                                                 <uix:table name="tablesList" 
                                                                                 alternateTextBinding="tableAlterText"
                                                                                 formSubmitted="true"
                                                                                 width="100%"
                                                                                 tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                                                 minValue="1"
                                                                                 valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                                                 blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                                                 maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                                                 summaryBinding="POLICY_TABLES_SUMMARY@policyMsgs"
                                                                                 shortDescBinding="POLICY_TABLES_SUMMARY@policyMsgs">
               
                                                                                 <uix:tableFormat tableBanding="rowBanding"/>
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                     <uix:sortableHeader textBinding="TABLE@dbMsgs" sortable="yes"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                                                                 <uix:text textBinding="<%= PolicyMsgID.NAME %>" />
                                                                                 </uix:column>
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                     <uix:sortableHeader textBinding="SCHEMA@policyMsgs" sortable="yes"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                                                 <uix:text  textBinding="<%= PolicyMsgID.SCHEMA %>" />
                                                                                 </uix:column>
            
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                     <uix:sortableHeader textBinding="ENFORCEMENT_OPTIONS@policyMsgs" sortable="no"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="textFormat" width="45%"/>
                                                                                 <uix:text textBinding="<%= PolicyMsgID.ENFORCEMENT_OPTIONS %>"/>
                                                                                 </uix:column>
                                                
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                     <uix:sortableHeader textBinding="ENABLED@policyMsgs" sortable="no"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="iconButtonFormat" width="10%"/>
                                                                                 <uix:image shortDescBinding="ENABLED@policyMsgs" sourceBinding="<%= PolicyMsgID.ENABLED %>"/>
                                                                                 </uix:column>
     
                                                                                  <uix:tableSelection>
                                                                               
                                                                                 <uix:singleSelection shortDescBinding="POLICY_SELECT@policyMsgs" selectedIndex="0">
                                                                                 <uix:contents>
                                                                                 <uix:submitButton textBinding="EDIT@dbMsgs" shortDescBinding="EDIT@dbMsgs" name="event" value="edit"/>
                                                                                 <uix:submitButton textBinding="VIEW@dbMsgs" shortDescBinding="VIEW@dbMsgs" name="event" value="view"/>
                                                                                 <uix:submitButton textBinding="CREATE_LIKE@dbMsgs" shortDescBinding="CREATE_LIKE@dbMsgs" name="event" value="createLike"/>
                                                                                 <uix:submitButton textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="delete"/>
                                                                                 
                                                                                  </uix:contents>
                                                                                 </uix:singleSelection>
                                                                                 </uix:tableSelection>
                                                                                 </uix:table>
                                                                             </uix:dataScope>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>
                            </uix:contents>
                        </uix:header>
                        </uix:contents> 
                        </uix:subTabLayout> 
                    </uix:contents>
                    <!-- navigation -->
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
                  
