<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyApplMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyApplMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="applTable" method="post" destination="/console/database/security/ols/policy/appl" copyParams="target,type,otype,objectType,policyName,oname,sname">
                <uix:formValue name="pageName" value="/database/security/ols/appl/viewApplySchema"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="policyName" valueBinding="policyName@servletRequest"/>

                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

                      <!-- Main Contents Starts-->
                      <uix:contents>
                        <uix:spacer width="10" height="10"/>
                        <uix:tableLayout width="50%" hAlign="start">
                          <uix:contents>
                            <uix:labeledFieldLayout width="70%">
                              <uix:contents>


                    <uix:messageStyledText shortDescBinding="SCHEMA@policyApplMsgs" textBinding="schemaName@applMainBean@servletRequest"  promptBinding="SCHEMA@policyApplMsgs" styleClass="OraDataText"/>
                    <uix:messageStyledText shortDescBinding="ENABLED@policyApplMsgs" textBinding="enabled@applMainBean@servletRequest"  promptBinding="ENABLED@policyApplMsgs" styleClass="OraDataText"/>
                    <uix:messageStyledText shortDescBinding="ENFORCEMENT_OPTIONS_HEADER@policyApplMsgs" textBinding="enforcementOptionsForView@applMainBean@servletRequest"  promptBinding="ENFORCEMENT_OPTIONS_HEADER@policyApplMsgs" styleClass="OraDataText"/>

                               </uix:contents>
                            </uix:labeledFieldLayout>

                          </uix:contents>
                         </uix:tableLayout>
                        <uix:spacer width="10" height="10"/>
                      </uix:contents>
                      <!-- Main Contents Ends-->


                    <!-- navigation -->
                      <uix:pageButtons>

                        <uix:pageButtonBar>
                          <uix:contents>

                            <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="cancel"/>
                          
                            </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>


                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
                  
