<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="policyForm" method="post"  destination="/console/database/security/ols/policy/auth" copyParams="target,type,oname,objectType,otype,policyName,authobjType">
                <uix:formValue name="pageName" value="/database/security/ols/auth/editUserAudit"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:subTabLayout>
                            <uix:subTabs>
                                <jsp:include page="editUsersubTabInclude.jsp" />
                                <uix:ref refID="editUsersubTabInclude" />
                            </uix:subTabs>
                          <uix:contents> 
                    
                          <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:styledText textBinding="AUDIT_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer width="10" height="30"/>
                        <uix:dataScope currentDataBinding="auditOptionsList@servletRequest">
                            <uix:table name="auditOptionsList" 
                            alternateTextBinding="tableAlterText"
                            formSubmitted="true"
                            width="70%"
                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                            minValue="1"
                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                            summaryBinding="AUDIT_OPTIONS_SUMMARY@policyAuthMsgs"
                            shortDescBinding="AUDIT_OPTIONS_SUMMARY@policyAuthMsgs">
                            <uix:contents>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="OPERATION@policyMsgs" sortable="no"/>
                                </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                <uix:text textBinding="<%= PolicyMsgID.OPERATION %>"/>
                                </uix:column>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="AUDIT_ON_SUC_BY@policyMsgs" sortable="no"/>
                                </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="25%"/>
                                <uix:choice shortDescBinding="AUDIT_ON_SUC_BY@policyMsgs" name="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>" selectedValueBinding="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>">
                                    <uix:contents>
                                        <uix:option textBinding="NONE@policyMsgs" value="0"/>
                                        <uix:option textBinding="SESSION@policyMsgs" value="1"/>
                                        <uix:option textBinding="ACCESS@policyMsgs" value="2"/>
                                    </uix:contents>
                                </uix:choice>
                                                
                                </uix:column>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="AUDIT_ON_FAIL_BY@policyMsgs" sortable="no"/>
                                </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="25%"/>
                                <uix:choice shortDescBinding="AUDIT_ON_FAIL_BY@policyMsgs" name="<%= PolicyMsgID.AUDIT_ON_FAIL_BY %>" selectedValueBinding="<%= PolicyMsgID.AUDIT_ON_FAIL_BY %>">
                                    <uix:contents>
                                        <uix:option textBinding="NONE@policyMsgs" value="0"/>
                                        <uix:option textBinding="SESSION@policyMsgs" value="1"/>
                                        <uix:option textBinding="ACCESS@policyMsgs" value="2"/>
                                    </uix:contents>
                                </uix:choice>
                                </uix:column>
                            </uix:contents>
                            <uix:tableSelection/>
                                                
                            </uix:table>
                        </uix:dataScope>
                         
               
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="30"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                          
                          
                    </uix:contents>
                    </uix:subTabLayout>
                    
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@authMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@authMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons> 
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>