<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
      
        <script>
        function startCompsLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        function startGroupsLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
      </script>
        <uix:body>
            <db:form name="policyForm" method="post"  destination="/console/database/security/ols/policy/auth" copyParams="target,type,oname,objectType,otype,policyName,authobjType">
                <uix:formValue name="pageName" value="/database/security/ols/auth/editUserLabelComps"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="policyName"  valueBinding="policyName@servletRequest" />
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:subTabLayout>
                            <uix:subTabs>
                                <jsp:include page="editUsersubTabInclude.jsp" />
                                <uix:ref refID="editUsersubTabInclude" />
                            </uix:subTabs>
                          <uix:contents> 
                          
                          <uix:header textBinding="LEVELS@policyMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="LEVELS_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                            <uix:tableLayout width="100%">
                              <uix:contents>
                                <uix:rowLayout width="80%">
                                  <uix:contents>
                                    <uix:cellFormat width="30%" hAlign="left">
                                      <uix:contents>
                                        <uix:spacer width="10" height="10"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <cellFormat width="50%" hAlign="left"/>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="80%">
                                  <uix:contents>
                                    <uix:cellFormat width="50%" vAlign="top" hAlign="left">
                                      <uix:contents>
                                        <uix:labeledFieldLayout>
                                          
                                            <uix:messageLovField name="maxLevel" id="maxLevel" 
                                                textBinding="maxLevel@authMainBean@servletRequest" 
                                                    onClick="setBindSqlParm('policyName'); startLov('maxLevel', 'ListPolicyLevels')" 
                                                    shortDescBinding="maxLevel@authMainBean@servletRequest" promptBinding="MAX_LEVEL@policyAuthMsgs"
                                            searchDescBinding="MAX_LEVEL@policyAuthMsgs" messageBinding="MAX_LEVEL_TIP@policyAuthMsgs"/>
                                           <uix:spacer height="20" width="10"/>
                                            <uix:messageLovField name="minLevel" id="minLevel" 
                                                textBinding="minLevel@authMainBean@servletRequest" 
                                                    onClick="setBindSqlParm('policyName'); startLov('minLevel', 'ListPolicyLevels')" 
                                                    shortDescBinding="minLevel@authMainBean@servletRequest" promptBinding="MIN_LEVEL@policyAuthMsgs"
                                            searchDescBinding="MIN_LEVEL@policyAuthMsgs" messageBinding="MIN_LEVEL_TIP@policyAuthMsgs"/>
                                           
                                        </uix:labeledFieldLayout>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat width="50%" vAlign="top" hAlign="left">
                                      <uix:contents>
                                        <uix:labeledFieldLayout>
                                          
                                            <uix:messageLovField name="defLevel" id="defLevel" 
                                                textBinding="defLevel@authMainBean@servletRequest" 
                                                    onClick="setBindSqlParm('policyName'); startLov('defLevel', 'ListPolicyLevels')" 
                                                    shortDescBinding="defLevel@authMainBean@servletRequest" promptBinding="DEF_LEVEL@policyAuthMsgs"
                                            searchDescBinding="DEF_LEVEL@policyAuthMsgs" messageBinding="DEF_LEVEL_TIP@policyAuthMsgs"/>
                                          <uix:spacer height="10" width="10"/>
                                            <uix:messageLovField name="rowLevel" id="rowLevel" 
                                                textBinding="rowLevel@authMainBean@servletRequest" 
                                                    onClick="setBindSqlParm('policyName'); startLov('rowLevel', 'ListPolicyLevels')" 
                                                    shortDescBinding="rowLevel@authMainBean@servletRequest" promptBinding="ROW_LEVEL@policyAuthMsgs"
                                            searchDescBinding="ROW_LEVEL@policyAuthMsgs" messageBinding="ROW_LEVEL_TIP@policyAuthMsgs"/>
                                          </uix:labeledFieldLayout>
                                              
                                         
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="COMPARTMENTS@policyMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="COMPARTMENTS_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:tableLayout width="60%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:button textBinding="ADD@dbMsgs" onClickBinding="lovDestForComps@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:dataScope currentDataBinding="policyAuthCompsList@servletRequest">
                                        <uix:table name="policyAuthCompsList" 
                                        alternateTextBinding="tableAlterText"
                                        formSubmitted="true"
                                        width="100%"
                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                        minValue="1"
                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                        summaryBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs"
                                        shortDescBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs">
               
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        <uix:formValue name="<%= PolicyMsgID.SHORT_NAME %>" valueBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="WRITE@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.WRITE %>" checkedBinding="<%= PolicyAuthMsgID.WRITE %>"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="DEFAULT@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.DEFAULT %>" checkedBinding="<%= PolicyAuthMsgID.DEFAULT %>"/>
                                        </uix:column>       
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="ROW@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.ROW %>" checkedBinding="<%= PolicyAuthMsgID.ROW %>"/>
                                        </uix:column>
     
                                        <uix:tableSelection>
                                                                               
                                            <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs">
                                                <uix:contents>
                                                                                 
                                                    <uix:submitButton textBinding="REMOVE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="deleteCompartments"/>
                                                                                 
                                                                                                        
                                                </uix:contents>
                                            </uix:multipleSelection>
                                        </uix:tableSelection>		
                                        </uix:table>
                                    </uix:dataScope>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="GROUPS@policyMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="GROUPS_INSTR@policyAUthMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:tableLayout width="60%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:button textBinding="ADD@dbMsgs" onClickBinding="lovDestForGroups@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:dataScope currentDataBinding="policyAuthGroupsList@servletRequest">
                                        <uix:table name="policyAuthGroupsList" 
                                        alternateTextBinding="tableAlterText"
                                        formSubmitted="true"
                                        width="100%"
                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                        minValue="1"
                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                        summaryBinding="GROUPS_LIST_SUMMARY@policyMsgs"
                                        shortDescBinding="GROUPS_LIST_SUMMARY@policyMsgs">
               
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        <uix:formValue name="<%= PolicyMsgID.SHORT_NAME %>" valueBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="WRITE@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.WRITE %>" checkedBinding="<%= PolicyAuthMsgID.WRITE %>"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="DEFAULT@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.DEFAULT %>" checkedBinding="<%= PolicyAuthMsgID.DEFAULT %>"/>
                                        </uix:column>       
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="ROW@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.ROW %>" checkedBinding="<%= PolicyAuthMsgID.ROW %>"/>
                                        </uix:column>
     
                                        <uix:tableSelection>
                                                                               
                                            <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs" >
                                                <uix:contents>
                                                                                 
                                                    <uix:submitButton textBinding="REMOVE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="deleteGroups"/>
                                                                                 
                                                                                                        
                                                </uix:contents>
                                            </uix:multipleSelection>
                                        </uix:tableSelection>		
                                        </uix:table>
                                    </uix:dataScope>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="30"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                          
                          </uix:contents>
                    </uix:subTabLayout>
                    
                    
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@authMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@authMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons> 
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>