<%--
  -- Page:       subTabsInclude.jsp
  -- Controller: db/adm/sec/ols/PolicyAuthObjController.java
  -- 
  -- Description: This handles all of the policy subtabs.
  --              All events should be named: subTab<tabName>.
  --              In onEvent any event that starts with "subTab"
  --              will be forwarded to the onSubTab function where
  --              it will be handled.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="editUsersubTabInclude">

<%-- Define Msg Bundles --%>
<uix:dataScope>

<uix:subTabBar selectedIndexBinding="selectedTab@servletRequest">

  <%-- General Tab --%>
  <db:link textBinding="PRIVILEGES@policyMsgs"
           shortDescBinding="PRIVILEGES@policyMsgs"
           onClick="submitForm('policyForm', true, {event:'subTabGeneral'})"
           copyParams="target,type,oname,otype,objectType," />

  <%-- Storage Tab --%>
  
      <db:link textBinding="LABEL_COMPS@policyMsgs"
               shortDescBinding="LABEL_COMPS@policyMsgs"
               onClick="submitForm('policyForm', true, {event:'subTabLabelComps'})" 
               copyParams="target,type,oname,otype,objectType," />
               
  <%-- LOB Tab --%>
  
      <db:link textBinding="ADVANCED@policyMsgs"
               shortDescBinding="ADVANCED@policyMsgs"
               onClick="submitForm('policyForm', true, {event:'subTabAdvanced'})" 
               copyParams="target,type,oname,otype,objectType," />
 

</uix:subTabBar>
</uix:dataScope>
</uix:buildTree>

