<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
   
            <uix:head titleBinding="title@servletRequest"/>

      
       
    </uix:metaContainer>
    
    <uix:body>

   <db:form name="compsLov" method="post" 
            destinationBinding="dest@servletRequest"
            copyParams="target,type, oname,otype,objectType,policyName ">

              <uix:pageLayout titleBinding="header@servletRequest">
         
        <uix:formValue name="pageName" value="/database/security/ols/auth/policyCompsList"/>
        <uix:formValue name="policyCompType" valueBinding="policyCompType@servletRequest"/>

          <uix:tableLayout cellSpacing="2" width="80%">
         <uix:dataScope currentDataBinding="policyCompsList@servletRequest">
            
	        <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RESULT@dbMsgs">
                    <uix:table name="policyCompsList" 
                                                alternateTextBinding="usersAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="LONG_NAME@policyMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                </uix:column>
                                                <uix:tableSelection>
                                                <uix:multipleSelection >
                                                </uix:multipleSelection>
                                            </uix:tableSelection>
                                                </uix:table>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        </uix:dataScope>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" onClick="javascript:self.close()" />
            <uix:button shortDescBinding="SELECT@dbMsgs" textBinding="SELECT@dbMsgs" onClickBinding="destTable@servletRequest"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>

   </uix:body>
  </uix:document>
 </uix:renderingContext>
