<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
		 <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="policyForm" method="post"  destination="/console/database/security/ols/policy/auth" copyParams="target,type,oname,objectType,otype,policyName,authobjType,cancelURL,sname">
                <uix:formValue name="pageName" value="/database/security/ols/auth/progUnitGeneral"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    
                    <uix:spacer width="10" height="10"/>
                        <uix:tableLayout width="50%" hAlign="start">
                          <uix:contents>
                            <uix:labeledFieldLayout width="70%">
                              <uix:contents>
                                <uix:messageLovField required="uiOnly" disabledBinding="editing@authMainBean@servletRequest" textBinding="progUnitFullName@authMainBean@servletRequest" name="progUnitFullName" promptBinding="PROG_UNIT@policyAuthMsgs"
                                shortDescBinding="PROG_UNIT@policyAuthMsgs" searchDescBinding="PROG_UNIT@policyAuthMsgs" onClick="startLov('progUnitFullName','ListOLSProgUnits')"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:header textBinding="PRIVILEGES@policyMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="PROG_UNIT_PRIV_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:styledText textBinding="ALLOW_PROG_UNIT_TO@policyAuthMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                            <uix:stackLayout>
                                <uix:contents>
                                    <uix:checkBox textBinding="PRIVS_PROFILE_ACCESS@policyAuthMsgs" checkedBinding="privProfileAccess@authMainBean@servletRequest" name="privProfileAccess"/>
                                    <uix:checkBox textBinding="PRIVS_FULL@policyAuthMsgs" checkedBinding="privFull@authMainBean@servletRequest" name="privFull" />
                                    <uix:checkBox textBinding="PRIVS_READ@policyAuthMsgs" checkedBinding="privRead@authMainBean@servletRequest" name="privRead" />
                                    <uix:checkBox textBinding="PRIVS_WRITEUP@policyAuthMsgs" checkedBinding="privWriteup@authMainBean@servletRequest" name="privWriteup" />
                                    <uix:checkBox textBinding="PRIVS_WRITEDOWN@policyAuthMsgs" checkedBinding="privWritedown@authMainBean@servletRequest" name="privWritedown"/>
                                    <uix:checkBox textBinding="PRIVS_WRITEACCROSS@policyAuthMsgs" checkedBinding="privWriteAccross@authMainBean@servletRequest" name="privWriteAccross"/>
                                    <uix:checkBox textBinding="PRIVS_COMPACCESS@policyAuthMsgs" checkedBinding="privCompAccess@authMainBean@servletRequest" name="privCompAccess"/>
                                </uix:contents>
                            </uix:stackLayout>
                            </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:spacer width="10" height="10"/>
                    
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@authMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@authMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons> 
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
