<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="policyForm" method="post"  destination="/console/database/security/ols/policy/auth" copyParams="target,type,oname,objectType,otype,policyName,authobjType">
                <uix:formValue name="pageName" value="/database/security/ols/auth/viewProgUnit"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:tableLayout width="90%">
                          <uix:contents>
                            <uix:rowLayout width="90%">
                              <uix:contents>
                                <uix:cellFormat width="70%">
                                  <uix:contents>
                                    <uix:labeledFieldLayout width="60%">
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="policyName@authMainBean@servletRequest" promptBinding="POLICY_NAME@policyMsgs" styleClass="OraDataText"/>
                                        <uix:messageStyledText textBinding="privsString@authMainBean@servletRequest" promptBinding="PRIVILEGES@policyMsgs" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:labeledFieldLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                       
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        
                     
                   
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="30"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                    
                    </uix:contents>
                    <!-- navigation -->
                     
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>