<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="policyForm" method="post"  destination="/console/database/security/ols/policy/auth" copyParams="target,type,oname,objectType,otype,policyName,authobjType">
                <uix:formValue name="pageName" value="/database/security/ols/auth/viewUser"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:tableLayout width="90%">
                          <uix:contents>
                            <uix:rowLayout width="90%">
                              <uix:contents>
                                <uix:cellFormat width="70%">
                                  <uix:contents>
                                    <uix:labeledFieldLayout width="60%">
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="policyName@authMainBean@servletRequest" shortDescBinding="POLICY_NAME@policyMsgs" promptBinding="POLICY_NAME@policyMsgs" styleClass="OraDataText"/>
                                        <uix:messageStyledText textBinding="privsString@authMainBean@servletRequest" shortDescBinding="PRIVILEGES@policyMsgs" promptBinding="PRIVILEGES@policyMsgs" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:labeledFieldLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                       
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        
                        <uix:header textBinding="LEVELS@policyMsgs">
                          <uix:contents>
                            <uix:tableLayout width="100%">
                              <uix:contents>
                                <uix:rowLayout width="80%">
                                  <uix:contents>
                                    <uix:cellFormat width="30%" hAlign="left">
                                      <uix:contents>
                                        <uix:spacer width="10" height="10"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat width="50%" hAlign="left"/>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="80%">
                                  <uix:contents>
                                    <uix:cellFormat width="30%" vAlign="top" hAlign="left">
                                      <uix:contents>
                                        <uix:labeledFieldLayout>
                                          <uix:contents>
                                            <uix:messageStyledText textBinding="maxLevel@servletRequest" shortDescBinding="MAX_LEVEL@policyAuthMsgs" promptBinding="MAX_LEVEL@policyAuthMsgs" styleClass="OraDataText"/>
                                            <uix:messageStyledText textBinding="minLevel@servletRequest" shortDescBinding="MIN_LEVEL@policyAuthMsgs" promptBinding="MIN_LEVEL@policyAuthMsgs" styleClass="OraDataText"/>
                                          </uix:contents>
                                        </uix:labeledFieldLayout>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" vAlign="top">
                                      <uix:contents>
                                        <uix:labeledFieldLayout>
                                          <uix:contents>
                                            <uix:messageStyledText textBinding="defLevel@servletRequest" shortDescBinding="DEF_LEVEL@policyAuthMsgs" promptBinding="DEF_LEVEL@policyAuthMsgs" styleClass="OraDataText"/>
                                            <uix:messageStyledText textBinding="rowLevel@servletRequest" shortDescBinding="ROW_LEVEL@policyAuthMsgs" promptBinding="ROW_LEVEL@policyAuthMsgs" styleClass="OraDataText"/>
                                          </uix:contents>
                                        </uix:labeledFieldLayout>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="COMPARTMENTS@policyMsgs">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:tableLayout width="60%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:dataScope currentDataBinding="policyAuthCompsList@servletRequest">
                                        <uix:table name="policyAuthCompsList" 
                                        alternateTextBinding="tableAlterText"
                                        formSubmitted="true"
                                        width="100%"
                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                        minValue="1"
                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                        summaryBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs"
                                        shortDescBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs">
               
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        <uix:formValue name="<%= PolicyMsgID.SHORT_NAME %>" valueBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="WRITE@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:image sourceBinding="writeIconDest" shortDescBinding="WRITE@policyAuthMsgs"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="DEFAULT@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:image sourceBinding="defIconDest" shortDescBinding="DEFAULT@policyAuthMsgs"/>
                                        </uix:column>       
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="ROW@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:image sourceBinding="rowIconDest" shortDescBinding="ROW@policyAuthMsgs"/>
                                        </uix:column>
     
                                        <uix:tableSelection/>
                                                                               
                                         
                                        </uix:table>
                                    </uix:dataScope>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="GROUPS@policyMsgs">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:tableLayout width="60%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:dataScope currentDataBinding="policyAuthGroupsList@servletRequest">
                                        <uix:table name="policyAuthGroupsList" 
                                        alternateTextBinding="tableAlterText"
                                        formSubmitted="true"
                                        width="100%"
                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                        minValue="1"
                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                        summaryBinding="GROUPS_LIST_SUMMARY@policyMsgs"
                                        shortDescBinding="GROUPS_LIST_SUMMARY@policyMsgs">
               
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        <uix:formValue name="<%= PolicyMsgID.SHORT_NAME %>" valueBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="WRITE@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:image sourceBinding="writeIconDest" shortDescBinding="WRITE@policyAuthMsgs"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="DEFAULT@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:image sourceBinding="defIconDest" shortDescBinding="DEFAULT@policyAuthMsgs"/>
                                        </uix:column>       
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="ROW@policyAuthMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:image sourceBinding="rowIconDest" shortDescBinding="ROW@policyAuthMsgs"/>
                                        </uix:column>
     
                                        <uix:tableSelection/>
                                                                               
                                           
                                        </uix:table>
                                    </uix:dataScope>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        
                      <uix:switcher defaultCase="false" childNameBinding="saEnabled@servletRequest">

                            <uix:case name="true">

                                    <!-- Only show the Audit options when ols is sa configured. -->

                        <uix:header textBinding="AUDIT@policyAuthMsgs">
                          <uix:contents>
                            <uix:dataScope currentDataBinding="auditOptionsList@servletRequest">
                            <uix:table name="auditOptionsList" 
                            alternateTextBinding="tableAlterText"
                            formSubmitted="true"
                            width="70%"
                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                            minValue="1"
                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                            summaryBinding="AUDIT_OPTIONS_SUMMARY@policyAuthMsgs"
                            shortDescBinding="AUDIT_OPTIONS_SUMMARY@policyAuthMsgs">
                            <uix:contents>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="OPERATION@policyMsgs" sortable="no"/>
                                </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                <uix:text textBinding="<%= PolicyMsgID.OPERATION %>"/>
                                </uix:column>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="AUDIT_ON_SUC_BY@policyMsgs" sortable="no"/>
                                </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="25%"/>
                                <uix:choice readOnly="true" name="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>" selectedValueBinding="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>">
                                    <uix:contents>
                                        <uix:option textBinding="NONE@policyMsgs" value="0"/>
                                        <uix:option textBinding="SESSION@policyMsgs" value="1"/>
                                        <uix:option textBinding="ACCESS@policyMsgs" value="2"/>
                                    </uix:contents>
                                </uix:choice>
                                                
                                </uix:column>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="AUDIT_ON_FAIL_BY@policyMsgs" sortable="no"/>
                                </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="25%"/>
                                <uix:choice readOnly="true" name="<%= PolicyMsgID.AUDIT_ON_FAIL_BY %>" selectedValueBinding="<%= PolicyMsgID.AUDIT_ON_FAIL_BY %>">
                                    <uix:contents>
                                        <uix:option textBinding="NONE@policyMsgs" value="0"/>
                                        <uix:option textBinding="SESSION@policyMsgs" value="1"/>
                                        <uix:option textBinding="ACCESS@policyMsgs" value="2"/>
                                    </uix:contents>
                                </uix:choice>
                                </uix:column>
                            </uix:contents>
                            <uix:tableSelection/>
                                                
                            </uix:table>
                        </uix:dataScope>
                          </uix:contents>
                        </uix:header>
                                    
                            </uix:case>

                    </uix:switcher>
                        
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="30"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                    
                    </uix:contents>
                    <!-- navigation -->
                     
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
