<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="authList" method="post" destination="/console/database/security/ols/policy/auth" copyParams="target,type,otype,objectType,policyName,oname,authobjType">
                <uix:formValue name="pageName" value="/database/security/ols/auth/wizAudit"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:tableLayout width="90%">
                          <uix:contents>
                            <uix:rowLayout width="90%">
                              <uix:contents>
                                <uix:cellFormat width="70%">
                                  <uix:contents>
                                    <uix:labeledFieldLayout width="60%">
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="policyName@authMainBean@servletRequest" promptBinding="POLICY_NAME@policyMsgs" styleClass="OraDataText"/>
                                        <uix:messageStyledText textBinding="formattedUsers@authMainBean@servletRequest" promptBinding="USERS@policyAuthMsgs" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:labeledFieldLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:separator/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:styledText textBinding="AUDIT_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer width="10" height="30"/>
                        <uix:dataScope currentDataBinding="auditOptionsList@servletRequest">
                            <uix:table name="auditOptionsList" 
                            alternateTextBinding="tableAlterText"
                            formSubmitted="true"
                            width="70%"
                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                            minValue="1"
                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                            summaryBinding="AUDIT_OPTIONS_SUMMARY@policyAuthMsgs"
                            shortDescBinding="AUDIT_OPTIONS_SUMMARY@policyAuthMsgs">
                            <uix:contents>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="OPERATION@policyMsgs" sortable="no"/>
                                </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                <uix:text textBinding="<%= PolicyMsgID.OPERATION %>"/>
                                </uix:column>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="AUDIT_ON_SUC_BY@policyMsgs" sortable="no"/>
                                </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="25%"/>
                                <uix:choice shortDescBinding="AUDIT_ON_SUC_BY@policyMsgs" name="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>" selectedValueBinding="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>">
                                    <uix:contents>
                                        <uix:option textBinding="NONE@policyMsgs" value="0"/>
                                        <uix:option textBinding="SESSION@policyMsgs" value="1"/>
                                        <uix:option textBinding="ACCESS@policyMsgs" value="2"/>
                                    </uix:contents>
                                </uix:choice>
                                                
                                </uix:column>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="AUDIT_ON_FAIL_BY@policyMsgs" sortable="no"/>
                                </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="25%"/>
                                <uix:choice shortDescBinding="AUDIT_ON_FAIL_BY@policyMsgs" name="<%= PolicyMsgID.AUDIT_ON_FAIL_BY %>" selectedValueBinding="<%= PolicyMsgID.AUDIT_ON_FAIL_BY %>">
                                    <uix:contents>
                                        <uix:option textBinding="NONE@policyMsgs" value="0"/>
                                        <uix:option textBinding="SESSION@policyMsgs" value="1"/>
                                        <uix:option textBinding="ACCESS@policyMsgs" value="2"/>
                                    </uix:contents>
                                </uix:choice>
                                </uix:column>
                            </uix:contents>
                            <uix:tableSelection/>
                                                
                            </uix:table>
                        </uix:dataScope>
                         
               
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="30"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="5" formSubmitted="true" value="4"/> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:location>
                        <uix:train formSubmitted="true" value="4">
                          <uix:contents>
                            <uix:link textBinding="USERS@policyAuthMsgs"/>
                            <uix:link textBinding="LABEL_COMP_GRPS@policyAuthMsgs"/>
                            <uix:link textBinding="PRIVILEGES@policyMsgs"/>
                            <uix:link textBinding="AUDIT@policyAuthMsgs"/>
                            <uix:link textBinding="REVIEW@policyAuthMsgs"/>
                          </uix:contents>
                        </uix:train>
                      </uix:location>
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
