<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
      
        <script>
        function startCompsLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        function startGroupsLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
      </script>
        <uix:body>
            <db:form name="authList" method="post" destination="/console/database/security/ols/policy/auth" copyParams="target,type,otype,objectType,policyName,oname,authobjType">
                <uix:formValue name="pageName" value="/database/security/ols/auth/wizComps"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="policyName"  valueBinding="policyName@servletRequest" />
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:tableLayout width="90%">
                          <uix:contents>
                            <uix:rowLayout width="90%">
                              <uix:contents>
                                <uix:cellFormat width="70%">
                                  <uix:contents>
                                    <uix:labeledFieldLayout width="60%">
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="policyName@authMainBean@servletRequest" promptBinding="POLICY_NAME@policyMsgs" styleClass="OraDataText"/>
                                        <uix:messageStyledText textBinding="formattedUsers@authMainBean@servletRequest" promptBinding="USERS@policyAuthMsgs" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:labeledFieldLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:separator/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:header textBinding="LEVELS@policyMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="LEVELS_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                            <uix:tableLayout width="100%">
                              <uix:contents>
                                <uix:rowLayout width="80%">
                                  <uix:contents>
                                    <uix:cellFormat width="30%" hAlign="left">
                                      <uix:contents>
                                        <uix:spacer width="10" height="10"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <cellFormat width="50%" hAlign="left"/>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:cellFormat width="50%" vAlign="top" hAlign="left">
                                      <uix:contents>
                                        <uix:labeledFieldLayout>
                                          
                                            <uix:messageLovField name="maxLevel" id="maxLevel" 
                                                textBinding="maxLevel@authMainBean@servletRequest" 
                                                    onClick="setBindSqlParm('policyName'); startLov('maxLevel', 'ListPolicyLevels')" 
                                                    shortDescBinding="maxLevel@authMainBean@servletRequest" promptBinding="MAX_LEVEL@policyAuthMsgs"
                                            searchDescBinding="MAX_LEVEL@policyAuthMsgs" messageBinding="MAX_LEVEL_TIP@policyAuthMsgs"/>
                                            <uix:spacer height="20" width="10"/>
                                            <uix:messageLovField name="minLevel" id="minLevel" 
                                                textBinding="minLevel@authMainBean@servletRequest" 
                                                    onClick="setBindSqlParm('policyName'); startLov('minLevel', 'ListPolicyLevels')" 
                                                    shortDescBinding="minLevel@authMainBean@servletRequest" promptBinding="MIN_LEVEL@policyAuthMsgs"
                                            searchDescBinding="MIN_LEVEL@policyAuthMsgs" messageBinding="MIN_LEVEL_TIP@policyAuthMsgs"/>
                                           
                                        </uix:labeledFieldLayout>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat width="50%" vAlign="top" hAlign="left">
                                      <uix:contents>
                                        <uix:labeledFieldLayout>
                                          
                                            <uix:messageLovField name="defLevel" id="defLevel" 
                                                textBinding="defLevel@authMainBean@servletRequest" 
                                                    onClick="setBindSqlParm('policyName'); startLov('defLevel', 'ListPolicyLevels')" 
                                                    shortDescBinding="defLevel@authMainBean@servletRequest" promptBinding="DEF_LEVEL@policyAuthMsgs"
                                            searchDescBinding="DEF_LEVEL@policyAuthMsgs" messageBinding="DEF_LEVEL_TIP@policyAuthMsgs"/>
                                          <uix:spacer height="10" width="10"/>
                                            <uix:messageLovField name="rowLevel" id="rowLevel" 
                                                textBinding="rowLevel@authMainBean@servletRequest" 
                                                    onClick="setBindSqlParm('policyName'); startLov('rowLevel', 'ListPolicyLevels')" 
                                                    shortDescBinding="rowLevel@authMainBean@servletRequest" promptBinding="ROW_LEVEL@policyAuthMsgs"
                                           searchDescBinding="ROW_LEVEL@policyAuthMsgs" messageBinding="ROW_LEVEL_TIP@policyAuthMsgs"/>
                                          </uix:labeledFieldLayout>
                                              
                                         
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="COMPARTMENTS@policyMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="COMPARTMENTS_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:tableLayout width="60%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:button textBinding="ADD@dbMsgs" onClickBinding="lovDestForComps@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:dataScope currentDataBinding="policyAuthCompsList@servletRequest">
                                        <uix:table name="policyAuthCompsList" 
                                        alternateTextBinding="tableAlterText"
                                        formSubmitted="true"
                                        width="100%"
                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                        minValue="1"
                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                        summaryBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs"
                                        shortDescBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs">
               
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        <uix:formValue name="<%= PolicyMsgID.SHORT_NAME %>" valueBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="WRITE@policyAuthMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.WRITE %>" checkedBinding="<%= PolicyAuthMsgID.WRITE %>"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="DEFAULT@policyAuthMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.DEFAULT %>" checkedBinding="<%= PolicyAuthMsgID.DEFAULT %>"/>
                                        </uix:column>       
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="ROW@policyAuthMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.ROW %>" checkedBinding="<%= PolicyAuthMsgID.ROW %>"/>
                                        </uix:column>
     
                                        <uix:tableSelection>
                                                                               
                                            <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs">
                                                <uix:contents>
                                                                                 
                                                    <uix:submitButton textBinding="REMOVE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="deleteCompartments"/>
                                                                                 
                                                                                                        
                                                </uix:contents>
                                            </uix:multipleSelection>
                                        </uix:tableSelection>		
                                        </uix:table>
                                    </uix:dataScope>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="GROUPS@policyMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="GROUPS_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:tableLayout width="60%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:button textBinding="ADD@dbMsgs" onClickBinding="lovDestForGroups@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                    <uix:dataScope currentDataBinding="policyAuthGroupsList@servletRequest">
                                        <uix:table name="policyAuthGroupsList" 
                                        alternateTextBinding="tableAlterText"
                                        formSubmitted="true"
                                        width="100%"
                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                        minValue="1"
                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                        summaryBinding="GROUPS_LIST_SUMMARY@policyMsgs"
                                        shortDescBinding="GROUPS_LIST_SUMMARY@policyMsgs">
               
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortable="yes"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        <uix:formValue name="<%= PolicyMsgID.SHORT_NAME %>" valueBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="WRITE@policyAuthMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.WRITE %>" checkedBinding="<%= PolicyAuthMsgID.WRITE %>"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="DEFAULT@policyAuthMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.DEFAULT %>" checkedBinding="<%= PolicyAuthMsgID.DEFAULT %>"/>
                                        </uix:column>       
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="ROW@policyAuthMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                        <uix:checkBox name="<%= PolicyAuthMsgID.ROW %>" checkedBinding="<%= PolicyAuthMsgID.ROW %>"/>
                                        </uix:column>
     
                                        <uix:tableSelection>
                                                                               
                                            <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs" >
                                                <uix:contents>
                                                                                 
                                                    <uix:submitButton textBinding="REMOVE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="deleteGroups"/>
                                                                                 
                                                                                                        
                                                </uix:contents>
                                            </uix:multipleSelection>
                                        </uix:tableSelection>		
                                        </uix:table>
                                    </uix:dataScope>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="30"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="5" formSubmitted="true" value="2"/> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:location>
                        <uix:train formSubmitted="true" value="2">
                          <uix:contents>
                            <uix:link textBinding="USERS@policyAuthMsgs"/>
                            <uix:link textBinding="LABEL_COMP_GRPS@policyAuthMsgs"/>
                            <uix:link textBinding="PRIVILEGES@policyMsgs"/>
                            <uix:link textBinding="AUDIT@policyAuthMsgs"/>
                            <uix:link textBinding="REVIEW@policyAuthMsgs"/>
                          </uix:contents>
                        </uix:train>
                      </uix:location>
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
