<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
      
        <script>
        function startUsersLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        
      </script>
        <uix:body>
            <db:form name="authList" method="post" destination="/console/database/security/ols/policy/auth" copyParams="target,type,otype,oname, objectType,policyName,authobjType">
                <uix:formValue name="pageName" value="/database/security/ols/auth/wizUsers"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    
                    <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:tableLayout>
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:labeledFieldLayout>
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="policyName@authMainBean@servletRequest" promptBinding="POLICY_NAME@policyMsgs" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:labeledFieldLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:separator/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:header textBinding="DB_USERS@policyAuthMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="DB_USERS_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer width="10" height="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer width="10" height="30"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:tableLayout>
                              <uix:contents>
                                <uix:rowLayout hAlign="right">
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:button textBinding="ADD@dbMsgs" shortDescBinding="ADD@dbMsgs" onClickBinding="lovDestForDBUsers@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout hAlign="right">
                                  <uix:contents>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:dataScope currentDataBinding="dbUsersList@servletRequest">
                                            <uix:table name="dbUsersList" 
                                            alternateTextBinding="tableAlterText"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                            minValue="1"
                                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                            summaryBinding="DB_USERS_SUMMARY@policyMsgs"
                                            shortDescBinding="DB_USERS_SUMMARY@policyMsgs">
               
                                            <uix:tableFormat tableBanding="rowBanding"/>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="NAME@policyMsgs" sortable="yes"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                            <uix:text textBinding="<%= PolicyMsgID.NAME %>" />
                                            </uix:column>
		<uix:tableSelection>
                                                                               
                    <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs" >
                        <uix:contents>
                            
                            <uix:submitButton textBinding="REMOVE@dbMsgs" shortDescBinding="REMOVE@dbMsgs" name="event" value="removeDBUsers"/>
                                                                                                
                        </uix:contents>
                    </uix:multipleSelection>
		</uix:tableSelection>
                                            </uix:table>
                                        </uix:dataScope>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="NON_DB_USERS@policyAuthMsgs">
                          <uix:contents>
                            <uix:styledText textBinding="NON_DB_USERS_INSTR@policyAuthMsgs" styleClass="OraInstructionText"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer width="10" height="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:tableLayout width="80%">
                              <uix:contents>
                                <uix:rowLayout hAlign="right" width="80%">
                                  <uix:contents>
                                    <uix:cellFormat width="40%" hAlign="left">
                                      <uix:contents>
                                        <uix:dataScope currentDataBinding="nonDbUsersList@servletRequest">
                                            <uix:table name="nonDbUsersList" 
                                            alternateTextBinding="tableAlterText"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                            minValue="1"
                                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                            summaryBinding="NON_DB_USERS_SUMMARY@policyAuthMsgs"
                                            shortDescBinding="NON_DB_USERS_SUMMARY@policyAuthMsgs">
               
                                            <uix:tableFormat tableBanding="rowBanding"/>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="NAME@policyMsgs" sortable="yes"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                            <uix:messageTextInput name="<%= PolicyMsgID.NAME %>" shortDescBinding="NAME@policyMsgs" textBinding="<%= PolicyMsgID.NAME %>" />
                                            </uix:column>
		<uix:tableSelection>
                                                                               
                    <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs" >
                        <uix:contents>
                            
                            <uix:submitButton textBinding="REMOVE@dbMsgs" shortDescBinding="REMOVE@dbMsgs" name="event" value="removeNonDBUsers"/>
                                                                                                
                        </uix:contents>
                    </uix:multipleSelection>
		</uix:tableSelection>
                                            </uix:table>
                                        </uix:dataScope>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout hAlign="right">
                                  <uix:contents>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:submitButton textBinding="ADD5ROWS@policyAuthMsgs" name="event" value="add5NonDbUsers"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="30"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                    
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="5" formSubmitted="true" value="1"/> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>

                   <uix:location>
                        <uix:train selectedIndex="0" formSubmitted="true" value="1">
                          <uix:contents>
                            <uix:link textBinding="USERS@policyAuthMsgs"/>
                            <uix:link textBinding="LABEL_COMP_GRPS@policyAuthMsgs"/>
                            <uix:link textBinding="PRIVILEGES@policyMsgs"/>
                            <uix:link textBinding="AUDIT@policyAuthMsgs"/>
                            <uix:link textBinding="REVIEW@policyAuthMsgs"/> 
                          </uix:contents>
                        </uix:train>
                      </uix:location> 
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
