<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.DataLabelMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="dataLabelMsgs" class="oracle.sysman.db.rsc.sec.ols.DataLabelMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
      
        <script>
        function startCompsLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        function startGroupsLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
      </script>
        <uix:body>
            <db:form name="dataLabelGeneral" method="post" destination="/console/database/security/ols/policy/datalabel" copyParams="target,type,otype,objectType,policyName,oname">
                <uix:formValue name="pageName" value="/database/security/ols/datalabel/dataLabelGeneral"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="policyName"  valueBinding="policyName@servletRequest" />
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    
                    <uix:spacer width="10" height="10"/>
                        <uix:tableLayout width="50%" hAlign="start">
                          <uix:contents>
                            <uix:labeledFieldLayout width="70%">
                              <uix:contents>
                              
                                <uix:messageTextInput required="uiOnly" promptBinding="NUMERIC_TAG@dataLabelMsgs" readOnlyBinding="editing@labelMainBean@servletRequest" name="numericTag" textBinding="numericTag@labelMainBean@servletRequest" tipBinding="NUMERIC_TAG_TIP@dataLabelMsgs"/>
                                <uix:messageLovField searchDescBinding="LEVEL@dataLabelMsgs" required="uiOnly" name="level" id="level" 
                                                textBinding="level@labelMainBean@servletRequest" 
                                                    onClick="setBindSqlParm('policyName'); startLov('level', 'ListPolicyLevels')" 
                                                    shortDescBinding="LEVEL@dataLabelMsgs" promptBinding="LEVEL@dataLabelMsgs"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:header textBinding="COMPARTMENTS@policyMsgs">
                          <uix:contents>
                            <uix:spacer width="10" height="10"/>
                            <uix:tableLayout width="80%">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:button textBinding="ADD@dbMsgs" onClickBinding="lovDestForComps@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:dataScope currentDataBinding="labelCompsList@servletRequest">
            
                                            <uix:rowLayout width="100%">
                                                        <uix:table name="labelCompsList" 
                                                        alternateTextBinding="usersAlterText"
                                                        formSubmitted="true"
                                                        width="100%"
                                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                        minValue="1"
                                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                        summaryBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs"
                                                        shortDescBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs">
                                                        <uix:tableFormat tableBanding="rowBanding"/>
                                                        <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortable="true"/>
                                                        </uix:columnHeader> 
                                                        <uix:columnFormat columnDataFormat="textFormat" />
                                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                        </uix:column>
                                                        <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="LONG_NAME@policyMsgs" sortable="true"/>
                                                        </uix:columnHeader> 
                                                        <uix:columnFormat columnDataFormat="textFormat" />
                                                        <uix:text textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                        </uix:column>
                                                        <uix:tableSelection>
                                                            <uix:multipleSelection  shortDescBinding="POLICY_SELECT@policyMsgs">
                                                            <uix:submitButton textBinding="REMOVE@dbMsgs" name="event" value="deleteCompartments"/>
                                                            </uix:multipleSelection>
                                                        </uix:tableSelection>
                                                        </uix:table>
                                            </uix:rowLayout>
                                        </uix:dataScope>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="GROUPS@policyMsgs">
                          <uix:contents>
                            <uix:spacer width="10" height="10"/>
                            <uix:tableLayout width="80%">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:button textBinding="ADD@dbMsgs" onClickBinding="lovDestForGroups@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:dataScope currentDataBinding="labelGroupsList@servletRequest">
            
                                            <uix:rowLayout width="100%">
                                                        <uix:table name="labelGroupsList" 
                                                        alternateTextBinding="usersAlterText"
                                                        formSubmitted="true"
                                                        width="100%"
                                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                        minValue="1"
                                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                        summaryBinding="GROUPS_LIST_SUMMARY@policyMsgs"
                                                        shortDescBinding="GROUPS_LIST_SUMMARY@policyMsgs">
                                                        <uix:tableFormat tableBanding="rowBanding"/>
                                                        <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortable="true"/>
                                                        </uix:columnHeader> 
                                                        <uix:columnFormat columnDataFormat="textFormat" />
                                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                        </uix:column>
                                                        <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="LONG_NAME@policyMsgs" sortable="true"/>
                                                        </uix:columnHeader> 
                                                        <uix:columnFormat columnDataFormat="textFormat" />
                                                        <uix:text textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                        </uix:column>
                                                        <uix:tableSelection>
                                                            <uix:multipleSelection  shortDescBinding="POLICY_SELECT@policyMsgs">
                                                            <uix:submitButton textBinding="REMOVE@dbMsgs" name="event" value="deleteGroups"/>
                                                            </uix:multipleSelection>
                                                        </uix:tableSelection>
                                                        </uix:table>
                                            </uix:rowLayout>
                                        </uix:dataScope>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:spacer width="10" height="10"/>
                    
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@labelMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@labelMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons>
                    <uix:pageStatus>
                        <uix:formattedText textBinding="DATA_LABEL_INSTR@dataLabelMsgs" styleClass="OraInstructionText"/>
                   </uix:pageStatus>
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>