<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.DataLabelMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="dataLabelMsgs" class="oracle.sysman.db.rsc.sec.ols.DataLabelMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="authList" method="post" destination="/console/database/security/ols/policy/datalabel" copyParams="target,type,otype,objectType,policyName">
                <uix:formValue name="pageName" value="/database/security/ols/datalabel/dataLabelsList"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                            
                                <uix:header textBinding="SEARCH@dbMsgs">
                                    <uix:contents>
                                        <uix:tableLayout width="100%">
                                            <uix:contents>
                                                <uix:rowLayout width="100%">
                                                    <uix:contents>
                                                        <uix:cellFormat width="60%" vAlign="top">
                                                            <uix:contents>
                                                                <uix:styledText textBinding="LABELS_SEARCH_TIP@dataLabelMsgs" styleClass="OraInstructionText"/>
                                                                <uix:rowLayout>
                                                                <uix:contents>
                                                                <uix:cellFormat>
                                                                <uix:contents>
                                                                <uix:spacer width="10" height="10"/>
                                                                </uix:contents>
                                                                </uix:cellFormat>
                                                                </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:tableLayout width="80%">
                                                                <uix:contents>
                                                                <uix:rowLayout>
                                                                <uix:contents>
                                                                <uix:cellFormat hAlign="right">
                                                                <uix:contents>
                                                                <uix:messageStyledText labeledNodeId="labelSearchName" promptBinding="LABEL@dataLabelMsgs" styleClass="OraInstructionText"/>
                                                                </uix:contents>
                                                                </uix:cellFormat>
                                                                <uix:cellFormat>
                                                                <uix:contents>
                                                                <uix:spacer width="3" height="10"/>
                                                                </uix:contents>
                                                                </uix:cellFormat>
                                                                <uix:cellFormat hAlign="left">
                                                                <uix:contents>
                                                                <uix:rowLayout>
                                                                <uix:contents>
                                                                <uix:messageTextInput id="labelSearchName" name="labelSearchName"/>
                                                                <uix:spacer width="10" height="10"/>
                                                                <uix:submitButton disabledBinding="NO_LEVELS@servletRequest" shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                                                </uix:contents>
                                                                </uix:rowLayout>
                                                                </uix:contents>
                                                                </uix:cellFormat>
                                                                </uix:contents>
                                                                </uix:rowLayout>
                                                                </uix:contents>
                                                                </uix:tableLayout>
                                                                <uix:spacer width="10" height="10"/>
                                                                <uix:separator/>
                                                                <uix:spacer width="10" height="20"/>
                                                                <uix:tableLayout width="85%">
                                                                    <uix:contents>
                                                                        <uix:rowLayout width="100%">
                                                                        <uix:contents>
                                                                        <uix:cellFormat hAlign="right">
                                                                        <uix:contents>
                                                                        <uix:submitButton  disabledBinding="NO_LEVELS@servletRequest" shortDescBinding="ADD@dbMsgs" textBinding="ADD@dbMsgs" name="event" value="create"/>
                                                                        </uix:contents>
                                                                        </uix:cellFormat>
                                                                        </uix:contents>
                                                                        </uix:rowLayout>
                                                                        <uix:rowLayout width="100%">
                                                                            <uix:contents>
                                                                                <uix:cellFormat width="90%">
                                                                                    <uix:contents>
                                                                                        <uix:dataScope currentDataBinding="dataLabelsList@servletRequest">
                                                                                            <uix:table name="datalabelsList" 
                                                                                            alternateTextBinding="tableAlterText"
                                                                                            formSubmitted="true"
                                                                                            width="100%"
                                                                                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                                                            minValue="1"
                                                                                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                                                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                                                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                                                            summaryBinding="DATA_LABELS_SUMMARY@dataLabelMsgs"
                                                                                            shortDescBinding="DATA_LABELS_SUMMARY@dataLabelMsgs">
               
                                                                                            <uix:tableFormat tableBanding="rowBanding"/>
                                                                                            <uix:column>
                                                                                            <uix:columnHeader>
                                                                                                <uix:sortableHeader textBinding="LABEL@dataLabelMsgs"/>
                                                                                            </uix:columnHeader> 
                                                                                            <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                                                            <uix:link textBinding="<%= DataLabelMsgID.LABEL %>" destinationBinding="viewURL"/>
                                                                                            </uix:column>
            
                                                                                            <uix:column>
                                                                                            <uix:columnHeader>
                                                                                                <uix:sortableHeader textBinding="NUMERIC_TAG@dataLabelMsgs" sortable="no"/>
                                                                                            </uix:columnHeader> 
                                                                                            <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                                                            <uix:text textBinding="<%= DataLabelMsgID.NUMERIC_TAG %>"/>
                                                                                            </uix:column>
                                                
                                                                                            
     
                                                                                            <uix:tableSelection>
                                                                               
                                                                                                <uix:singleSelection shortDescBinding="POLICY_SELECT@policyMsgs" selectedIndex="0">
                                                                                                    <uix:contents>
                                                                                                        <uix:submitButton textBinding="EDIT@dbMsgs" shortDescBinding="VIEW@dbMsgs" name="event" value="edit"/>
                                                                                                        <uix:submitButton textBinding="VIEW@dbMsgs" shortDescBinding="VIEW@dbMsgs" name="event" value="view"/>
                                                                                                        <uix:submitButton textBinding="CREATE_LIKE@dbMsgs" shortDescBinding="CREATE_LIKE@dbMsgs" name="event" value="createLike"/>
                                                                                                        <uix:submitButton textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="delete"/>
                                                                                                
                                                                                                    </uix:contents>
                                                                                                </uix:singleSelection>
                                                                                            </uix:tableSelection>		
                                                                                            </uix:table>
                                                                                        </uix:dataScope>
                                                                                    </uix:contents>
                                                                                </uix:cellFormat>
                                                                            </uix:contents>
                                                                        </uix:rowLayout>
                                                                
                                                                    </uix:contents>
                                                                </uix:tableLayout>
                                                            </uix:contents>
                                                            
                                                 </uix:cellFormat>
                                                
                                                    </uix:contents>
                                                </uix:rowLayout>
                                            </uix:contents>
                                        </uix:tableLayout>
                                    </uix:contents>
                                </uix:header>
                    </uix:contents>
                    <!-- navigation -->
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>