<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.DataLabelMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="dataLabelMsgs" class="oracle.sysman.db.rsc.sec.ols.DataLabelMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="authList" method="post" destination="/console/database/security/ols/policy/datalabel" copyParams="target,type,otype,objectType,policyName">
                <uix:formValue name="pageName" value="/database/security/ols/datalabel/viewDataLabel"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:spacer width="10" height="10"/>
                        <uix:tableLayout width="50%" hAlign="start">
                          <uix:contents>
                            <uix:labeledFieldLayout width="70%">
                              <uix:contents>
                                <uix:messageStyledText textBinding="numericTag@labelMainBean@servletRequest" promptBinding="NUMERIC_TAG@dataLabelMsgs" styleClass="OraDataText"/>
                                <uix:messageStyledText textBinding="level@labelMainBean@servletRequest" promptBinding="LEVEL@dataLabelMsgs" styleClass="OraDataText"/>
                                
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:header textBinding="COMPARTMENTS@policyMsgs">
                          <uix:contents>
                            <uix:spacer width="10" height="10"/>
                            <uix:tableLayout width="80%">
                              <uix:contents>
                                
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:dataScope currentDataBinding="labelCompsList@servletRequest">
            
                                            <uix:rowLayout>
                                                        <uix:table name="labelCompsList" 
                                                        alternateTextBinding="usersAlterText"
                                                        formSubmitted="true"
                                                        width="100%"
                                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                        minValue="1"
                                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                        summaryBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs"
                                                        shortDescBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs">
                                                        <uix:tableFormat tableBanding="rowBanding"/>
                                                        <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs"/>
                                                        </uix:columnHeader> 
                                                        <uix:columnFormat columnDataFormat="textFormat" />
                                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                        </uix:column>
                                                        <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="LONG_NAME@policyMsgs"/>
                                                        </uix:columnHeader> 
                                                        <uix:columnFormat columnDataFormat="textFormat" />
                                                        <uix:text textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                        </uix:column>
                                                        
                                                        </uix:table>
                                            </uix:rowLayout>
                                        </uix:dataScope>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="GROUPS@policyMsgs">
                          <uix:contents>
                            <uix:spacer width="10" height="10"/>
                            <uix:tableLayout width="80%">
                              <uix:contents>
                                
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:dataScope currentDataBinding="labelGroupsList@servletRequest">
            
                                            <uix:rowLayout>
                                                        <uix:table name="labelGroupsList" 
                                                        alternateTextBinding="usersAlterText"
                                                        formSubmitted="true"
                                                        width="100%"
                                                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                        minValue="1"
                                                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                        summaryBinding="GROUPS_LIST_SUMMARY@policyMsgs"
                                                        shortDescBinding="GROUPS_LIST_SUMMARY@policyMsgs">
                                                        <uix:tableFormat tableBanding="rowBanding"/>
                                                        <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs"/>
                                                        </uix:columnHeader> 
                                                        <uix:columnFormat columnDataFormat="textFormat" />
                                                        <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                        </uix:column>
                                                        <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="LONG_NAME@policyMsgs" />
                                                        </uix:columnHeader> 
                                                        <uix:columnFormat columnDataFormat="textFormat" />
                                                        <uix:text textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                        </uix:column>
                                                        
                                                        </uix:table>
                                            </uix:rowLayout>
                                        </uix:dataScope>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:spacer width="10" height="10"/>
                    
                    </uix:contents>
                    <!-- navigation -->
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>