<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>

<script type="text/javascript">

function enableDisableCheckBoxes()
{
  //alert( document.policyForm.enforcementOptionType[0].checked);
  //alert( document.policyForm.enforcementOptionType[1].checked);
  
  if(document.policyForm.enforcementOptionType[0].checked)
  {
  
    document.policyForm.readControl.checked   = false;
    document.policyForm.insertControl.checked = false;
    document.policyForm.updateControl.checked = false;
    document.policyForm.deleteControl.checked = false;
    document.policyForm.labelDefault.checked  = false;
    document.policyForm.labelUpdate.checked   = false;
    document.policyForm.checkControl.checked  = false;

    document.policyForm.readControl.disabled   = true;
    document.policyForm.insertControl.disabled = true;
    document.policyForm.updateControl.disabled = true;
    document.policyForm.deleteControl.disabled = true;
    document.policyForm.labelDefault.disabled  = true;
    document.policyForm.labelUpdate.disabled   = true;
    document.policyForm.checkControl.disabled  = true;
    
    
  }else if(document.policyForm.enforcementOptionType[1].checked){
  
    document.policyForm.readControl.disabled   = false;
    document.policyForm.insertControl.disabled = false;
    document.policyForm.updateControl.disabled = false;
    document.policyForm.deleteControl.disabled = false;
    document.policyForm.labelDefault.disabled  = false;
    document.policyForm.labelUpdate.disabled   = false;
    document.policyForm.checkControl.disabled  = false;

  }
  
}


</script>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body onLoad='enableDisableCheckBoxes()' >
            <db:form name="policyForm" method="post"  destination="/console/database/security/ols/policy" copyParams="target,type,oname,objectType,otype,">
                <uix:formValue name="pageName" value="/database/security/ols/generalPageTab"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:subTabLayout>
                            <uix:subTabs>
                                <jsp:include page="subTabsInclude.jsp" />
                                <uix:ref refID="subTabsInclude" />
                            </uix:subTabs>
                          <uix:contents> 
                            <uix:spacer width="10" height="10"/>
                            <uix:tableLayout width="50%" hAlign="start">
                              <uix:contents>
                                 <uix:labeledFieldLayout width="70%">
                                  <uix:contents>
                                      
                                <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:messageTextInput required="uiOnly" shortDescBinding="NAME@policyMsgs" promptBinding="NAME@policyMsgs" name="policyName" readOnlyBinding="editing@policyBean@servletRequest" textBinding="name@policyBean@servletRequest" styleClass="OraDataText"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:messageTextInput maximumLength="30" required="uiOnly" shortDescBinding="NAME@policyMsgs" promptBinding="NAME@policyMsgs" name="policyName" readOnlyBinding="editing@policyBean@servletRequest" textBinding="name@policyBean@servletRequest" />
                                    </uix:case>
                                </uix:switcher>
                                      
                                <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:messageTextInput required="uiOnly" shortDescBinding="LABEL_COL@policyMsgs" promptBinding="LABEL_COL@policyMsgs" name="labelCol" textBinding="labelCol@policyBean@servletRequest" readOnlyBinding="editing@policyBean@servletRequest" styleClass="OraDataText"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:messageTextInput maximumLength="30" required="uiOnly" shortDescBinding="LABEL_COL@policyMsgs" promptBinding="LABEL_COL@policyMsgs" name="labelCol" textBinding="labelCol@policyBean@servletRequest" readOnlyBinding="editing@policyBean@servletRequest" messageBinding="LABEL_COL_TIP@policyMsgs"/>
                                    </uix:case>
                                </uix:switcher>
                                    
                                    <uix:messageCheckBox shortDescBinding="HIDE_POLICY_COL@policyMsgs" textBinding="HIDE_POLICY_COL@policyMsgs" name="hideLabelCol" messageBinding="HIDE_POLICY_COL_TIP@policyMsgs" checkedBinding="hideLabelCol@policyBean@servletRequest"/>
                                    <uix:messageCheckBox shortDescBinding="ENABLED@policyMsgs" textBinding="ENABLED@policyMsgs" name="enabled" checkedBinding="enabled@policyBean@servletRequest" />
                                    <uix:messageCheckBox shortDescBinding="INVERSE_GROUP@policyMsgs" textBinding="INVERSE_GROUP@policyMsgs" name="inverseGroup" checkedBinding="inverseGroup@policyBean@servletRequest" readOnlyBinding="editing@policyBean@servletRequest" />
                                  </uix:contents>
                                </uix:labeledFieldLayout> 
                              </uix:contents>
                            </uix:tableLayout> 
                            <uix:header textBinding="DEF_POL_ENFORC_OPTIONS@policyMsgs">
                              <uix:contents>
                                <uix:radioSet name="enforcementOptionType" selectedIndexBinding="enforcementOptionType@policyBean@servletRequest" onClick='enableDisableCheckBoxes()'>
                                  <uix:contents>
                                    <uix:option shortDescBinding="NO_ENFORC@policyMsgs" textBinding="NO_ENFORC@policyMsgs" value="0"/>
                                    <uix:option shortDescBinding="APPLY_ENFORC_OPTIONS@policyMsgs" textBinding="APPLY_ENFORC_OPTIONS@policyMsgs" value="1"/>
                                    <uix:tableLayout>
                                      <uix:contents>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:spacer width="10" height="10"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:labeledFieldLayout>
                                                  <uix:contents>
                                                    <uix:messageCheckBox shortDescBinding="READ_CONTROL@policyMsgs" textBinding="READ_CONTROL@policyMsgs" name="readControl" checkedBinding="readControl@policyBean@servletRequest"/>
                                                    <uix:messageCheckBox shortDescBinding="INSERT_CONTROL@policyMsgs" textBinding="INSERT_CONTROL@policyMsgs" name="insertControl" checkedBinding="insertControl@policyBean@servletRequest"/>
                                                    <uix:messageCheckBox shortDescBinding="UPDATE_CONTROL@policyMsgs" textBinding="UPDATE_CONTROL@policyMsgs" name="updateControl" checkedBinding="updateControl@policyBean@servletRequest"/>
                                                    <uix:messageCheckBox shortDescBinding="DELETE_CONTROL@policyMsgs" textBinding="DELETE_CONTROL@policyMsgs" name="deleteControl" checkedBinding="deleteControl@policyBean@servletRequest"/>
                                                    <uix:messageCheckBox shortDescBinding="LABEL_DEFAULT@policyMsgs" textBinding="LABEL_DEFAULT@policyMsgs" name="labelDefault" checkedBinding="labelDefault@policyBean@servletRequest"/>
                                                    <uix:messageCheckBox shortDescBinding="LABEL_UPDATE@policyMsgs" textBinding="LABEL_UPDATE@policyMsgs" name="labelUpdate" checkedBinding="labelUpdate@policyBean@servletRequest"/>
                                                    <uix:messageCheckBox shortDescBinding="CHECK_CONTROL@policyMsgs" textBinding="CHECK_CONTROL@policyMsgs" name="checkControl" checkedBinding="checkControl@policyBean@servletRequest"/>
                                                  </uix:contents>
                                                </uix:labeledFieldLayout>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:tableLayout>
                                  </uix:contents>
                                </uix:radioSet>
                              </uix:contents>
                            </uix:header> 
                            <uix:spacer width="10" height="10"/>
                          </uix:contents> 
                        </uix:subTabLayout> 
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="applyEdit"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons> 
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
