<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="policyForm" method="post" destination="/console/database/security/ols/policy" copyParams="target,type,oname,objectType,otype,cancelURL,">
                <uix:formValue name="pageName" value="/database/security/ols/labelCompTab"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:subTabLayout>
                          <uix:subTabs>
                                <jsp:include page="subTabsInclude.jsp" />
                                <uix:ref refID="subTabsInclude" />
                          </uix:subTabs>
                          <uix:contents>
                          <uix:spacer width="10" height="10"/>
                            <uix:header textBinding="LEVELS@policyMsgs">
                              <uix:contents>
                                <uix:messageStyledText textBinding="LEVEL_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="levelsList@servletRequest">
                                                <uix:table name="levelsList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="LEVELS_LIST_SUMMARY@policyMsgs"
                                                shortDescBinding="LEVELS_LIST_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="LONG_NAME@policyMsgs"  sortableBinding="longNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                <uix:messageTextInput shortDescBinding="LONG_NAME@policyMsgs" name="<%= PolicyMsgID.LONG_NAME %>" textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs"  sortableBinding="shortNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:messageTextInput shortDescBinding="SHORT_NAME@policyMsgs" readOnlyBinding="shortNameReadOnly" name="<%= PolicyMsgID.SHORT_NAME %>" textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                </uix:column>
            
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="NUM_TAG@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="numberFormat" width="25%"/>
                                                <uix:messageTextInput shortDescBinding="NUM_TAG@policyMsgs" readOnlyBinding="numTagReadOnly"  name="<%= PolicyMsgID.NUM_TAG %>" textBinding="<%= PolicyMsgID.NUM_TAG %>"/>
                                                </uix:column>
     
                                                <uix:tableSelection>
                                                    <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs">
                                                    <uix:contents>
                                                        <uix:submitButton textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="deleteLevels"/>                        
                                                    </uix:contents>
                                                    </uix:multipleSelection>
                                                </uix:tableSelection>		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:submitButton textBinding="ADD_5_ROWS@policyMsgs" shortDescBinding="ADD_5_ROWS@policyMsgs" name="event" value="add5LevelRows"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                            <uix:header textBinding="COMPARTMENTS@policyMsgs">
                              <uix:contents>
                                <uix:messageStyledText textBinding="COMPARTMENT_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="compartmentsList@servletRequest">
                                                <uix:table name="compartmentsList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs"
                                                shortDescBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="LONG_NAME@policyMsgs"  sortableBinding="longNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                <uix:messageTextInput shortDescBinding="LONG_NAME@policyMsgs" name="<%= PolicyMsgID.LONG_NAME %>" textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs"  sortableBinding="shortNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:messageTextInput shortDescBinding="SHORT_NAME@policyMsgs" readOnlyBinding="shortNameReadOnly" name="<%= PolicyMsgID.SHORT_NAME %>" textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                </uix:column>
            
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="NUM_TAG@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="numberFormat" width="25%"/>
                                                <uix:messageTextInput shortDescBinding="NUM_TAG@policyMsgs" readOnlyBinding="numTagReadOnly" name="<%= PolicyMsgID.NUM_TAG %>" textBinding="<%= PolicyMsgID.NUM_TAG %>"/>
                                                </uix:column>
     
                                                <uix:tableSelection>
                                                    <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs">
                                                    <uix:contents>
                                                        <uix:submitButton textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="deleteCompartments"/>                        
                                                    </uix:contents>
                                                    </uix:multipleSelection>
                                                </uix:tableSelection>		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:submitButton textBinding="ADD_5_ROWS@policyMsgs" shortDescBinding="ADD_5_ROWS@policyMsgs" name="event" value="add5CompartmentRows"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                            <uix:header textBinding="GROUPS@policyMsgs">
                              <uix:contents>
                                <uix:messageStyledText textBinding="GROUP_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="groupsList@servletRequest">
                                                <uix:table name="groupsList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="GROUPS_LIST_SUMMARY@policyMsgs"
                                                shortDescBinding="GROUPS_LIST_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="LONG_NAME@policyMsgs"  sortableBinding="longNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                <uix:messageTextInput shortDescBinding="LONG_NAME@policyMsgs" name="<%= PolicyMsgID.LONG_NAME %>" textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs"  sortableBinding="shortNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:messageTextInput shortDescBinding="SHORT_NAME@policyMsgs" readOnlyBinding="shortNameReadOnly" name="<%= PolicyMsgID.SHORT_NAME %>" textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                </uix:column>
            
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="NUM_TAG@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="numberFormat" width="25%"/>
                                                <uix:messageTextInput shortDescBinding="NUM_TAG@policyMsgs" readOnlyBinding="numTagReadOnly" name="<%= PolicyMsgID.NUM_TAG %>" textBinding="<%= PolicyMsgID.NUM_TAG %>"/>
                                                </uix:column>
                                                
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="PARENT_GROUP@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:messageTextInput shortDescBinding="PARENT_GROUP@policyMsgs" name="<%= PolicyMsgID.PARENT_GROUP %>" textBinding="<%= PolicyMsgID.PARENT_GROUP %>" renderedBinding="notInverseGroup@policyBean@servletRequest" />
                                                </uix:column>
     
                                                <uix:tableSelection>
                                                    <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs">
                                                    <uix:contents>
                                                        <uix:submitButton textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="deleteGroups"/>                        
                                                    </uix:contents>
                                                    </uix:multipleSelection>
                                                </uix:tableSelection>		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:submitButton textBinding="ADD_5_ROWS@policyMsgs" name="event" shortDescBinding="ADD_5_ROWS@policyMsgs" value="add5GroupRows"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                            <uix:spacer width="10" height="10"/>
                          </uix:contents>
                        </uix:subTabLayout>
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="applyEdit"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
