<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ page import="oracle.sysman.db.rsc.sec.OLSOIDMsgID"%>
<%@ page import="oracle.sysman.db.rsc.inst.DBMsgID"%>

<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>

  <uix:bundle name="dbMsgs1" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="olsMsgs" class="oracle.sysman.db.rsc.sec.OLSOIDMsg"/>

    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="policyList" method="post" destination="/console/database/security/ols/policy" copyParams="target,type,otype,objectType">
                <uix:formValue name="pageName" value="/database/security/ols/policyList"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                        <uix:header textBinding="SEARCH@dbMsgs">
                            <uix:contents>
                                <uix:tableLayout width="100%">
                                    <uix:contents>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:cellFormat width="60%" vAlign="top">
                                                    <uix:contents>
                                                        <uix:styledText textBinding="POLICY_SEARCH_TIP@policyMsgs" styleClass="OraInstructionText"/>
                                                        <uix:rowLayout>
                                                            <uix:contents>
                                                                <uix:cellFormat>
                                                                    <uix:contents>
                                                                        <uix:spacer width="10" height="10"/>
                                                                    </uix:contents>
                                                                </uix:cellFormat>
                                                            </uix:contents>
                                                        </uix:rowLayout>
                                                        <uix:tableLayout width="80%">
                                                            <uix:contents>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat hAlign="right">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText labeledNodeId="policySearchName" promptBinding="POLICY_NAME@policyMsgs" styleClass="OraInstructionText"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer width="3" height="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="left">
                                                                            <uix:contents>
                                                                                <uix:rowLayout>
                                                                                    <uix:contents>
                                                                                        <uix:messageTextInput id="policySearchName" name="policySearchName" textBinding="policySearchString@servletRequest"/>
                                                                                        <uix:spacer width="10" height="10"/>
                                                                                        <uix:submitButton disabledBinding="olsDisabled@servletRequest" shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                                                                    </uix:contents>
                                                                                </uix:rowLayout>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                        <uix:spacer width="10" height="10"/>
                                                        <uix:separator/>
                                                        <uix:spacer width="10" height="20"/>
                                                        <uix:tableLayout width="85%">
                                                            <uix:contents>
                                                                <uix:rowLayout width="90%">
                                                                    <uix:contents>
                                                          <!-- Only show the single/multi select dropdown when ols is configured on the db. Added for GC support.  -->

                                                          <uix:switcher defaultCase="false" childNameBinding="olsEnabled@servletRequest">

                                                                <uix:case name="true">

                                                                        <!-- Only show the single/multi select dropdown when ols is sa configured. For ols oid, only single select
                                                                                option (default) is required.
                                                                         -->
                                                                        <uix:messageChoice renderedBinding="saEnabled@servletRequest" promptBinding="SELECTION_MODE@dbMsgs" selectedValueBinding="selectionMode@servletRequest" name="selectionMode" onChange="submitForm('policyList', true, {event:'selectionModeChanged'})">
                                                                            <uix:contents>
                                                                                <uix:option textBinding="SINGLE@dbMsgs" value="0"/>
                                                                                <uix:option textBinding="MULTIPLE@dbMsgs" value="1"/>
                                                                            </uix:contents> 
                                                                        </uix:messageChoice>

                                                                </uix:case>

                                                        </uix:switcher>

                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout width="100%">
                                                                    <uix:contents>
                                                                        <uix:cellFormat hAlign="right">
                                                                            <uix:contents>
                                                                                <uix:submitButton  renderedBinding="saEnabled@servletRequest" shortDescBinding="CREATE@dbMsgs" textBinding="CREATE@dbMsgs" name="event" value="create"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout width="100%">
                                                                    <uix:contents>
                                                                        <uix:cellFormat width="90%">
                                                                            <uix:contents>
                                                                             <uix:switcher childNameBinding="selectionMode@servletRequest">
                                                                                 <uix:case name="0">
                                                                                 <uix:dataScope currentDataBinding="policyList@servletRequest">
                                                                                 <uix:table name="policyList" 
                                                                                 alternateTextBinding="tableAlterText"
                                                                                 formSubmitted="true"
                                                                                 width="100%"
                                                                                 tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                                                 minValue="1"
                                                                                 valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                                                 blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                                                 maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                                                 summaryBinding="POLICY_LIST_SUMMARY@policyMsgs"
                                                                                 shortDescBinding="POLICY_LIST_SUMMARY@policyMsgs">
               
                                                                                 <uix:tableFormat tableBanding="rowBanding"/>
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                 <uix:sortableHeader textBinding="POLICY_NAME@policyMsgs" sortable="yes"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                                                 <uix:link destinationBinding="viewURL" textBinding="<%= PolicyMsgID.NAME %>" />
                                                                                 </uix:column>
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                 <uix:sortableHeader textBinding="ENABLED@policyMsgs" sortable="yes"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                                                                 <uix:image sourceBinding="enabledIconDest" shortDescBinding="ENABLED@policyMsgs"/>
                                                                                 </uix:column>
            
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                 <uix:sortableHeader textBinding="LABEL_COL@policyMsgs" sortable="no"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                                                 <uix:text textBinding="<%= PolicyMsgID.LABEL_COL %>"/>
                                                                                 </uix:column>
     
                                                                                 <uix:tableSelection>
                                                                               
                                                                                 <uix:singleSelection shortDescBinding="POLICY_SELECT@policyMsgs" selectedIndexBinding="selectedPolicyIndex@servletRequest">
                                                                                 <uix:contents>
                                                                                 <uix:submitButton renderedBinding="saEnabled@servletRequest" textBinding="EDIT@dbMsgs" shortDescBinding="EDIT@dbMsgs" name="event" value="edit"/>
                                                                                 <uix:submitButton textBinding="VIEW@dbMsgs" shortDescBinding="VIEW@dbMsgs" name="event" value="view"/>
                                                                                 <uix:submitButton textBinding="SUBSCRIBE_UNSUBSCRIBE@policyMsgs" renderedBinding="oidEnabled@servletRequest" shortDescBinding="SUBSCRIBE_UNSUBSCRIBE@policyMsgs" name="event" value="subscribeUnsubscribe"/>
                                                                                 <uix:submitButton renderedBinding="saEnabled@servletRequest" textBinding="CREATE_LIKE@dbMsgs" shortDescBinding="CREATE_LIKE@dbMsgs" name="event" value="createLike"/>
                                                                                 <uix:submitButton renderedBinding="saEnabled@servletRequest" textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="delete"/>
                                                                                 <uix:spacer height="10" width="30"/>
                                                                                 <uix:messageChoice name="Action" promptBinding="ACTIONS@dbMsgs" shortDescBinding="ACTIONS@dbMsgs">
                                                                                 <uix:contents>
                                                                                                    
                                                                                 <uix:option textBinding="AUTHORIZATION@policyMsgs" value="<%= PolicyMsgID.AUTHORIZATION %>"/>
                                                                                 <uix:option textBinding="APPLY@policyMsgs" value="<%= PolicyMsgID.APPLY %>"/>
                                                                                 <uix:option renderedBinding="saEnabled@servletRequest" textBinding="ENABLE_DISABLE@policyMsgs" value="<%= PolicyMsgID.ENABLE_DISABLE %>"/>
                                                                                 <uix:option renderedBinding="saEnabled@servletRequest" textBinding="DATA_LABELS@policyMsgs" value="<%= PolicyMsgID.DATA_LABELS %>"/>
                                                                                 </uix:contents>
                                                                                 </uix:messageChoice>
                                                                                 <uix:submitButton  textBinding="GO@dbMsgs" shortDescBinding="GO@dbMsgs" name="event" value="policyAction"/>                          
                                                                                 </uix:contents>
                                                                                 </uix:singleSelection>
                                                                                 </uix:tableSelection>		
                                                                                 </uix:table>
                                                                                 </uix:dataScope>
                                                                                 </uix:case>
                                                                                 <uix:case name="1">
                                                                                 <uix:dataScope currentDataBinding="policyList@servletRequest">
                                                                                 <uix:table name="policyList" 
                                                                                 alternateTextBinding="tableAlterText"
                                                                                 formSubmitted="true"
                                                                                 width="100%"
                                                                                 tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                                                 minValue="1"
                                                                                 valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                                                 blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                                                 maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                                                 summaryBinding="POLICY_LIST_SUMMARY@policyMsgs"
                                                                                 shortDescBinding="POLICY_LIST_SUMMARY@policyMsgs">
               
                                                                                 <uix:tableFormat tableBanding="rowBanding"/>
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                 <uix:sortableHeader textBinding="NAME@policyMsgs" sortable="yes"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                                                 <uix:link destinationBinding="viewURL" textBinding="<%= PolicyMsgID.NAME %>" />
                                                                                 </uix:column>
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                 <uix:sortableHeader textBinding="ENABLED@policyMsgs" sortable="yes"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                                                                 <uix:image sourceBinding="enabledIconDest" shortDescBinding="ENABLED@policyMsgs"/>
                                                                                 </uix:column>
            
                                                                                 <uix:column>
                                                                                 <uix:columnHeader>
                                                                                 <uix:sortableHeader textBinding="LABEL_COL@policyMsgs" sortable="no"/>
                                                                                 </uix:columnHeader> 
                                                                                 <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                                                 <uix:text textBinding="<%= PolicyMsgID.LABEL_COL %>"/>
                                                                                 </uix:column>
     
                                                                                 <uix:tableSelection>
                                                                               
                                                                                 <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs">
                                                                                 <uix:contents>
                                                                                            
                                                                                 <uix:submitButton textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="delete"/>
                                                                                                                     
                                                                                 </uix:contents>
                                                                                 </uix:multipleSelection>
                                                                               
                                                                                 </uix:tableSelection>		
                                                                                 </uix:table>
                                                                                 </uix:dataScope>
                                                                                 </uix:case>
                                                                             </uix:switcher>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:tip>
                                                                                    <uix:contents>
                                                                                        <uix:formattedText textBinding="POLICY_DELETE_WARN@policyMsgs"/>
                                                                                    </uix:contents>
                                                                                </uix:tip>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat width="40%" vAlign="top">
                                                    <uix:contents>
                                                        <uix:contentContainer textBinding="OLS@policyMsgs" width="100%">
                                                            <uix:contents>
                                                                <uix:formattedText textBinding="POLICY_OVERVIEW@policyMsgs" styleUsage="instruction"/>
                                                            </uix:contents>
                                                        </uix:contentContainer>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
					
                                    </uix:contents>
                                </uix:tableLayout>
                            </uix:contents>


			    
                        </uix:header>

                  <uix:switcher defaultCase="false" childNameBinding="oidEnabled@servletRequest">

                                    <uix:case name="true">

                 <uix:header shortDescBinding= '<%= OLSOIDMsgID.RELATED_LINKS + "@olsMsgs" %>' textBinding= '<%= OLSOIDMsgID.RELATED_LINKS + "@olsMsgs" %>'>

<db:link 
shortDescBinding= '<%= OLSOIDMsgID.C_ORACLE_INTERNET_DIRECTORY+ "@olsMsgs" %>' 
textBinding= '<%= OLSOIDMsgID.C_ORACLE_INTERNET_DIRECTORY + "@olsMsgs" %>' 
destination='<%= "/console/database/EntDBSec?event=dbLogin&enterModule=" +oracle.sysman.db.adm.sec.common.EntDBSecConstants.OLS_URL %>' 
copyParams="target,type"
/>

                 </uix:header>			


                                    </uix:case>

                                    <uix:case name="false">
                                    </uix:case>

                                </uix:switcher>

                    </uix:contents>
                    <!-- navigation -->
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
                  
