<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:document>
        <uix:metaContainer>
        <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="enableDisable" method="post" destination="/console/database/security/ols/policy" copyParams="target,type,otype,objectType,oname">
                <uix:formValue name="pageName" value="/database/security/ols/subsUnsubsConf"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest" messageType="confirmation">
                    <%@ include file="/database/global.jspf" %>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:tableLayout hAlign="center" width="100%">
                        <uix:contents>
                        <uix:rowLayout>
                            <uix:contents>
                                <uix:cellFormat columnSpan="2" >
                                    <uix:contents>
                                        
                                                <uix:messageStyledText textBinding="confMessage@servletRequest" styleClass="OraDataText"/>
  
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:contents>
                        </uix:rowLayout>
                        </uix:contents>  
                    </uix:tableLayout>
                    </uix:contents>                   
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="NO@dbMsgs" textBinding="NO@dbMsgs" name="event" value="cancel"/>
                                <uix:submitButton shortDescBinding="YES@dbMsgs" textBinding="YES@dbMsgs" name="event" valueBinding="event@servletRequest"/>
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
      
                </uix:pageLayout>    


            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>