<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    
    <uix:body>

   <db:form name="usersLov" method="post" 
            destinationBinding="dest@servletRequest"
            copyParams="target,type, oname,otype,objectType, ">
      <uix:pageLayout titleBinding="header@servletRequest">
        <uix:formValue name="pageName" value="/database/security/ols/usersList"/>
        <uix:formValue name="destType" valueBinding="destType@servletRequest"/>

          <uix:tableLayout cellSpacing="2" width="80%">
         <uix:dataScope currentDataBinding="schemaList@servletRequest">
            <%-- Search Criteria and Instruction --%>
            <uix:rowLayout>
	            <uix:stackLayout>
	              <uix:header textBinding="SEARCH_AND_SELECT_USER@policyMsgs">
	               <uix:tableLayout>
	                <uix:rowLayout>
	                <uix:cellFormat>
	                  <uix:messageStyledText labeledNodeId="schemaSearchName" styleClass="OraInstructionText" textBinding="NAME@dbMsgs"/>
	                </uix:cellFormat>
	                <uix:cellFormat>
	                  <uix:spacer height="10" width="3"/>
	                </uix:cellFormat>
	                <uix:cellFormat>
	                  <uix:messageTextInput id="schemaSearchName" name="schemaSearchName" 
                                     shortDescBinding="NAME@dbMsgs"
                                     textBinding="schemaSearchName"/>
	                </uix:cellFormat>
	                </uix:rowLayout>
	                <uix:rowLayout>
	                <uix:cellFormat>
	                <uix:submitButton shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" name="event" 
                                            value="schemaSearch"/>
	                </uix:cellFormat>
	                <uix:cellFormat>
	                </uix:cellFormat>
	                <uix:cellFormat>
	                </uix:cellFormat>
	                </uix:rowLayout>
	               </uix:tableLayout>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RESULT@dbMsgs">
                      <uix:table name="schemaList" 
                      alternateTextBinding="usersAlterText"
                      formSubmitted="true"
                      width="100%"
                      tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                      minValue="1"
                      valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                      blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                      maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                      summaryBinding="DB_USERS_SUMMARY@policyMsgs"
                      shortDescBinding="DB_USERS_SUMMARY@policyMsgs">
                      <uix:tableFormat tableBanding="rowBanding"/>
                      <uix:column>
                      <uix:columnHeader>
                          <uix:sortableHeader textBinding="NAME@dbMsgs" sortable="true"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat" />
                      <uix:text textBinding="<%= DBObjectMsgID.NAME %>" />
                      </uix:column>
                      <uix:tableSelection>
                          <uix:multipleSelection shortDescBinding="POLICY_SELECT@policyMsgs">
                          </uix:multipleSelection>
                      </uix:tableSelection>
                      </uix:table>
                  </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        </uix:dataScope>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" onClick="javascript:self.close()" />
            <uix:button shortDescBinding="SELECT@dbMsgs" textBinding="SELECT@dbMsgs" onClickBinding="destTable@servletRequest"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>

   </uix:body>
  </uix:document>
 </uix:renderingContext>
