<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.sec.ols.PolicyMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyMsg"/>
    <uix:bundle name="policyAuthMsgs" class="oracle.sysman.db.rsc.sec.ols.PolicyAuthMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="policyForm" method="post" destination="/console/database/security/ols/policy" copyParams="target,type,oname,objectType,otype,cancelURL,">
                <uix:formValue name="pageName" value="/database/security/ols/viewPolicy"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:tableLayout width="60%">
                        <uix:contents>
                            <uix:labeledFieldLayout width="70%">
                                <uix:contents>
                                    <uix:messageStyledText textBinding="labelCol@policyBean@servletRequest" promptBinding="LABEL_COL@policyMsgs" styleClass="OraDataText"/>
                                    <uix:switcher childNameBinding="enabled@policyBean@servletRequest">
                                        <uix:case name="true">
                                            <uix:messageStyledText promptBinding="ENABLED@policyMsgs" textBinding="YES@dbMsgs" styleClass="OraDataText" shortDescBinding="ENABLED@policyMsgs"/>
                                        </uix:case>
                                        <uix:case name="false">
                                            <uix:messageStyledText promptBinding="ENABLED@policyMsgs" textBinding="NO@dbMsgs" styleClass="OraDataText" shortDescBinding="ENABLED@policyMsgs"/>
                                        </uix:case>
                                    </uix:switcher>
                                    
                                    <uix:messageStyledText textBinding="enforcementOptionsStr@policyBean@servletRequest" promptBinding="DEF_POL_ENFORC_OPTIONS@policyMsgs" styleClass="OraDataText"/>
                                </uix:contents>
                            </uix:labeledFieldLayout>
                        </uix:contents>
                    </uix:tableLayout>
                    
                    <%-- All Label Components --%>
              
                    
                    <uix:header textBinding="LEVELS@policyMsgs">
                              <uix:contents>
                                <uix:messageStyledText textBinding="LEVEL_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="levelsList@servletRequest">
                                                <uix:table name="levelsList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="LEVELS_LIST_SUMMARY@policyMsgs"
                                                shortDescBinding="LEVELS_LIST_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="LONG_NAME@policyMsgs" sortableBinding="longNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortableBinding="shortNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                </uix:column>
            
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="NUM_TAG@policyMsgs" sortableBinding="numTagSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="numberFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.NUM_TAG %>"/>
                                                </uix:column>
     
                                                		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                            <uix:header textBinding="COMPARTMENTS@policyMsgs">
                              <uix:contents>
                                <uix:messageStyledText textBinding="COMPARTMENT_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="compartmentsList@servletRequest">
                                                <uix:table name="compartmentsList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs"
                                                shortDescBinding="COMPARTMENTS_LIST_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="LONG_NAME@policyMsgs" sortableBinding="longNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortableBinding="shortNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                </uix:column>
            		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                            <uix:header textBinding="GROUPS@policyMsgs">
                              <uix:contents>
                                <uix:messageStyledText textBinding="GROUP_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="groupsList@servletRequest">
                                                <uix:table name="groupsList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="GROUPS_LIST_SUMMARY@policyMsgs"
                                                shortDescBinding="GROUPS_LIST_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="LONG_NAME@policyMsgs" sortableBinding="longNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.LONG_NAME %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SHORT_NAME@policyMsgs" sortableBinding="shortNameSortStatus"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:text  textBinding="<%= PolicyMsgID.SHORT_NAME %>" />
                                                </uix:column>
            
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="PARENT_GROUP@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.PARENT_GROUP %>"/>
                                                </uix:column>
     
                                                		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                    <%-- End of label comps --%>
                    <%-- Auth Users --%>
                            <uix:hideShowHeader id="usersHeader"  textBinding="USERS@dbMsgs" disclosedBinding="usersHeaderState@servletRequest" formSubmitted="true" partialRenderMode="self">
                                <uix:contents>
                                <uix:messageStyledText textBinding="USER_AUTH_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="authUsersList@servletRequest">
                                                <uix:table name="authUsersList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="POLICY_AUTH_USERS_SUMMARY@policyMsgs"
                                                shortDescBinding="POLICY_AUTH_USERS_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="USER@dbMsgs" sortable="yes"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                
                          <uix:switcher defaultCase="true" childNameBinding="saEnabled@servletRequest">

                                <uix:case name="true">
                                                
                                                <uix:text textBinding="<%= PolicyMsgID.NAME %>"/>
                                </uix:case>

                                <uix:case name="false">
                                                
                                                <uix:text textBinding='<%= new String("nik") %>'/>
                                </uix:case>
                                
                        </uix:switcher>
                                                
                                                </uix:column>
            
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="MAX_READ_LABEL@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.MAX_READ_LABEL %>"/>
                                                </uix:column>
                                                
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="MAX_WRITE_LABEL@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.MAX_WRITE_LABEL %>"/>
                                                </uix:column>
                                                
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="PRIVILEGES@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.PRIVILEGES %>"/>
                                                </uix:column>
     
                                                		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    
                                  </uix:contents>
                                </uix:tableLayout>
                              
                             </uix:contents>
                     </uix:hideShowHeader>
                            
                            <%-- Done Auth Users --%>
                            
                            <%-- STart of auth Tables --%>
                     <uix:hideShowHeader id="tablesHeader"  textBinding="TABLES@dbMsgs" disclosedBinding="tablesHeaderState@servletRequest" formSubmitted="true" partialRenderMode="self">
                                <uix:contents>
                                <uix:messageStyledText textBinding="TABLE_APPLY_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="appliedTablesList@servletRequest">
                                                <uix:table name="appliedTablesList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="POLICY_TABLES_SUMMARY@policyMsgs"
                                                shortDescBinding="POLICY_TABLES_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="TABLE@dbMsgs" sortable="yes"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.NAME %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SCHEMA@policyMsgs" sortable="yes"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:text  textBinding="<%= PolicyMsgID.SCHEMA %>" />
                                                </uix:column>
            
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="ENFORCEMENT_OPTIONS@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.ENFORCEMENT_OPTIONS %>"/>
                                                </uix:column>
                                                
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="ENABLED@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="25%"/>
                                                <uix:image sourceBinding="<%= PolicyMsgID.ENABLED %>"/>
                                                </uix:column>
     
                                                		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    
                                  </uix:contents>
                                </uix:tableLayout>
                             
                                </uix:contents>
                     </uix:hideShowHeader>
                            <%-- Done of auth Tables --%>
                             
                            
                            <%-- Auth Prog Units List --%>
                            <uix:hideShowHeader id="progUnitsHeader"  textBinding="TRUSTED_PROG_UNITS@policyMsgs" disclosedBinding="progUnitsHeaderState@servletRequest" formSubmitted="true" partialRenderMode="self">
                                <uix:contents>
                                <uix:messageStyledText textBinding="PROG_UNIT_AUTH_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="authProgUnitsList@servletRequest">
                                                <uix:table name="authProgUnitsList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="POLICY_PROG_UNITS_SUMMARY@policyMsgs"
                                                shortDescBinding="POLICY_PROG_UNITS_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="PROG_UNIT@policyAuthMsgs" sortable="yes"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.NAME %>" />
                                                </uix:column>
            
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SCHEMA@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.SCHEMA %>"/>
                                                </uix:column>
                                                
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="TYPE@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.TYPE %>"/>
                                                </uix:column>
                                                
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="PRIVILEGES@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.PRIVILEGES %>"/>
                                                </uix:column>
     
                                                		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    
                                  </uix:contents>
                                </uix:tableLayout>
                              
                             </uix:contents>
                     </uix:hideShowHeader>
                            <%-- Done Auth Prog Units --%>
                            
                            <%-- Start of Auth Schema --%>
                            <uix:hideShowHeader id="schemasHeader"  textBinding="SCHEMAS@policyMsgs" disclosedBinding="schemasHeaderState@servletRequest" formSubmitted="true" partialRenderMode="self">
                                <uix:contents>
                                <uix:messageStyledText textBinding="SCHEMA_APPLY_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="80%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:dataScope currentDataBinding="appliedSchemasList@servletRequest">
                                                <uix:table name="appliedSchemasList" 
                                                alternateTextBinding="tableAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                summaryBinding="POLICY_SCHEMAS_SUMMARY@policyMsgs"
                                                shortDescBinding="POLICY_SCHEMAS_SUMMARY@policyMsgs">
               
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SCHEMA@dbMsgs" sortable="yes"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.NAME %>" />
                                                </uix:column>
            
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="ENFORCEMENT_OPTIONS@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                <uix:text textBinding="<%= PolicyMsgID.ENFORCEMENT_OPTIONS %>"/>
                                                </uix:column>
                                                
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="ENABLED@policyMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="25%"/>
                                                <uix:image sourceBinding="<%= PolicyMsgID.ENABLED %>"/>
                                                </uix:column>
     
                                                		
                                                </uix:table>
                                            </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    
                                  </uix:contents>
                                </uix:tableLayout>
                              
                             </uix:contents>
                     </uix:hideShowHeader>
                            <%-- end of auth schema --%>
                            
                           
                            <%-- Audit Users --%>
                          <uix:switcher defaultCase="false" childNameBinding="saEnabled@servletRequest">

                                <uix:case name="true">

                                        <!-- Only show the single/multi select dropdown when ols is sa configured. For ols oid, only single select
                                                option (default) is required.
                                         -->

                            <uix:hideShowHeader id="auditHeader"  textBinding="AUDITING@policyMsgs" disclosedBinding="auditHeaderState@servletRequest" formSubmitted="true" partialRenderMode="self">
                                <uix:contents>
                                    <uix:header textBinding="AUDIT_LABEL@policyMsgs">
                                        <uix:contents>
                                            <uix:styledText textBinding="AUDIT_LABEL_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                            <uix:rowLayout>
                                                <uix:contents>
                                                    <uix:cellFormat>
                                                        <uix:contents>
                                                            <uix:spacer width="10" height="15"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                </uix:contents>
                                            </uix:rowLayout>
                                            <uix:switcher childNameBinding="auditLabel@policyBean@servletRequest">
                                                <uix:case name="true">
                                                    <uix:messageStyledText promptBinding="AUDIT_LABEL_IN_TRAIL@policyMsgs" textBinding="YES@dbMsgs" styleClass="OraDataText" shortDescBinding="AUDIT_LABEL_IN_TRAIL@policyMsgs"/>
                                                </uix:case>
                                                <uix:case name="false">
                                                    <uix:messageStyledText promptBinding="AUDIT_LABEL_IN_TRAIL@policyMsgs" textBinding="NO@dbMsgs" styleClass="OraDataText" shortDescBinding="AUDIT_LABEL_IN_TRAIL@policyMsgs"/>
                                                </uix:case>
                                            </uix:switcher>
                                        </uix:contents>
                                    </uix:header>
                                    <uix:rowLayout>
                                        <uix:contents>
                                            <uix:cellFormat>
                                                <uix:contents>
                                                    <uix:spacer width="10" height="10"/>
                                                </uix:contents>
                                            </uix:cellFormat>
                                        </uix:contents>
                                    </uix:rowLayout>
                                    <uix:header textBinding="OPTIONS@policyMsgs">
                                        <uix:contents>
                                            <uix:rowLayout>
                                                <uix:contents>
                                                    <uix:cellFormat>
                                                        <uix:contents>
                                                            <uix:spacer width="10" height="10"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                </uix:contents>
                                            </uix:rowLayout>
                                           
                                            <uix:messageChoice shortDescBinding="OPERATION@policyMsgs" promptBinding="OPERATION@policyMsgs" selectedValueBinding="operationType@servletRequest" name="auditOpsList" onChange="submitForm('policyForm', true, {event:'showUsers'})">
                                                <uix:contents>
                                                    <uix:option textBinding="POLICY_APPLIED@policyMsgs" shortDescBinding="POLICY_APPLIED@policyMsgs" value="0"/>
                                                    <uix:option textBinding="POLICY_REMOVED@policyMsgs" value="1"/>
                                                    <uix:option textBinding="LABEL_PRIVS_SET@policyMsgs" value="2"/>
                                                    <uix:option textBinding="ALL_PRIVS@policyMsgs" value="3"/>
                                                </uix:contents> 
                                            </uix:messageChoice>
                                            <uix:rowLayout>
                                                <uix:contents>
                                                    <uix:cellFormat>
                                                        <uix:contents>
                                                            <uix:spacer width="10" height="20"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                </uix:contents>
                                            </uix:rowLayout>
                                            <uix:header textBinding="header@auditUsersList@servletRequest">
                                                <uix:contents>
                                                    <uix:tableLayout width="55%">
                                                        <uix:contents>
                                                            <uix:rowLayout width="100%"/>
                                   
                                                            <uix:rowLayout width="100%">
                                                                <uix:contents>
                                                                    <uix:dataScope currentDataBinding="auditUsersList@servletRequest">
                                                                        <uix:table name="auditUsersList" 
                                                                            alternateTextBinding="tableAlterText"
                                                                            formSubmitted="true"
                                                                            width="100%"
                                                                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                                            minValue="1"
                                                                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                                            summaryBinding="AUDIT_USERS_SUMMARY@policyMsgs"
                                                                            shortDescBinding="AUDIT_USERS_SUMMARY@policyMsgs">
                                                                            <uix:contents>
                                                                                <uix:column>
                                                                                <uix:columnHeader>
                                                                                    <uix:sortableHeader textBinding="USER@dbMsgs" sortable="no"/>
                                                                                </uix:columnHeader> 
                                                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                                                <uix:text textBinding="<%= PolicyMsgID.NAME %>"/>
                                                                                </uix:column>
                                                                                <uix:column>
                                                                                <uix:columnHeader>
                                                                                    <uix:sortableHeader textBinding="AUDIT_ON_SUC_BY@policyMsgs" sortable="no"/>
                                                                                </uix:columnHeader> 
                                                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                                               <%--  <uix:choice disabled="true" name="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>" selectedValueBinding="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>">--%>
                                                                                    
                                                                                    <uix:switcher childNameBinding="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>">
                                                                                        <uix:case name="0">
                                                                                            <uix:text textBinding="NONE@policyMsgs"/>
                                                                                        </uix:case>
                                                                                        <uix:case name="1">
                                                                                            <uix:text textBinding="SESSION@policyMsgs"/>
                                                                                        </uix:case>
                                                                                        <uix:case name="2">
                                                                                            <uix:text textBinding="ACCESS@policyMsgs"/>
                                                                                        </uix:case>
                                                                                    </uix:switcher>
                                                                                    
                                                                               <%-- </uix:choice> --%>
                                                
                                                                                </uix:column>
                                                                                <uix:column>
                                                                                <uix:columnHeader>
                                                                                    <uix:sortableHeader textBinding="AUDIT_ON_FAIL_BY@policyMsgs" sortable="no"/>
                                                                                </uix:columnHeader> 
                                                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                                               <%--  <uix:choice disabled="true" name="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>" selectedValueBinding="<%= PolicyMsgID.AUDIT_ON_SUC_BY %>">--%>
                                                                                    
                                                                                    <uix:switcher childNameBinding="<%= PolicyMsgID.AUDIT_ON_FAIL_BY %>">
                                                                                        <uix:case name="0">
                                                                                            <uix:text textBinding="NONE@policyMsgs"/>
                                                                                        </uix:case>
                                                                                        <uix:case name="1">
                                                                                            <uix:text textBinding="SESSION@policyMsgs"/>
                                                                                        </uix:case>
                                                                                        <uix:case name="2">
                                                                                            <uix:text textBinding="ACCESS@policyMsgs"/>
                                                                                        </uix:case>
                                                                                    </uix:switcher>
                                                                                    
                                                                                </uix:column>
                                                                            </uix:contents>
                                            
                                                                        </uix:table>
                                                                    </uix:dataScope>
                                                                </uix:contents>
                                                            </uix:rowLayout>
                                                        </uix:contents>
                                                    </uix:tableLayout>
                                                </uix:contents>
                                            </uix:header>
                                        </uix:contents>
                                    </uix:header>
                                </uix:contents>
                            </uix:hideShowHeader>
                            <%-- End Of Audit Users --%>
                                         
                                </uix:case>

                        </uix:switcher>
                            
                            <%-- Policy Admins --%>
                    <uix:hideShowHeader id="adminHeader"  textBinding="POLICY_ADMINS@policyMsgs" disclosedBinding="adminHeaderState@servletRequest" formSubmitted="true" partialRenderMode="self">
                    <uix:contents>
                    
                                <uix:messageStyledText textBinding="POLICY_ADMIN_INSTR@policyMsgs" styleClass="OraInstructionText"/>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="40%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                          <uix:dataScope currentDataBinding="policyAdminsList@servletRequest">
                                            <uix:table name="policyAdminsList" 
                                            alternateTextBinding="tableAlterText"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                            minValue="1"
                                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                            summaryBinding="POLICY_ADMINS_SUMMARY@policyMsgs"
                                            shortDescBinding="POLICY_ADMINS_SUMMARY@policyMsgs">
                                            <uix:contents>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="USER@dbMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="25%"/>

                          <uix:switcher defaultCase="true" childNameBinding="saEnabled@servletRequest">

                                <uix:case name="true">
                                                
                                                <uix:text textBinding="<%= PolicyMsgID.NAME %>"/>
                                </uix:case>

                                <uix:case name="false">
                                                
                                                <uix:text textBinding='<%= new String("nik") %>'/>
                                </uix:case>
                                
                        </uix:switcher>
                                                
                                                </uix:column>
                                                
                                            </uix:contents>
                                            
                                            </uix:table>
                                          </uix:dataScope>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              
                            </uix:contents>
                    </uix:hideShowHeader>
                            
                            <%-- End of policy admins --%>
                    </uix:contents>
                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
