<%@ page contentType="text/html; charset=UTF-8"%>
<!-- Tag Libs -->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<!-- Imports -->
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.db.adm.sec.olsoid.PolicyConstants"%>
<%@ page import="oracle.sysman.db.adm.sec.common.EntDBSecConstants"%>
<%@ page import="oracle.sysman.db.rsc.sec.OLSOIDMsgID"%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource"%>

<%@ page import="oracle.sysman.emo.adm.security.olsoid.ComponentTableList"%>


<%@ include file="/oemNoscript.jspf"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="olsMsgs" class="oracle.sysman.db.rsc.sec.OLSOIDMsg"/>
  <uix:document>

      <uix:metaContainer>
          <uix:head titleBinding="title@servletRequest"/>
      </uix:metaContainer>

    
    <uix:body>
    
      <uix:form name="compartmentForm" method="POST" destinationBinding="action@servletRequest" >
      
        <uix:pageLayout shortDescBinding = "header@servletRequest" titleBinding = "header@servletRequest">
        <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
          
          
          <!--
          &lt;%@ include file=&quot;/enablePPR.jspf&quot;%&gt;
          &lt;%@ include file=&quot;/oemGlobal.jspf&quot;%&gt;
          &lt;%@ include file=&quot;/database/security/common/entdbseclogout.jspf&quot;%&gt;
          -->
          
          
          <!-- main contents -->
          <uix:contents>
            <uix:spacer width="10" height="10"/>
            
            <%--
            <uix:header text="Select Compartments:" >
              <uix:contents>
              --%>
              
                <uix:tableLayout width="100%">
                  

                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:spacer width="10" height="10"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
              
              
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>


                                              <!-- Compartments Table Starts Here -->
                                              <uix:dataScope currentDataBinding="compartmentList@servletRequest">
                                              
                                                <uix:table 
                                                       
                                                       name='<%= PolicyConstants.COMPARTMENT_TABLE_LIST %>'
                                                       alternateTextBinding="NO_ITEMS_FOUND@olsMsgs"
                                                       width="68%"
                                                       formSubmitted="true"                                                       
                                                       tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                       minValue="1"
                                                       valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                       blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                       maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                       shortDescBinding="LIST_OF_COMPARTMENTS@olsMsgs"
                                                       summaryBinding="LIST_OF_COMPARTMENTS@olsMsgs"

                                                       >

                                                  <uix:tableFormat tableBanding="rowBanding"/>
                                                      
                                                     <uix:column>
                                                      <uix:columnHeader>
                                                        <uix:styledText shortDescBinding="LONG_NAME@olsMsgs" textBinding="LONG_NAME@olsMsgs" />
                                                      </uix:columnHeader>
                                                      
                                                      <uix:columnFormat columnDataFormat="textFormat"/>
                                                      
                                                        <uix:styledText shortDescBinding="LONG_NAME@olsMsgs" textBinding="<%= ComponentTableList.LONG_NAME_INDEX %>"/>                                                    </uix:column>


                                                     <uix:column>
                                                      <uix:columnHeader>
                                                        <uix:styledText shortDescBinding="SHORT_NAME@olsMsgs" textBinding="SHORT_NAME@olsMsgs"/>
                                                      </uix:columnHeader>
                                                      
                                                      <uix:columnFormat columnDataFormat="textFormat"/>
                                                      
                                                      <uix:styledText shortDescBinding="SHORT_NAME@olsMsgs" textBinding="<%= ComponentTableList.SHORT_NAME_INDEX %>"/>                                                          
                                                      
                                                    </uix:column>

                                                     <uix:column>
                                                      <uix:columnHeader>
                                                        <uix:styledText shortDescBinding="NUM_TAG@olsMsgs" textBinding="NUM_TAG@olsMsgs" />
                                                      </uix:columnHeader>
                                                      
                                                      <uix:columnFormat columnDataFormat="numberFormat"/>
                                                      
                                                      <uix:styledText shortDescBinding="NUM_TAG@olsMsgs" textBinding="<%= ComponentTableList.NUM_TAG_NAME_INDEX %>"/>                                                                        
                                                                       
                                                          <%--             
                                          <uix:messageTextInput
                                           name="numTag" 
                                           textBinding="<%= ComponentTableList.NUM_TAG_NAME_INDEX %>"
                                           readOnlyBinding="<%= PolicyConstants.READ_ONLY %>" 
                                           maximumLength="4"
                                           > 
                                         <uix:onSubmitValidater >
                                            <uix:decimal maxPrecision="4" maxScale="0" minValue="0" maxValue="9999" />
                                        </uix:onSubmitValidater>
                                      </uix:messageTextInput>
                                      --%>
                                                    </uix:column>

                                              <uix:tableSelection>
                                                <uix:multipleSelection textBinding='<%= OLSOIDMsgID.SELECT_ITEMS_AND + "@olsMsgs" %>' shortDescBinding= '<%= OLSOIDMsgID.SELECT + "@olsMsgs" %>' />
                                              </uix:tableSelection>
                                              <uix:tableActions>
                                                <uix:pageButtonBar>
                                                  <uix:contents>
                                                    
                                                  </uix:contents>
                                                </uix:pageButtonBar>
                                              </uix:tableActions>

                                                </uix:table>
                                                
                                                </uix:dataScope>
                                                <!-- Compartments Table Ends Here -->




                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width="10" height="10"/>
                    </uix:contents>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:spacer width="10" height="10"/>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:rowLayout>

              
              
                
              </uix:tableLayout>
            
          <%--
          </uix:contents>
          </uix:header>
          --%>
          </uix:contents>
          
          <!-- Navigation -->
          
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button shortDescBinding="CANCEL@olsMsgs" textBinding="CANCEL@olsMsgs" onClick="javascript:self.close()" />
            <uix:submitButton shortDescBinding="SELECT@olsMsgs" textBinding="SELECT@olsMsgs"  name="event" valueBinding= "eventName@servletRequest" />
         </uix:pageButtonBar>
        </uix:pageButtons>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
