<%@ include file="/sdk/oemTop.jspf"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>

<%@ page import="oracle.sysman.db.adm.sec.olsoid.Util"%>
<%@ page import="oracle.sysman.db.adm.sec.olsoid.PolicyConstants"%>
<%@ page import="oracle.sysman.db.adm.sec.common.EntDBSecConstants"%>
<%@ page import="oracle.sysman.db.rsc.sec.OLSOIDMsgID"%>

<%@ page import="oracle.sysman.db.adm.sec.olsoid.PolicyTableList"%>
<%@ page import="oracle.sysman.emo.adm.security.olsoid.UserTableList"%>
<%@ page import="oracle.sysman.emo.adm.security.olsoid.AuditTableList"%>

<%@ page import="oracle.sysman.emo.util.UIXDataSource"%>
<%@ page import="oracle.sysman.emo.adm.security.olsoid.AuditOption"%>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  
  <uix:bundle name="olsMsgs" class="oracle.sysman.db.rsc.sec.OLSOIDMsg"/>
  
  <uix:document>
  
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>

      <script>

        function showUsersLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        
      </script>

    <uix:body>

      <uix:form name="policyForm" method="POST" destination="/console/database/EntDBSec/OLSOID/PolicyController" >
        <uix:formValue name="pageName" value="<%= PolicyConstants.CREATE_POLICY_ADVANCED_PAGE %>" />
        
        <uix:pageLayout shortDescBinding = "header@servletRequest" titleBinding = "header@servletRequest" >

			<%@ include file="/oemGlobal.jspf"%>
          <!--
          <%@ include file="/enablePPR.jspf"%>
          <%@ include file="/oemGlobal.jspf"%>
          <%-- <%@ include file="/database/security/common/entdbseclogout.jspf"%> --%>
          -->
          
            <%-- <uix:messages> --%>
            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            
            <%-- </uix:messages> --%>

          <!-- main contents -->

                      <uix:contents>
                        <uix:subTabLayout>
                          <uix:subTabs>
                            <uix:subTabBar selectedIndex="2">
                              <uix:contents>
                                <uix:link shortDescBinding="GENERAL@olsMsgs" textBinding="GENERAL@olsMsgs" onClick="submitForm('policyForm', true, {event:'createPolicyGeneral'})" />
                                <uix:link shortDescBinding="LABEL_COMPONENTS@olsMsgs" textBinding="LABEL_COMPONENTS@olsMsgs" onClick="submitForm('policyForm', true, {event:'createPolicyComponents'})"/>
                                <uix:link shortDescBinding="ADVANCED@olsMsgs" textBinding="ADVANCED@olsMsgs" />
                              </uix:contents>
                            </uix:subTabBar>
                          </uix:subTabs>
                          <uix:contents>
                            <uix:spacer width="10" height="10"/>
                            <uix:header shortDescBinding = "AUDITING@olsMsgs" textBinding="AUDITING@olsMsgs" >
                              <uix:contents>
                                <uix:messageStyledText textBinding="AUDIT_OPTIONS_INST_TEXT@olsMsgs" styleClass="OraInstructionText"/>
                                <uix:tableLayout width="100%">
                                  <uix:contents>
                                    <uix:rowLayout width="100%">
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer width="30" height="10"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="95%" hAlign="left">
                                          <uix:contents>
                                            <uix:stackLayout>
                                              <uix:contents>
                                                <uix:spacer width="10" height="10"/>
                                                <%--
                                                <uix:header text="Audit Label">
                                                  <uix:contents>
                                                    <uix:styledText text="Including the label in audit trail means, to record session labels  for this policy in the generic database audit trail." styleClass="OraInstructionText"/>
                                                    <uix:rowLayout/>
                                                    <uix:checkBox text="Include Label In Audit trail" name="checkBox0" checked="true"/>
                                                  </uix:contents>
                                                </uix:header>
                                                --%>
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <uix:cellFormat>
                                                      <uix:contents>
                                                        <uix:spacer width="10" height="20"/>
                                                      </uix:contents>
                                                    </uix:cellFormat>
                                                  </uix:contents>
                                                </uix:rowLayout>
                                                <uix:header shortDescBinding="AUDIT_OPTIONS@olsMsgs" textBinding="AUDIT_OPTIONS@olsMsgs">
                                                  <uix:contents>
                                                    <uix:styledText textBinding="AUDIT_OPTIONS_INST_TEXT_1@olsMsgs" styleClass="OraInstructionText"/>
                                                    <uix:rowLayout>
                                                      <uix:contents>
                                                        <uix:cellFormat>
                                                          <uix:contents>
                                                            <uix:spacer width="10" height="10"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                      </uix:contents>
                                                    </uix:rowLayout>
                                                    
                                      <!-- Audit Table Starts Here -->
                                          
                                        <uix:dataScope currentDataBinding= "auditList@servletRequest" >
                                          <uix:table name='<%= PolicyConstants.AUDIT_TABLE_LIST %>' 
                                                     alternateTextBinding="NO_ITEMS_FOUND@olsMsgs"
                                                     width="70%" 
                                                     formSubmitted="true"                                                       
                                                     tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                     minValue="1"
                                                     valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                     blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                     maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"

                                                       shortDescBinding="LIST_OF_AUDIT_OPTIONS@olsMsgs"
                                                       summaryBinding="LIST_OF_AUDIT_OPTIONS@olsMsgs"
                                                     
                                                     >
                                            
                                            <uix:tableFormat tableBanding="rowBanding"/>

                                                      <uix:contents>
                                                        <uix:column>
                                                          <uix:columnHeader> 
                                                          <uix:styledText shortDescBinding="OPERATION@olsMsgs" textBinding="OPERATION@olsMsgs"/>
                                                          </uix:columnHeader>
                                                          <uix:contents>
                                                            <uix:styledText shortDescBinding="OPERATION@olsMsgs" textBinding='<%= AuditTableList.OPERATION_INDEX  %>'/>
                                                          </uix:contents>
                                                        </uix:column>
                                                        <uix:column>
                                                          <uix:columnHeader>
                                                          <uix:styledText shortDescBinding="ENABLED@olsMsgs" textBinding="ENABLED@olsMsgs" />
                                                          </uix:columnHeader>
                                                          <uix:contents>
                                                            <uix:checkBox shortDescBinding="ENABLED@olsMsgs" name="<%= PolicyConstants.ENABLED %>" checkedBinding="<%= AuditTableList.ENABLED_INDEX%>" />
                                                          </uix:contents>
                                                          <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                                                        </uix:column>
                                                        <uix:column>
                                                          <uix:columnHeader>
                                                          <uix:styledText shortDescBinding="AUDIT_BY@olsMsgs" textBinding="AUDIT_BY@olsMsgs"/>
                                                          </uix:columnHeader>
                                                          <uix:contents>
                                                            <uix:choice shortDescBinding="AUDIT_BY@olsMsgs" name="<%= PolicyConstants.AUDIT_BY %>" selectedValueBinding="<%= AuditTableList.AUDIT_BY_INDEX  %>" >
                                                              <uix:contents>
                                                                <uix:option text="<%= AuditOption.AUDIT_BY_SESSION %>"/>
                                                                <uix:option text="<%= AuditOption.AUDIT_BY_ACCESS %>"/>
                                                              </uix:contents>
                                                            </uix:choice>
                                                          </uix:contents>
                                                        </uix:column>
                                                        <uix:column>
                                                          <uix:columnHeader>
                                                          <uix:styledText shortDescBinding="AUDIT_ON@olsMsgs" textBinding="AUDIT_ON@olsMsgs"/>
                                                          </uix:columnHeader>
                                                          <uix:contents>
                                                            <uix:choice shortDescBinding="AUDIT_ON@olsMsgs" name="<%= PolicyConstants.AUDIT_ON %>" selectedValueBinding='<%= AuditTableList.AUDIT_ON_INDEX  %>' >
                                                              <uix:contents>
                                                                <uix:option text="<%= AuditOption.AUDIT_ON_SUCCESSFUL %>" shortDescBinding="AUDIT_ON@olsMsgs" />
                                                                <uix:option text="<%= AuditOption.AUDIT_ON_NOT_SUCCESSFUL %>" shortDescBinding="AUDIT_ON@olsMsgs" />
                                                                <uix:option text="<%= AuditOption.AUDIT_ON_BOTH %>" shortDescBinding="AUDIT_ON@olsMsgs"/>
                                                              </uix:contents>
                                                            </uix:choice>
                                                          </uix:contents>
                                                        </uix:column>
                                                      </uix:contents>
                                                      <uix:tableSelection/>
                                                      <uix:tableActions/>
                                                    </uix:table>
                                                    </uix:dataScope>
                                                    <uix:rowLayout>
                                                      <uix:contents>
                                                        <uix:cellFormat>
                                                          <uix:contents>
                                                            <uix:spacer width="10" height="20"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                      </uix:contents>
                                                    </uix:rowLayout>
                                                  </uix:contents>
                                                </uix:header>
                                                <uix:spacer width="10" height="10"/>
                                              </uix:contents>
                                            </uix:stackLayout>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                            <uix:header shortDescBinding="POLICY_ADMINISTRATOR@olsMsgs" textBinding="POLICY_ADMINISTRATOR@olsMsgs">
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                                <uix:tableLayout width="75%">
                                  <uix:contents>
                                    <uix:rowLayout width="70%">
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer width="10" height="5"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="70%">
                                      <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:button shortDescBinding="ADD@olsMsgs" textBinding= '<%= OLSOIDMsgID.ADD + "@olsMsgs" %>' onClickBinding="lovDestForAdmins@servletRequest" />
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                          
                                       <uix:dataScope currentDataBinding="policyAdminList@servletRequest" >
                                          <uix:table name='<%= PolicyConstants.POLICY_ADMIN_TABLE_LIST %>' 
                                                     alternateTextBinding="NO_ITEMS_FOUND@olsMsgs"
                                                     width="100%" 
                                                     formSubmitted="true"                                                       
                                                     tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                     minValue="1"
                                                     valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                     blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                     maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"

                                                     shortDescBinding="LIST_OF_POLICY_ADMINS@olsMsgs"
                                                     summaryBinding="LIST_OF_POLICY_ADMINS@olsMsgs"
                                                     
                                                     >
                                            
                                            <uix:tableFormat tableBanding="rowBanding"/>

                                            <uix:column>

                                              <uix:columnHeader>
                                                <uix:styledText shortDescBinding='<%= OLSOIDMsgID.NAME + "@olsMsgs" %>' textBinding='<%= OLSOIDMsgID.NAME + "@olsMsgs" %>' />
                                              </uix:columnHeader>
                                              
                                              <uix:columnFormat columnDataFormat="textFormat"/>
                                              
                                               <uix:styledText shortDescBinding='<%= OLSOIDMsgID.NAME + "@olsMsgs" %>' textBinding="<%= UserTableList.USER_NIK_INDEX %>"/>
                                                
                                            </uix:column>

                                            <uix:column>

                                              <uix:columnHeader>
                                                <uix:styledText shortDescBinding='<%= OLSOIDMsgID.STATUS + "@olsMsgs" %>' textBinding='<%= OLSOIDMsgID.STATUS + "@olsMsgs" %>' />
                                              </uix:columnHeader>
                                              
                                              <uix:columnFormat columnDataFormat="textFormat"/>
                                              
                                                <uix:styledText shortDescBinding='<%= OLSOIDMsgID.STATUS + "@olsMsgs" %>' textBinding="<%= UserTableList.USER_STATUS_INDEX %>"/>
                                                
                                            </uix:column>
                                      
                                           <uix:tableSelection>
                                              <uix:multipleSelection textBinding='<%= OLSOIDMsgID.SELECT_ITEMS_AND + "@olsMsgs" %>' shortDescBinding= '<%= OLSOIDMsgID.SELECT + "@olsMsgs" %>' />
                                            </uix:tableSelection>

                                            <uix:tableActions>
                                              <uix:flowLayout>
                                                <uix:rowLayout>
                                                
                                                          <uix:contents>
                                                            
                                                          <uix:submitButton shortDescBinding= '<%= OLSOIDMsgID.REMOVE + "@olsMsgs" %>' textBinding= '<%= OLSOIDMsgID.REMOVE + "@olsMsgs" %>' name="event" value='removePolicyAdmins' renderedBinding="hide" />                                                            
                                                          
                                                          </uix:contents>

                                                
                                                </uix:rowLayout>
                                              </uix:flowLayout>
                                            </uix:tableActions>

                                            </uix:table>
                                          </uix:dataScope>

                                          
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:tip>
                                              <uix:contents>
                                                <uix:styledText textBinding="POLICY_ADMINISTRATOR_TIP@olsMsgs"/>
                                              </uix:contents>
                                            </uix:tip>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:header>
                            <uix:spacer width="10" height="10"/>
                          </uix:contents>
                        </uix:subTabLayout>
                      </uix:contents>

          <!-- Navigation -->
          <uix:location>
            <uix:breadCrumbs>


                        <uix:link shortDescBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" textBinding="ENTERPRISE_DATABASE_SECURITY@olsMsgs" destination="/console/database/EntDBSec?event=dbLogin"/>
                        <uix:link shortDescBinding="POLICY_PAGE_TITILE@olsMsgs" textBinding="POLICY_PAGE_TITILE@olsMsgs" destination="/console/database/EntDBSec/OLSOID/PolicyController?event=load" />
            

              
            </uix:breadCrumbs>
          </uix:location>
          <uix:pageStatus>
            <uix:flowLayout>
              <uix:formattedText text="" styleClass="OraInstructionText"/>
            </uix:flowLayout>
          </uix:pageStatus>
          
             <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:contents>
                                      <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@olsMsgs" textBinding="REVERT@olsMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@olsMsgs" textBinding="CANCEL@olsMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@policyBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@olsMsgs" textBinding="APPLY@olsMsgs" name="event" value="apply"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@olsMsgs" textBinding="OK@olsMsgs" name="event" value="ok"/>
                                    </uix:case>
                   </uix:switcher>

                  </uix:contents>
                </uix:pageButtonBar>
             </uix:pageButtons>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
