<%@ page contentType="text/html; charset=UTF-8"%>
<!-- Tag Libs -->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<!-- Imports -->
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.db.adm.sec.olsoid.PolicyConstants"%>
<%@ page import="oracle.sysman.db.adm.sec.common.EntDBSecConstants"%>
<%@ page import="oracle.sysman.db.rsc.sec.OLSOIDMsgID"%>
<%@ page import="oracle.sysman.emo.adm.security.olsoid.UserTableList"%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource"%>

<%@ include file="/oemNoscript.jspf"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="olsMsgs" class="oracle.sysman.db.rsc.sec.OLSOIDMsg"/>
  <uix:document>

      <uix:metaContainer>
          <uix:head titleBinding="title@servletRequest"/>
      </uix:metaContainer>

    
    <uix:body>
    
      <uix:form name="usersLov" method="POST" destinationBinding="action@servletRequest">

        <uix:pageLayout shortDescBinding='<%= OLSOIDMsgID.SELECT_USER + "@olsMsgs" %>' titleBinding='<%= OLSOIDMsgID.SELECT_USER + "@olsMsgs" %>'>
          <!-- Page can be either of Policy Admins or Policy Creators -->
          <uix:formValue name="pageName" value='<%= PolicyConstants.USER_PAGE %>'/>
          
          
          <!--
          &lt;%@ include file=&quot;/enablePPR.jspf&quot;%&gt;
          &lt;%@ include file=&quot;/oemGlobal.jspf&quot;%&gt;
          &lt;%@ include file=&quot;/database/security/common/entdbseclogout.jspf&quot;%&gt;
          -->
          
          
          <!-- main contents -->
          <uix:contents>
            <uix:spacer width="10" height="10"/>

          <%--                        
            <uix:header textBinding='<%= OLSOIDMsgID.SELECT_USER + "@olsMsgs" %>' >
              <uix:contents>
              --%>

                <uix:tableLayout width="100%">
                  
                    <uix:rowLayout width="50%" >
                    <uix:contents>
                      <uix:cellFormat width="25%" >

                          <uix:messageTextInput id="searchText" shortDescBinding='<%= OLSOIDMsgID.USER_NAME + "@olsMsgs" %>' promptBinding='<%= OLSOIDMsgID.USER_NAME + "@olsMsgs" %>' name="searchText"/>
                          
                      </uix:cellFormat>
                          
                      <uix:cellFormat width="25%" >
                          
                          <uix:submitButton shortDescBinding='<%= OLSOIDMsgID.GO + "@olsMsgs" %>' textBinding='<%= OLSOIDMsgID.GO + "@olsMsgs" %>' name="event" value="searchUser"/>
                          
                      </uix:cellFormat>
                      
                    </uix:contents>
                  </uix:rowLayout>

         

                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:spacer width="10" height="10"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
              
              
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:dataScope currentDataBinding='<%= PolicyConstants.USER_TABLE_LIST + "@servletRequest" %>'>
                            <uix:table 
                                                    name="<%= PolicyConstants.USER_TABLE_LIST %>" 
                                                    alternateTextBinding="NO_ITEMS_FOUND@olsMsgs"
                                                    width="100%" 
                                                    formSubmitted="true" 
                                                    tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>" 
                                                    minValue="1" 
                                                    valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>" 
                                                    blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                    maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"

                                                    shortDescBinding="LIST_OF_ENTERPRISE_USERS@olsMsgs"
                                                    summaryBinding="LIST_OF_ENTERPRISE_USERS@olsMsgs"

>

                              <uix:tableFormat tableBanding="rowBanding"/>
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader shortDescBinding='<%= OLSOIDMsgID.NAME + "@olsMsgs" %>' textBinding='<%= OLSOIDMsgID.NAME + "@olsMsgs" %>' sortable="true"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText shortDescBinding='<%= OLSOIDMsgID.NAME + "@olsMsgs" %>' textBinding="<%= UserTableList.USER_NIK_INDEX %>"/>
                              </uix:column>

                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader shortDescBinding='<%= OLSOIDMsgID.DISTINGUISHED_NAME + "@olsMsgs" %>' textBinding='<%= OLSOIDMsgID.DISTINGUISHED_NAME + "@olsMsgs" %>' sortable="true"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText shortDescBinding='<%= OLSOIDMsgID.DISTINGUISHED_NAME + "@olsMsgs" %>' textBinding="<%= UserTableList.USER_DN_INDEX %>"/>
                              </uix:column>
                              
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader shortDescBinding='<%= OLSOIDMsgID.STATUS + "@olsMsgs" %>' textBinding='<%= OLSOIDMsgID.STATUS + "@olsMsgs" %>' sortable="true"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText shortDescBinding='<%= OLSOIDMsgID.STATUS + "@olsMsgs" %>' textBinding="<%= UserTableList.USER_STATUS_INDEX %>"/>
                              </uix:column>
                              <uix:tableSelection>
                              
                              <uix:switcher defaultCase="false" childNameBinding="selection@servletRequest">
                              
                                  <uix:case name="true">
                                        <uix:singleSelection selectedIndex="0"  textBinding='<%= OLSOIDMsgID.SELECT_AN_ITEM_AND + "@olsMsgs" %>' shortDescBinding= '<%= OLSOIDMsgID.SELECT + "@olsMsgs" %>' />
                                  </uix:case>
                              
                                  <uix:case name="false">
                                        <uix:multipleSelection textBinding='<%= OLSOIDMsgID.SELECT_ITEMS_AND + "@olsMsgs" %>' shortDescBinding= '<%= OLSOIDMsgID.SELECT + "@olsMsgs" %>' />
                                  </uix:case>
                                  
                              </uix:switcher>
                                
                              </uix:tableSelection>
                            </uix:table>
                          </uix:dataScope>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width="10" height="10"/>
                    </uix:contents>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:spacer width="10" height="10"/>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:rowLayout>

              
              
                
              </uix:tableLayout>
            
          <%--
          </uix:contents>
          </uix:header>
          --%>

          </uix:contents>
          
          <!-- Navigation -->
          
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button shortDescBinding="CANCEL@olsMsgs" textBinding="CANCEL@olsMsgs" onClick="javascript:self.close()" />
            <uix:submitButton shortDescBinding="SELECT@olsMsgs" textBinding="SELECT@olsMsgs" name="event" valueBinding="eventName@servletRequest"  />
         </uix:pageButtonBar>
        </uix:pageButtons>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

