<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@profileBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

<uix:body>
  <uix:contents>
    <db:form name="profileForm" method="post" destination="/em/console/database/security/profile" copyParams="target,type,cancelURL,oname,otype">
      <uix:formValue name="pageName" value="/database/security/profiles/profileGeneral"/>
      <uix:pageLayout titleBinding="header@profileBean@servletRequest"> 

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
        
            <uix:subTabLayout>

              <uix:subTabs>
                <uix:subTabBar selectedIndex="0">
                  <uix:link textBinding="GENERAL@uixprofileBundle@servletRequest"/>
                  <uix:link textBinding="PASSWORD@uixprofileBundle@servletRequest"
                     onClick="submitForm('profileForm', true, {event:'passwordTab'})"/>
                </uix:subTabBar> 
              </uix:subTabs>

              <uix:contents>
                <uix:tableLayout cellSpacing="5">
                  <uix:contents>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                              <uix:case name="true">
                                <uix:messagePrompt labeledNodeId="profileName" promptBinding="NAME@uixDBObjectBundle@servletRequest" required="yes"/>
                              </uix:case>
                              <uix:case name="false">
                                <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                              </uix:case>
                            </uix:switcher>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:stackLayout>
                          <uix:textInput id="profileName" name="profileName"
                                textBinding="profileName@profileBean@servletRequest"
                                shortDescBinding="NAME@uixDBObjectBundle@servletRequest"
                                disabledBinding="editing@profileBean@servletRequest"
                                columns="60"/>
                          <uix:messageText messageBinding="Name@errors@servletRequest" messageType="error"/>

                      </uix:stackLayout>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:tableLayout>

                <!--uix:spacer height="10"/-->
                <uix:header textBinding="DETAILS@uixprofileBundle@servletRequest">
                <uix:tableLayout cellSpacing="5">
                  <uix:contents>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="cpuSess" promptBinding="CPU_SESS@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="cpuSess" 
                            name="cpuSess"
                            shortDescBinding="CPU_SESS@uixprofileBundle@servletRequest"
                            searchDescBinding="CPU_SESS@uixprofileBundle@servletRequest"
                            textBinding="cpuSess@profileLimitsBean@servletRequest"
                            onClickBinding="cpuSesslovdest@servletRequest"/>
                          
                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="cpuCall" promptBinding="CPU_CALL@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="cpuCall" 
                            name="cpuCall"
                            textBinding="cpuCall@profileLimitsBean@servletRequest"
                            shortDescBinding="CPU_CALL@uixprofileBundle@servletRequest"
                            searchDescBinding="CPU_CALL@uixprofileBundle@servletRequest"
                            onClickBinding="cpuCalllovdest@servletRequest"/>
                          
                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="connectTime" promptBinding="CONNECT_TIME@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="connectTime"
                            name="connectTime"
                            textBinding="connectTime@profileLimitsBean@servletRequest"
                            shortDescBinding="CONNECT_TIME@uixprofileBundle@servletRequest"
                            searchDescBinding="CONNECT_TIME@uixprofileBundle@servletRequest"
                            onClickBinding="connectTimelovdest@servletRequest"/>
                          
                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="idleTime" promptBinding="IDLE_TIME@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="idleTime" 
                            name="idleTime"
                            textBinding="idleTime@profileLimitsBean@servletRequest"
                            shortDescBinding="IDLE_TIME@uixprofileBundle@servletRequest"
                            searchDescBinding="IDLE_TIME@uixprofileBundle@servletRequest"
                            onClickBinding="idleTimelovdest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>
                </uix:header> 
                <!--uix:spacer height="10"/-->
                <uix:header textBinding="DATABASE_SERVICES@uixprofileBundle@servletRequest">
                <uix:tableLayout cellSpacing="5">
                  <uix:contents>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="concurSess" promptBinding="CONCUR_SESS@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="concurSess"
                            name="concurSess"
                            shortDescBinding="CONCUR_SESS@uixprofileBundle@servletRequest"
                            searchDescBinding="CONCUR_SESS@uixprofileBundle@servletRequest"
                            textBinding="concurSess@profileLimitsBean@servletRequest"
                            onClickBinding="concurSesslovdest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="readsSess" promptBinding="READS_SESS@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="readsSess"
                            name="readsSess"
                            shortDescBinding="READS_SESS@uixprofileBundle@servletRequest"
                            searchDescBinding="READS_SESS@uixprofileBundle@servletRequest"
                            textBinding="readsSess@profileLimitsBean@servletRequest"
                            onClickBinding="readsSesslovdest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="readsCall" promptBinding="READS_CALL@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="readsCall"
                            name="readsCall"
                            shortDescBinding="READS_CALL@uixprofileBundle@servletRequest"
                            searchDescBinding="READS_CALL@uixprofileBundle@servletRequest"
                            textBinding="readsCall@profileLimitsBean@servletRequest"
                           onClickBinding="readsCalllovdest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="privateSGA" promptBinding="PRIVATE_SGA@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="privateSGA"
                            name="privateSGA"
                            shortDescBinding="PRIVATE_SGA@uixprofileBundle@servletRequest"
                            searchDescBinding="PRIVATE_SGA@uixprofileBundle@servletRequest"
                            textBinding="privateSGA@profileLimitsBean@servletRequest"
                            onClickBinding="privateSGAlovdest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="compLimit" promptBinding="COMP_LIMIT@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="compLimit" 
                            name="compLimit"
                            shortDescBinding="COMP_LIMIT@uixprofileBundle@servletRequest"
                            searchDescBinding="COMP_LIMIT@uixprofileBundle@servletRequest"
                            textBinding="compLimit@profileLimitsBean@servletRequest"
                            onClickBinding="compLimitlovdest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>
                </uix:header>
              </uix:contents>
            </uix:subTabLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <jsp:include page="/database/schema/pageButtonInclude.jsp" />
                <uix:ref refID="pageButtonInclude" />
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
  </uix:contents>
</uix:body>
</uix:document>
</uix:renderingContext>


