<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@profileBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

<uix:body>
  <uix:contents>
    <db:form name="profileForm" method="post" destination="/em/console/database/security/profile" copyParams="target,type,cancelURL,oname,otype">
      <uix:formValue name="pageName" value="/database/security/profiles/profilePassword"/>
      <uix:pageLayout titleBinding="header@profileBean@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox
                  messageType="info" errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox
                  messageType="error" errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="1">
                  <uix:link textBinding="GENERAL@uixprofileBundle@servletRequest"
                     onClick="submitForm('profileForm', true, {event:'generalTab'})"/>
                  <uix:link textBinding="PASSWORD@uixprofileBundle@servletRequest"/>
                </uix:subTabBar> 

              </uix:subTabs>

              <uix:contents>
                <!--uix:spacer height="10"/-->
                <uix:header textBinding="PASSWORD@uixprofileBundle@servletRequest">
                <uix:tableLayout cellSpacing="5">
                  <uix:contents>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="expireDays" promptBinding="EXPIRE_DAYS@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="expireDays"
                            name="expireDays"
                            shortDescBinding="EXPIRE_DAYS@uixprofileBundle@servletRequest"
                            searchDescBinding="EXPIRE_DAYS@uixprofileBundle@servletRequest"
                            textBinding="expireDays@profileLimitsBean@servletRequest"
                            onClickBinding="expireDayslovdest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="lockDays" promptBinding="LOCK_DAYS@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="lockDays"
                            name="lockDays"
                            shortDescBinding="LOCK_DAYS@uixprofileBundle@servletRequest"
                            searchDescBinding="LOCK_DAYS@uixprofileBundle@servletRequest"
                            textBinding="lockDays@profileLimitsBean@servletRequest"
                            onClickBinding="lockDaysdest@servletRequest"/>
                          
                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>
                </uix:header>

                <!--uix:spacer height="10"/-->
                <uix:header textBinding="HISTORY@uixprofileBundle@servletRequest">
                <uix:tableLayout cellSpacing="5">
                  <uix:contents>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="numPasswords" promptBinding="NUM_PASSWORDS@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="numPasswords"
                            name="numPasswords"
                            shortDescBinding="NUM_PASSWORDS@uixprofileBundle@servletRequest"
                            searchDescBinding="NUM_PASSWORDS@uixprofileBundle@servletRequest"
                            textBinding="numPasswords@profileLimitsBean@servletRequest"
                            onClickBinding="numPasswordsdest@servletRequest"/>

                          <uix:messageText messageBinding="numPasswords@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="keepDays" promptBinding="KEEP_DAYS@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="keepDays"
                            name="keepDays"
                            shortDescBinding="KEEP_DAYS@uixprofileBundle@servletRequest"
                            searchDescBinding="KEEP_DAYS@uixprofileBundle@servletRequest"
                            textBinding="keepDays@profileLimitsBean@servletRequest"
                            onClickBinding="keepDaysdest@servletRequest"/>

                          <uix:messageText messageBinding="keepDays@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>
                </uix:header>

                <!--uix:spacer height="10"/-->
                <uix:header textBinding="COMPLEXITY@uixprofileBundle@servletRequest">

                <uix:tableLayout cellSpacing="5">
                  <uix:contents>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId= "complFunct" promptBinding="COMPL_FUNCT@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="complFunct"
                            name="complFunct"
                            shortDescBinding="COMPL_FUNCT@uixprofileBundle@servletRequest"
                            searchDescBinding="COMPL_FUNCT@uixprofileBundle@servletRequest"
                            textBinding="complFunct@profileLimitsBean@servletRequest"
                            onClickBinding="complFunctdest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>
                </uix:header>

                <!--uix:spacer height="10"/-->
                <uix:header textBinding="FAILED_LOGIN@uixprofileBundle@servletRequest">

                <uix:tableLayout cellSpacing="5">
                  <uix:contents>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="lockAfter" promptBinding="LOCK_AFTER@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="lockAfter"
                            name="lockAfter"
                            shortDescBinding="LOCK_AFTER@uixprofileBundle@servletRequest"
                            searchDescBinding="LOCK_AFTER@uixprofileBundle@servletRequest"
                            textBinding="lockAfter@profileLimitsBean@servletRequest"
                            onClickBinding="lockAfterdest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" >
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="lockFor" promptBinding="LOCK_FOR@uixprofileBundle@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>

                        <uix:stackLayout>
                          <uix:lovField id="lockFor"
                            name="lockFor"
                            shortDescBinding="LOCK_FOR@uixprofileBundle@servletRequest"
                            searchDescBinding="LOCK_FOR@uixprofileBundle@servletRequest"
                            textBinding="lockFor@profileLimitsBean@servletRequest"
                            onClickBinding="lockFordest@servletRequest"/>

                          <uix:messageText messageBinding="Value@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:rowLayout>

                  </uix:contents>
                </uix:tableLayout>
                </uix:header>

              </uix:contents>
            </uix:subTabLayout>


            <uix:pageButtons>
              <uix:pageButtonBar>
<%--
                <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" name="event" value="showSql" formName="profileForm"/>
                <!--uix:spacer width="10"/-->
                <uix:switcher childNameBinding="creating@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:flowLayout>
                      <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancel" formName="profileForm"/>  
                      <!--uix:spacer width="10"/-->
                      <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="apply" formName="profileForm"/>
                    </uix:flowLayout>
                  </uix:case>
                  <uix:case name="false">
                    <uix:flowLayout>
                      <uix:submitButton textBinding="REVERT@uixDBObjectBundle@servletRequest" name="event" value="revert" formName="profileForm"/>  
                      <!--uix:spacer width="10"/-->
                      <uix:submitButton textBinding="APPLY@uixDBObjectBundle@servletRequest" name="event" value="apply" formName="profileForm"/>
                    </uix:flowLayout>
                  </uix:case>
                </uix:switcher>
--%>
                <jsp:include page="/database/schema/pageButtonInclude.jsp" />
                <uix:ref refID="pageButtonInclude" />
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
    </db:form>
  </uix:contents>
</uix:body>
</uix:document>
</uix:renderingContext>
