<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@profileBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

<uix:body>
  <uix:contents>
    <db:form name="profileForm" method="post" destination="/em/console/database/security/profile" copyParams="target,type,cancelURL,oname,otype">
      <uix:formValue name="pageName" value="/database/security/profiles/profileView"/>
        <uix:pageLayout titleBinding="header@profileBean@servletRequest">
          <%@ include file="/database/global.jspf" %>

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
        
            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="profileName@profileBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>

            <%-- uix:spacer height="10"/ --%>
            <uix:header textBinding="DETAILS@uixprofileBundle@servletRequest"/>
            <uix:tableLayout cellSpacing="5">
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="CPU_SESS@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="cpuSess@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="CPU_CALL@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="cpuCall@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="CONNECT_TIME@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="connectTime@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="IDLE_TIME@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="idleTime@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>

            <%--uix:spacer height="10"/ --%>
            <uix:header textBinding="DATABASE_SERVICES@uixprofileBundle@servletRequest"/>
            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="CONCUR_SESS@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="concurSess@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="READS_SESS@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="readsSess@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="READS_CALL@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="readsCall@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="PRIVATE_SGA@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="privateSGA@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="COMP_LIMIT@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="compLimit@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>



            <%--uix:spacer height="10"/ --%>
            <uix:header textBinding="PASSWORD@uixprofileBundle@servletRequest"/>
            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="EXPIRE_DAYS@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="expireDays@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="LOCK_DAYS@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="lockDays@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>

            <%--uix:spacer height="10"/ --%>
            <uix:header textBinding="HISTORY@uixprofileBundle@servletRequest"/>
            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="NUM_PASSWORDS@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="numPasswords@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="KEEP_DAYS@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="keepDays@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>

            <%-- uix:spacer height="10"/ --%>
            <uix:header textBinding="COMPLEXITY@uixprofileBundle@servletRequest"/>

            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="COMPL_FUNCT@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="complFunct@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>

            <%--uix:spacer height="10"/ --%>
            <uix:header textBinding="FAILED_LOGIN@uixprofileBundle@servletRequest"/>

            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="LOCK_AFTER@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="lockAfter@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="300">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="LOCK_FOR@uixprofileBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                              textBinding="lockFor@profileLimitsBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                  <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
                    <uix:case name="false">
                        <jsp:include page="/database/storage/storagePageButtonViewInclude.jsp" />
                        <uix:ref refID="storagePageButtonViewInclude" />
                    </uix:case>
                    <uix:case name="true">
                    <%-- OK Button --%>
                    <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
                    </uix:case>
                  </uix:switcher>
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
  </uix:contents>
</uix:body>
</uix:document>
</uix:renderingContext>

