<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<jsp:useBean id="rfeBean"
             scope="request"
             type="oracle.sysman.db.adm.sec.rfv.RemFileEditorBean"/>
<script>
 function loadMe()
 {
   //Focus in File Contents, if the file opened is writable 
   <%
     if((rfeBean.getIsFileOpen())&&(!rfeBean.getIsFileContentsReadOnly())) {
   %>
     document.forms[0].fileContents.focus();
   <%
     } else {
   %>
     document.forms[0].fileName.focus();
   <%
     }
   %>
 }

 function myCallBack(lovWindow, event)
 {
   return true;
 }

 function launchRfs()
 {
   var rfsPageUrl = document.forms[0].rfsPageUrl.value;
   if(rfsPageUrl != "")
   {
     openWindow(window, rfsPageUrl, 'lovWindow', {width:750, height:550}, true, 'dialog', myCallBack);
   }
 }

 var isNav = (navigator.appName.indexOf("Netscape") != -1);
 if(isNav)
 {
   document.captureEvents(Event.KEYPRESS);
   document.onkeypress = getKey;
 } 

 function getKey(keyStroke)
 {         
   key = (isNav) ? keyStroke.which : event.keyCode;
   if(key == "13")
   {
     submitForm('remFileViewer', false, {event:'open'});
   }
 }

</script>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="dbMsgBundle" class="oracle.sysman.db.rsc.DBObjectMsg"/>
 <uix:bundle name="audMsgBundle" class="oracle.sysman.db.rsc.sec.AuditMsg"/>
 <uix:bundle name="commResBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
 <uix:bundle name="mntrResBundle" class="oracle.sysman.resources.MntrResourceBundle"/>

 <uix:document>
  <%@ include file="/enablePPR.jspf" %>
 
  <uix:head titleBinding="pageTitle@rfeBean@servletRequest"/>
  <uix:body onLoad="loadMe()">
   <uix:form name="remFileViewer" method="post">
     <uix:formValue name="command"    valueBinding="cmdShell@rfeBean@servletRequest"/>
     <uix:formValue name="rfsPageUrl" valueBinding="rfsPageUrl@rfeBean@servletRequest"/>
    
    <uix:pageLayout titleBinding="VIEW_OS_AUDIT_TRAILS@audMsgBundle">
     <%@ include file="/oemGlobal.jspf" %>
     <uix:messageBox renderedBinding="rendered@msgBoxData@rfeBean@servletRequest"
                     textBinding="text@msgBoxData@rfeBean@servletRequest"
                     messageTypeBinding="messageType@msgBoxData@rfeBean@servletRequest"
                     messageBinding="message@msgBoxData@rfeBean@servletRequest">
      <uix:contents childDataBinding="linkList@msgBoxData@rfeBean@servletRequest">
       <uix:link textBinding="text"
                 destinationBinding="destination"
                 longDescBinding="longDesc"/>
      </uix:contents>
     </uix:messageBox>

     <uix:spacer width="0" height="5"/>

     <uix:switcher childNameBinding="showRfePage@rfeBean@servletRequest">
      <uix:case name="true">
       <uix:tableLayout width="100%" cellSpacing="5">

        <%-- Host --%> 
        <uix:rowLayout width="100%">
         <uix:cellFormat width="50%" hAlign="middle" wrappingDisabled="true">
          <uix:messageTextInput name="host"
                                promptBinding="HOST@commResBundle" 
                                textBinding="hostName@rfeBean@servletRequest"
                                styleClass="OraDataText"
                                readOnly="true"/>
         </uix:cellFormat>

         <%-- User --%> 
         <uix:cellFormat width="50%" hAlign="left" wrappingDisabled="true">
           <uix:messageTextInput name="hostUser"
                                 promptBinding="USER@dbMsgBundle" 
                                 textBinding="hostUser@rfeBean@servletRequest"
                                 styleClass="OraDataText"
                                 readOnly="true">
             <uix:end>
               <uix:flowLayout>
                 <uix:spacer width="5" height="0"/>
                 <uix:submitButton textBinding="CHANGE@dbMsgBundle"
                                   unvalidated="true"
                                   name="event"
                                   value="switchUser"/>
               </uix:flowLayout>
             </uix:end>
           </uix:messageTextInput>
         </uix:cellFormat>
       </uix:rowLayout>

       <uix:tableLayout width="100%">
         <uix:rowLayout width="100%">
           <uix:separator/>
         </uix:rowLayout>
       </uix:tableLayout> 

        <%-- Instruction Text --%>
        <uix:rowLayout width="100%">
          <uix:styledText styleClass="OraInstructionText"
                          textBinding="VIEW_AUDIT_TRAIL_TIP@audMsgBundle"/>
        </uix:rowLayout> 

        <uix:tableLayout> 
          <uix:rowLayout> 
            <uix:spacer height="10"/> 
          </uix:rowLayout> 
        </uix:tableLayout> 

        <uix:tableLayout cellSpacing="5"> 
          <uix:rowLayout width="100%">
              <%-- File Name --%> 
              <uix:cellFormat hAlign="right" vAlign="center" wrappingDisabled="true">
               <uix:messagePrompt promptBinding="FILENAME@dbMsgBundle"/>
              </uix:cellFormat>
              <uix:cellFormat>
               <uix:messageLovField name="fileName"
                             textBinding="fileName@rfeBean@servletRequest"
                             searchDescBinding="fileNameShortDesc@rfeBean@servletRequest"
                             columns="75"
                             id="fileName"
                             onClick="launchRfs()"
                             onKeyPress="getKey()"/>
              </uix:cellFormat>
          </uix:rowLayout>
                                       
          <uix:rowLayout>
            <uix:cellFormat/> 
            <uix:submitButton textBinding="VIEW@dbMsgBundle"
                              disabledBinding="disableOpenButton@rfeBean@servletRequest"
                              name="event"
                              value="open"/>
          </uix:rowLayout>
        </uix:tableLayout> 
 
 
         <uix:tableLayout width="100%">
          <uix:rowLayout width="100%">
            <uix:separator/>
           </uix:rowLayout>
         </uix:tableLayout>
  
         <uix:header textBinding="fileContentsHeader@servletRequest">
          <uix:tableLayout width="100%">
           <uix:rowLayout width="100%">
            <%-- File Contents --%> 
            <uix:cellFormat wrappingDisabled="true">
            <uix:messageTextInput  name="fileContents"
                                   styleClass="OraInlineText"
				   shortDescBinding="AUDIT_TRAIL_CONTENTS@audMsgBundle"
                                   textBinding="fileContents@rfeBean@servletRequest"
                                   readOnly="true"
                                   rows="15"
                                   columns="110"
                                   id="fileContents"/>
            </uix:cellFormat>
           </uix:rowLayout>
          </uix:tableLayout>

         </uix:header>
        <%-- /uix:header --%>
       </uix:tableLayout>
      </uix:case>
     </uix:switcher>

    </uix:pageLayout>
   </uix:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>
