<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    
      <uix:body>
      <db:form name="foo" method="POST" destination="/console/database/security/role" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
      <uix:formValue name="pageName" value="/database/security/role/generalPage"/>
        <%@ include file="/database/global.jspf" %>
        

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
       
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="0">
              
                <uix:link textBinding="GENERAL_TAB@uixgranteeBundle@servletRequest"/>
                <uix:link textBinding="ROLE_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'roleTab'})"/>
                <uix:link textBinding="SYSTEM_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'systemTab'})"/>
                <uix:link textBinding="OBJECT_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'objectTab'})"/>
                 
                <uix:switcher childNameBinding="versionEqualOrHigherTo815@objectBean@servletRequest">
                  <uix:case name="true">
                     <uix:link textBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest"
                      onClick="submitForm('foo', true, {event:'consumerGrpTab'})"/>
                  </uix:case>
                </uix:switcher>
                
              
            </uix:subTabBar>
          </uix:subTabs>

         

            <%-- start General Information section --%>
            
            <uix:tableLayout cellSpacing="5">

              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:messagePrompt labeledNodeId="objectName" promptBinding="NAME@uixDBObjectBundle@servletRequest" required="yes"/>
                    </uix:case>
                    <uix:case name="false">
                      <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" />
                    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
     	          <uix:stackLayout>
                  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:textInput id="objectName" name="objectName" textBinding="objectName@objectBean@servletRequest" columns="50"/>
                    </uix:case>
                    <uix:case name="false">
                      <uix:styledText textBinding="objectName@objectBean@servletRequest" styleClass="OraDataText" />
                    </uix:case>
                  </uix:switcher>
                  <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                </uix:stackLayout>
              </uix:rowLayout>
              

                <%-- Authentication Types section --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="authenticationType" promptBinding="AUTHENTICATION@uixuserBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:choice id="authenticationType" name="authenticationType" onChange="submitForm('foo', true, {'event':'changeType'})"  selectedValueBinding="authenticationType@objectBean@servletRequest">
                    <uix:option textBinding="NONE@uixroleBundle@servletRequest" 
                            value="None" /> 
                    <uix:option textBinding="PASSWORD@uixroleBundle@servletRequest" 
                            value="Password" /> 
                    <uix:option textBinding="EXTERNAL@uixroleBundle@servletRequest" 
                            value="External" /> 
                    <uix:option textBinding="GLOBAL@uixroleBundle@servletRequest" 
                            value="Global" />
                  </uix:choice>
                </uix:cellFormat>
              </uix:rowLayout>
               <%-- Based on the authentication type show different data --%>
              <uix:switcher childNameBinding="authenticationTypeID@objectBean@servletRequest">
                <uix:case name="0">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                    </uix:cellFormat>
                    <uix:messagePrompt promptBinding="NONE_MSG@uixroleBundle@servletRequest"/>
                  </uix:rowLayout>
                </uix:case>
                  <uix:case name="1">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt labeledNodeId="secretPassword" promptBinding="ENTER_PASSWORD@uixuserBundle@servletRequest" required="yes"/>
                    </uix:cellFormat>
                    <uix:stackLayout>
    		      <uix:textInput id="secretPassword" name="secretPassword" secret="true" noAutoComplete="true" textBinding="secretPassword@objectBean@servletRequest" columns="50"/>
                      <uix:messageText messageBinding="secretPassword@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:case>
                <uix:case name="2">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                    </uix:cellFormat>
                    <uix:messagePrompt promptBinding="EXTERNAL_MSG@uixuserBundle@servletRequest"/>
                  </uix:rowLayout>
                </uix:case>
                <%-- uix:case name="3">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="X500NAME@uixuserBundle@servletRequest" required="yes"/>
                    </uix:cellFormat>
                    <uix:stackLayout>
    		      <uix:textInput name="dnName" textBinding="dnName@objectBean@servletRequest" columns="50"/>
                      <uix:messageText messageBinding="dnName@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:case --%>
                <uix:case name="3">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                    </uix:cellFormat>
                    <uix:messagePrompt promptBinding="GLOBAL_MSG@uixroleBundle@servletRequest"/>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>

              <uix:switcher childNameBinding="authenticationTypeID@objectBean@servletRequest">
                <uix:case name="1">
                 
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt labeledNodeId="secretConfirmPassword" promptBinding="CONFIRM_PASSWORD@uixuserBundle@servletRequest" required="yes"/>
                    </uix:cellFormat>
                    <uix:stackLayout>
    		      <uix:textInput id="secretConfirmPassword" name="secretConfirmPassword" noAutoComplete="true" secret="true" textBinding="secretConfirmPassword@objectBean@servletRequest" columns="50"/>
                      <uix:messageText messageBinding="secretConfirmPassword@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                  </uix:case>
                 </uix:switcher>

              <uix:switcher childNameBinding="authenticationTypeID@objectBean@servletRequest">
                <uix:case name="1">
                  <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                   <uix:messagePrompt prompt=""/>
                  </uix:cellFormat>
                  <uix:messagePrompt promptBinding="PASSWORD_MSG@uixuserBundle@servletRequest"/>
                  </uix:rowLayout>
                  </uix:case>
                 </uix:switcher>

          </uix:tableLayout>
          
        </uix:subTabLayout>
        
        
        <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />            
	  </uix:pageButtonBar>
        </uix:pageButtons>
         
      </uix:pageLayout>
      </db:form>
      </uix:body>
   
</uix:document>
</uix:renderingContext>  

