<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@showgranteeBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/security/role" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="header@showgranteeBean@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        
        <uix:formValue name="pageName" value="/database/security/role/showGranteesPage"/>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        <uix:subTabLayout>
          
         
         <uix:header textBinding="granteeusersheader@showgranteeBean@servletRequest">
        
          <uix:tableLayout width="100%"> 
            
            <uix:rowLayout hAlign="right"> 
               <uix:submitButton 
                        textBinding="ADD@uixDBObjectBundle@servletRequest"
                        name="event"
                        value="addusergrantee" />
                    
            </uix:rowLayout> 
          
          <uix:rowLayout>
              <%--- User Table ---%>
              <oem:table  name="granteeuserTableUI" blockSize="10"
                formSubmitted="true"               
                dataSourceProp="granteeuserTableUI"
                beanKey="granteeuserDS"
                summaryBinding="granteeusersheader@showgranteeBean@servletRequest"
                alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" >
                <uix:tableSelection>
                  <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectionBinding="selection@granteeuserDS@servletRequest" selectedBinding="selected" >
                    <uix:submitButton
                    textBinding="REMOVE@uixuserBundle@servletRequest"
                      name="event"
                      value="deleteusergrantee"/>
                  </uix:multipleSelection>
                </uix:tableSelection>
              </oem:table>
          </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>
          
         <uix:header textBinding="granteerolesheader@showgranteeBean@servletRequest">
          <uix:tableLayout width="100%"> 
          <uix:rowLayout hAlign="right"> 
            <uix:submitButton 
                        textBinding="ADD@uixDBObjectBundle@servletRequest"
                        name="event"
                        value="addrolegrantee" />
                    
          </uix:rowLayout> 
          
          <uix:rowLayout>
              <%--- Role Table ---%>
              <oem:table  name="granteeroleTableUI" blockSize="10"
                formSubmitted="true"               
                dataSourceProp="granteeroleTableUI"
                beanKey="granteeroleDS"
                summaryBinding="granteerolesheader@showgranteeBean@servletRequest"
                alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" >
                <uix:tableSelection>
                  <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectionBinding="selection@granteeroleDS@servletRequest" selectedBinding="selected" >
                    <uix:submitButton
                      textBinding="REMOVE@uixuserBundle@servletRequest"
                      name="event"
                      value="deleterolegrantee"/>
                  </uix:multipleSelection>
                </uix:tableSelection>
              </oem:table>
          </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>
        </uix:subTabLayout>
        <uix:pageButtons>
          <uix:pageButtonBar>
            
            <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" name="event" value="showSql"/>
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancel"/>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="apply"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
       </db:form>
      </uix:body>
    
</uix:document>
</uix:renderingContext> 

