<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    <uix:body>
      <db:form name="foo" method="POST" destinationBinding="destination@objectBean@servletRequest" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        
        <uix:formValue name="pageName" value="/database/security/rolePage"/>
        <uix:formValue name="miscCode" valueBinding="miscCode@objectBean@servletRequest" />
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="1">
              
                <uix:link textBinding="GENERAL_TAB@uixgranteeBundle@servletRequest"
                onClick="submitForm('foo', true, {event:'generalTab'})"/>
                <uix:link textBinding="ROLE_TAB@uixgranteeBundle@servletRequest" />
              <%
			  //change to uix tags once documentation is up
				boolean areAllTabsAccesible = true;
				if(request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR") !=null) 
				{
					areAllTabsAccesible = ((Boolean)request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR")).booleanValue();
				}
				if(areAllTabsAccesible){
				%>
                <uix:link textBinding="SYSTEM_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'systemTab'})"/>
                <uix:link textBinding="OBJECT_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'objectTab'})"/>
                <uix:switcher childNameBinding="userObject@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                        <uix:case name="false">
                        <uix:link textBinding="QUOTA_TAB@uixuserBundle@servletRequest" 
                          onClick="submitForm('foo', true, {event:'quotaTab'})"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                </uix:switcher>
                    <uix:switcher childNameBinding="versionEqualOrHigherTo815@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                        <uix:case name="false">
                          <uix:link textBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest"
                            onClick="submitForm('foo', true, {event:'consumerGrpTab'})"/>
                        </uix:case>
                      </uix:switcher>
                      </uix:case>
                  </uix:switcher>
                  <uix:switcher childNameBinding="userObject@objectBean@servletRequest">
                   <uix:case name="true">
                    <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                        <uix:case name="false">
                          <uix:link textBinding="PROXY_TAB@uixuserBundle@servletRequest"
                            onClick="submitForm('foo', true, {event:'proxyTab'})"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>
				  <%}%>
            </uix:subTabBar>
          </uix:subTabs>

          
            <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="right" >

                  <uix:submitButton textBinding="ADD_DEL_BTN@uixgranteeBundle@servletRequest" name="event" value="addRolePriv" />
                </uix:rowLayout>  
                
                <uix:rowLayout  >
			<uix:messagePrompt messageType="warning" prompt="The Roles are shown empty as the logged in user does not have the privilege to select from the concerned data dictionary views." renderedBinding="rolesNotVisibleAsUserIsDVAcctmgr@rolePageBean@servletRequest"/>                
                </uix:rowLayout>  
                <uix:rowLayout>
                
                
                    <oem:table name="rolesTableUI" beanKey="rolePageBean" blockSize="25"
                              destinationBinding="destination@rolePageBean@servletRequest" formSubmitted="true"
                              summaryBinding="ROLE_TAB@uixgranteeBundle@servletRequest"
                              dataSourceProp="rolesTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%">                    
                    </oem:table>
                
                 </uix:rowLayout>

            </uix:tableLayout>
        </uix:subTabLayout>
    
          <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />
          </uix:pageButtonBar>
        </uix:pageButtons>
        
      </uix:pageLayout>
      </db:form>
      </uix:body>
    
</uix:document>
</uix:renderingContext> 

