<%@ include file="/sdk/oemTop.jspf"%>
<%@ include file="/oemNoscript.jspf"%>
<%-- Tag Libraries--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%-- Imports--%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages"%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="tdeMsgs" class="oracle.sysman.db.rsc.sec.tde.TDEMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <db:script src="/database/utils.js"/>
    <script language="javascript">
function setMasterKey()
{
   if (document.forms[0].masterKey.checked == true)
   {
     if (document.forms[0].closeWallet.checked == true)
       document.forms[0].closeWallet.checked = false;
   }	
}

function setCloseWallet()
{
   if (document.forms[0].closeWallet.checked == true)
   {
    if (document.forms[0].masterKey.checked == true)
       document.forms[0].masterKey.checked = false;
     }
}
function confirmMigrateAction()
{
		var answer = confirm("Migrating to HSM is an irreversible process.Are you sure you want to migrate?")		
		if (answer){		
		    return true;
		}
		else{
			//nothing be on same page
			return false;
		}  
}
</script>
    <%-- HTML Page Title--%>
    <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <noscript>A browser with Javascript enabled is required for this page to
              operate properly.</noscript>
    <uix:body>
      <%-- HTML Form--%>
      <db:form name="tblForm" method="post"
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype,guid,version,initMethod">
        <uix:formValue name="cancelURL"
                       valueBinding="cancelURL@servletRequest"/>
        <uix:formValue name="pageName" value="TDEMain">
          <uix:pageLayout titleBinding="header@servletRequest">
            <%@ include file="/database/global.jspf"%>
            <oem:messageBox messageType="info"
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat width="60%" vAlign="top">
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <%-- <uix:spacer width="10" height="10"/>--%>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:styledText textBinding="TDE_OVERVIEW@tdeMsgs"
                                  styleClass="OraInstructionText"/>
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:spacer width="10" height="10"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat styleClass="OraInstructionText"
                                    hAlign="left" vAlign="top" width="80%">
                      <uix:spacer width="5" height="5"/>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout renderedBinding="ESModuleHSM@tdeBean@servletRequest">
                    <uix:cellFormat hAlign="left" vAlign="top" width="95%">
                      <uix:labeledFieldLayout width="80%" 
                                              styleClass="OraInstructionTextStrong" >

	                   <uix:messageStyledText textBinding="HSM_ESM@tdeMsgs"
                                               promptBinding="ESModule@tdeMsgs"
                                               styleClass="OraDataText"/>
                        <uix:messageStyledText textBinding="hsmStatus@tdeBean@servletRequest"
                                               promptBinding="HSM_STATUS@tdeMsgs"
                                               styleClass="OraDataText"/>
                      </uix:labeledFieldLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>


                  <uix:rowLayout renderedBinding="ESModuleWallet@tdeBean@servletRequest">
                    <uix:cellFormat hAlign="left" vAlign="top" width="100%">

                      <uix:labeledFieldLayout  width="100%" styleClass="OraInstructionTextStrong" >

	                   <uix:messageStyledText textBinding="WALLET_ESM@tdeMsgs"
                                               promptBinding="ESModule@tdeMsgs"
                                               styleClass="OraDataText"/>
                        <uix:messageStyledText textBinding="walletLocation@tdeBean@servletRequest"
                                               promptBinding="WALLET_LOCATION@tdeMsgs"
                                               styleClass="OraDataText"/>
                        <uix:messageStyledText textBinding="walletStatus@tdeBean@servletRequest"
                                               promptBinding="WALLET_STATUS@tdeMsgs"
                                               styleClass="OraDataText"/>
                      </uix:labeledFieldLayout>
                    </uix:cellFormat>                    
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat styleClass="OraInstructionText"
                                    hAlign="left" vAlign="top" width="80%">
                      <uix:spacer width="10" height="10"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="walletOpen@tdeBean@servletRequest">
                    <uix:cellFormat hAlign="right" vAlign="top" width="5%">
                      <uix:image source="/em/database/security/tde/images/unlocked_status.gif"
                                 shortDescBinding="UNLOCKED@tdeMsgs"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" vAlign="bottom" width="60%">
                      <uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="OPEN_INFO1@tdeMsgs"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="OPEN_INFO2@tdeMsgs"/>
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="walletCloseMsg@tdeBean@servletRequest">
                    <uix:cellFormat hAlign="right" vAlign="top" width="5%">
                      <uix:image source="/em/database/security/tde/images/locked_status.gif"
                                 shortDescBinding="LOCKED@tdeMsgs"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" vAlign="bottom" width="60%">
                      <uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="CLOSE_INFO@tdeMsgs"/>
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="walletNotExist@tdeBean@servletRequest">
                    <uix:cellFormat hAlign="right" vAlign="top" width="5%">
                      <uix:image source="/em/database/security/tde/images/warningicon_status.gif"
                                 shortDescBinding="WARN@tdeMsgs"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" vAlign="bottom" width="60%">
                      <uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="NOT_EXIST_INFO@tdeMsgs"/>
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                
                
                
                
                  <uix:rowLayout>
                    <uix:cellFormat styleClass="OraInstructionText"
                                    hAlign="left" vAlign="top" width="80%">
                      <uix:spacer width="5" height="5"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                
                <%-- Password input when wallet is closed --%>
			<uix:rowLayout width="97%" renderedBinding="HSMClose@tdeBean@servletRequest">
                  <uix:rowLayout width="97%" renderedBinding="walletClose@tdeBean@servletRequest">
                    <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                      <uix:header textBinding="ENABLE_TDE@tdeMsgs">

					  	  <uix:rowLayout hAlign="right">
							<uix:submitButton textBinding="OPEN@tdeMsgs"
	                           shortDescBinding="OPEN_MSG@tdeMsgs" name="event"
	                           value="open" />
						 </uix:rowLayout>
                        <uix:rowLayout renderedBinding="walletNotExist@tdeBean@servletRequest">
                          <uix:cellFormat width="60%" vAlign="top">
                            <uix:styledText textBinding="CREATE_WALLET_MSG@tdeMsgs"
                                            styleClass="OraInstructionText"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout renderedBinding="walletCloseMsg@tdeBean@servletRequest">
                          <uix:cellFormat width="60%" vAlign="top">
                            <uix:styledText textBinding="ENABLE_TDE_MSG@tdeMsgs"
                                            styleClass="OraInstructionText"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:cellFormat styleClass="OraInstructionText"
                                          hAlign="left" vAlign="top"
                                          width="80%">
                            <uix:spacer width="5" height="5"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:cellFormat>
                            <uix:spacer width="5" height="5"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                       
                        <uix:rowLayout>
                        
                          <uix:dataScope currentDataBinding="tdeBean@servletRequest">
                            <uix:labeledFieldLayout columns="1">
                              <uix:messageTextInput name="walletPasswd"
                                                    promptBinding="WALLET_PASSWD@tdeMsgs"
                                                    shortDescBinding="WALLET_PASSWD@tdeMsgs"
                                                    secret="true"
													noAutoComplete="true"
                                                    />

                            </uix:labeledFieldLayout>
                          </uix:dataScope>
                        </uix:rowLayout>
                      </uix:header>
                    </uix:cellFormat>
                  </uix:rowLayout>
                 </uix:rowLayout>
                <%-- Password input when wallet is closed --%>

								<%-- Wallet Option  Section : start --%>
                                <uix:rowLayout width="95%" renderedBinding="ESModuleWallet@tdeBean@servletRequest" >
								<uix:header textBinding="WO_TITLE@tdeMsgs">
										<uix:spacer width="10" height="10"/>
										<uix:tableLayout width="100%" >										 					
										  <uix:rowLayout hAlign="left">
										  <uix:cellFormat  hAlign="left">
												<uix:messagePrompt promptBinding="WO_MSG@tdeMsgs" />
												</uix:cellFormat>
												<uix:cellFormat hAlign="right">
								      <uix:submitButton textBinding="APPLY@tdeMsgs"
				                                  shortDescBinding="APPLY@tdeMsgs" name="event"
												  value="applywo"/>
												</uix:cellFormat>
							    		  </uix:rowLayout>
										  <uix:rowLayout hAlign="left">
										   <uix:cellFormat columnSpan="2" >
										<uix:messageRadioButton name="walletOption" selected="true" value="encrypt" 
										 textBinding="WO1@tdeMsgs" tipBinding="WO1_TIP@tdeMsgs"  />
										<uix:messageRadioButton name="walletOption" value="sso" textBinding="WO2@tdeMsgs" tipBinding="WO2_TIP@tdeMsgs"   />
										<uix:messageRadioButton name="walletOption" value="localsso" textBinding="WO3@tdeMsgs" tipBinding="WO3_TIP@tdeMsgs"  />
											<%--uix:checkBox textBinding="MAKE_LOCAL@tdeMsgs"
                                                  name="makelocal"
                                                  shortDescBinding="MAKE_LOCAL_KEY@tdeMsgs" --%>
										 </uix:cellFormat>
						    		  </uix:rowLayout>
									</uix:tableLayout>
								  </uix:header>
                                </uix:rowLayout>
								<%-- Wallet Option Section : End --%>
                  <%-- Advanced options start--%>
                  <uix:rowLayout >
                      <uix:spacer width="2" height="2"/>
                      <uix:hideShowHeader id="advOptionsState"
                                          textBinding="ADV_OPTIONS@tdeMsgs"
                                          disclosedBinding="advOptionsState@servletRequest"
                                          formSubmitted="true"
                                          partialRenderMode="self"
                                          shortDescBinding="ADV_OPTIONS@tdeMsgs">										                   

                        <uix:spacer width="5" height="5"/>
							<%--   Close wallet button : start --%>
							<uix:rowLayout width="95%" renderedBinding="walletOpen@tdeBean@servletRequest">
                              <uix:header textBinding="DISABLE_TDE@tdeMsgs">	
							   <uix:spacer width="5" height="5"/>
								<uix:rowLayout hAlign="left">
									  <uix:cellFormat width="60%" wrappingDisabled="true">	
									  <uix:styledText textBinding="DISABLE_TDE_MSG@tdeMsgs"
													  styleClass="OraInstructionText"/>
									   </uix:cellFormat>
									   <uix:cellFormat vAlign="top" hAlign="right">	
									   <uix:submitButton textBinding="CLOSE@tdeMsgs"
										   shortDescBinding="CLOSE_MSG@tdeMsgs" name="event"
										   value="close"/>
									   </uix:cellFormat>								
								</uix:rowLayout>
                              </uix:header>
                            </uix:rowLayout>
							<%--   Close wallet button : stop --%>
							<%--   Close HSM button : start --%>
                            <uix:rowLayout width="95%" renderedBinding="HSMOpen@tdeBean@servletRequest">
							<uix:rowLayout width="100%" renderedBinding="walletNotOpen@tdeBean@servletRequest">
                              <uix:header textBinding="DISABLE_TDE@tdeMsgs">
							   <uix:spacer width="5" height="5"/>
								<uix:rowLayout hAlign="left">
									  <uix:cellFormat width="60%" wrappingDisabled="true">	
									  <uix:styledText textBinding="DISABLE_TDE_MSG@tdeMsgs"
													  styleClass="OraInstructionText"/>
									   </uix:cellFormat>
									   <uix:cellFormat vAlign="top" hAlign="right">	
									   <uix:submitButton textBinding="CLOSE@tdeMsgs"
										   shortDescBinding="CLOSE_MSG@tdeMsgs" name="event"
										   value="close"/>
									   </uix:cellFormat>
									</uix:rowLayout>

                              </uix:header>

                            </uix:rowLayout>
							</uix:rowLayout>

							<%--  Close HSM button : End   --%>


					  <%-- Regenerate option : start--%>
                            <uix:rowLayout width="95%">
                              <uix:header textBinding="REGEN_MASTER_KEY@tdeMsgs">									
	  							   <uix:spacer width="5" height="5"/>
									<uix:rowLayout hAlign="left">
									  <uix:cellFormat width="80%" wrappingDisabled="false">	
									  <uix:styledText textBinding="REGEN_MASTER_KEY_MSG@tdeMsgs"
													  styleClass="OraInstructionText"/>
									   </uix:cellFormat>
									   <uix:cellFormat vAlign="top" hAlign="right">	
									   <uix:submitButton textBinding="REGEN@tdeMsgs"
										   shortDescBinding="REGEN@tdeMsgs" name="event"
										   value="regenerate"/>
									   </uix:cellFormat>
									</uix:rowLayout>

                              </uix:header>
                            </uix:rowLayout>
                       <%-- Regenerate option : End--%>
							
								<uix:rowLayout>
								  <uix:cellFormat>
									<uix:spacer width="10" height="10"/>
								  </uix:cellFormat>
								</uix:rowLayout>

								<%-- Migrate Section : start --%>
                                <uix:rowLayout width="95%" renderedBinding="ESModuleWallet@tdeBean@servletRequest">
								<uix:header renderedBinding="HSMOpenOnly@tdeBean@servletRequest" textBinding="MIGRATE_TITLE@tdeMsgs">
								   <uix:spacer width="5" height="5"/>
									<uix:rowLayout hAlign="left">
									  <uix:cellFormat width="80%" wrappingDisabled="false">	
									  <uix:styledText textBinding="MIGRATE_MSG@tdeMsgs"
													  styleClass="OraInstructionText"/>
									   </uix:cellFormat>
									   <uix:cellFormat vAlign="top" hAlign="right">	
									   <uix:submitButton textBinding="MIGRATE@tdeMsgs"
										   shortDescBinding="MIGRATE@tdeMsgs" name="event"
										   value="Migrate"/>
									   </uix:cellFormat>
									</uix:rowLayout>
								  </uix:header>
                                </uix:rowLayout>
								<%-- Migrate Section : End --%>

								<uix:rowLayout>
								  <uix:cellFormat>
									<uix:spacer width="10" height="10"/>
								  </uix:cellFormat>
								</uix:rowLayout>


								<%-- Change wallet location : start --%>
                                <uix:rowLayout width="95%" renderedBinding="ESModuleWallet@tdeBean@servletRequest">
								<uix:header textBinding="CHANGE_LOC_TITLE@tdeMsgs">
    							   <uix:spacer width="5" height="5"/>
									<uix:rowLayout hAlign="left">
									  <uix:cellFormat width="80%" wrappingDisabled="false">	
									  <uix:styledText textBinding="CHANGE_LOC_MSG@tdeMsgs"
													  styleClass="OraInstructionText"/>
									   </uix:cellFormat>
									   <uix:cellFormat vAlign="top" hAlign="right">	
									   <uix:submitButton textBinding="CHANGE@tdeMsgs"
										   shortDescBinding="CHANGE@tdeMsgs" name="event"
										   value="changeLoc"/>
									   </uix:cellFormat>
									</uix:rowLayout>

	                               		                            
								  </uix:header>
                                </uix:rowLayout>
								<%-- Change wallet location : End --%>
							

								<%-- Change p12 wallet password : start --%>
                                <uix:rowLayout width="95%" renderedBinding="ESModuleWallet@tdeBean@servletRequest">
								<uix:header textBinding="CHANGE_PSWD_TITLE@tdeMsgs">								
							   <uix:spacer width="5" height="5"/>
								<uix:rowLayout hAlign="left">
									  <uix:cellFormat width="80%" wrappingDisabled="false">	
									  <uix:styledText textBinding="CHANGE_PSWD_MSG@tdeMsgs"
													  styleClass="OraInstructionText"/>
									   </uix:cellFormat>
									   <uix:cellFormat vAlign="top" hAlign="right">	
									   <uix:submitButton textBinding="CHANGE_PSWD@tdeMsgs"
										   shortDescBinding="CHANGE_PSWD@tdeMsgs" name="event"
										   value="changePwd"/>
									   </uix:cellFormat>								
								</uix:rowLayout>									
	                               		                            
								  </uix:header>
                                </uix:rowLayout>
								<%-- Change p12 wallet password : End --%>

                      </uix:hideShowHeader>

                  </uix:rowLayout>
                  <%-- Advanced options end--%>
                </uix:cellFormat>
                <uix:cellFormat width="40%" vAlign="top">
                  <uix:contentContainer width="100%"
                                        textBinding="ENCRYPT_PROCESS_OVERVIEW@tdeMsgs">
                    <uix:stackLayout>
                      <uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="ENCRYPT_PROCESS_LINE1@tdeMsgs"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="ENCRYPT_PROCESS_LINE2@tdeMsgs"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="ENCRYPT_PROCESS_LINE3@tdeMsgs"/>
                      </uix:rowLayout>

						<uix:styledList listStyle="circle" >
						<uix:contents>
							<uix:styledItem>
							  <uix:styledText styleClass="OraInlineInfoText"
											  textBinding="ENCRYPT_PROCESS_LINE31@tdeMsgs"/>
							</uix:styledItem>
							<uix:styledItem>
							  <uix:styledText styleClass="OraInlineInfoText"
																	textBinding="ENCRYPT_PROCESS_LINE32@tdeMsgs"/>
							</uix:styledItem>
							<uix:styledItem>
							  <uix:styledText styleClass="OraInlineInfoText"
																	textBinding="ENCRYPT_PROCESS_LINE33@tdeMsgs"/>
							</uix:styledItem>
							<uix:styledItem>
							  <uix:styledText styleClass="OraInlineInfoText"
																	textBinding="ENCRYPT_PROCESS_LINE34@tdeMsgs"/>
							</uix:styledItem>
						</uix:contents>
						</uix:styledList>

                      <uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="ENCRYPT_PROCESS_LINE4@tdeMsgs"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="ENCRYPT_PROCESS_LINE5@tdeMsgs"/>
                      </uix:rowLayout>
                      <%--uix:rowLayout>
                        <uix:spacer width="5" height="5"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="ENCRYPT_PROCESS_LINE6@tdeMsgs"/>
                      </uix:rowLayout--%>

                    </uix:stackLayout>
                  </uix:contentContainer>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%" hAlign="left">
                <uix:cellFormat hAlign="left">
                  <uix:header textBinding="RELATED_LINK@tdeMsgs">
                    <uix:rowLayout>
                      <uix:spacer width="5" height="35"/>
                      <uix:link textBinding="tableLink@tdeMsgs"
                                destinationBinding="tblLink@servletRequest"/>
                      <uix:spacer width="30" height="5"/>
                      <uix:link textBinding="impExpLink@tdeMsgs"
                                destinationBinding="impExpLink@servletRequest"/>
                      <uix:spacer width="30" height="5"/>
                      <uix:link textBinding="tablespLink@tdeMsgs"
                                destinationBinding="tblspLink@servletRequest"/>
                    </uix:rowLayout>
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <%-- END: TABLE VIEW PAGE ends here--%>
            <%-- Table Buttons--%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- CANCEL BUTTON--%>
                <uix:submitButton shortDescBinding="CANCEL@tdeMsgs"
                                  textBinding="CANCEL@tdeMsgs" name="event"
                                  value="cancel"/>
                <%-- OK BUTTON--%>
                <%-- uix:submitButton textBinding="OK@tdeMsgs" name="event"
                                  value="OK" shortDescBinding="OK@tdeMsgs" --%>
              </uix:pageButtonBar>
            </uix:pageButtons>
          </uix:pageLayout>
        </uix:formValue>
      </db:form>
    </uix:body>
    <%-- END: HTML Form--%>
  </uix:document>
</uix:renderingContext>
<%-- END: Content--%>
