<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants"%>
<%@ page import="oracle.sysman.db.adm.sec.common.EntDBSecConstants"%>
<%@ page import="oracle.sysman.db.adm.ParameterNames"%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="UMUMsgs" class="oracle.sysman.db.rsc.sec.UMUMsg"/>
  	 <uix:document>
              <%@ include file="/oemTitle.jspf" %>
		
		      <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
          </uix:metaContainer>
    
          <uix:body>    
          	<uix:form name="form0" method="POST"  destination="/console/database/EntDBSec/UMU">
          		<uix:formValue name="<%=ParameterNames.PAGE_NAME%>" value="<%=EntDBSecConstants.CONFIRMATION_URL%>"/>
          		<uix:formValue name="<%=ParameterNames.TARGET%>" valueBinding="target@servletRequest"/>
              <uix:formValue name="<%=ParameterNames.TYPE%>" valueBinding="type@servletRequest"/>	
          		<uix:pageLayout>
          			<%@ include file="/enablePPR.jspf" %>
			          <%@ include file="/oemGlobal.jspf" %>
			          
			          	<uix:spacer width="10" height="20"/>
									<uix:header textBinding="CONFIRMATION_HEADER@UMUMsgs">
									  <uix:contents/>
									</uix:header>
									<uix:messageBox messageType="confirmation" message="The users you selected have been migrated and the results are listed below.Unless otherwise noted, migration to an enterprise user was successful and the user password has been set in the directory as indicated. Errors encountered during migration are listed, and those users' database accounts have not been modified. To migrate those users, correct the problems listed, return to the database users page and select them for migration again."/>
									<uix:spacer height="10" width="10"/>
									<uix:spacer height="10" width="10"/>
									
									<uix:header text="Migrated Users">
												<uix:dataScope currentDataBinding='<%=EntDBSecConstants.MIG_USER_RECORD_LIST+"@servletRequest"%>' >
			    								<uix:table width="100%"
							              formSubmitted="true"
							              id="MIG_USER_RECORD_LIST_TABLE"
							              tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
							              valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
							              maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
							              blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
							              summaryBinding="MIGRATED_USERS_LIST_SUMMARY@UMUMsgs"
                                                                      alternateTextBinding="NO_ITEMS_FOUND@UMUMsgs">
							     					
							     					<uix:column>
							        					<uix:columnHeader>
								        						<uix:text textBinding = "USERNAME@UMUMsgs"/>
							        					</uix:columnHeader>
							        					<uix:columnFormat columnDataFormat="textFormat" />
							        					<uix:styledText textBinding="USER_NAME_INDEX" />
							     					</uix:column>	
							     					<uix:column>
							        					<uix:columnHeader>
								        						<uix:text textBinding = "SCHEMA@UMUMsgs"/>
							        					</uix:columnHeader>
							        					<uix:columnFormat columnDataFormat="textFormat" />
							        					<uix:styledText textBinding="OLD_SCHEMA_INDEX" />
							     					</uix:column>	
							     					<uix:column>
							        					<uix:columnHeader>
								        						<uix:text textBinding = "DIR_ENTRY_CN@UMUMsgs"/>
							        					</uix:columnHeader>
							        					<uix:columnFormat columnDataFormat="textFormat" />
							        					<uix:styledText textBinding="DIR_ENTRY_CN_INDEX" />
							     					</uix:column>	
							     					<uix:column>
							        					<uix:columnHeader>
								        						<uix:text textBinding = "USER_DN@UMUMsgs"/>
							        					</uix:columnHeader>
							        					<uix:columnFormat columnDataFormat="textFormat" />
							        					<uix:styledText textBinding="USER_DN_INDEX" />
							     					</uix:column>	
							     					<uix:column>
							        					<uix:columnHeader>
								        						<uix:text textBinding = "USER_DN_EXISTS@UMUMsgs"/>
							        					</uix:columnHeader>
							        					<uix:columnFormat columnDataFormat="textFormat" />
							        					<uix:image source="/em/images/completeind_status.gif" hAlign="center" renderedBinding="USER_DN_EXISTS" shortDescBinding="USER_DN_EXISTS@UMUMsgs"/>
							     					</uix:column>	
							     					<uix:column>
							        					<uix:columnHeader>
								        						<uix:text textBinding = "DB_PWD_SET@UMUMsgs"/>
							        					</uix:columnHeader>
							        					<uix:columnFormat columnDataFormat="textFormat" />
							        					<uix:image source="/em/images/completeind_status.gif" hAlign="center" renderedBinding="DB_PWD_SET_INDEX" shortDescBinding="DB_PWD_SET@UMUMsgs"/>
				     								</uix:column>	
                                                                                                 <uix:column>
							        					<uix:columnHeader>
								        						<uix:text textBinding = "MIGRATION_HEADER@UMUMsgs"/>
							        					</uix:columnHeader>
							        					<uix:columnFormat columnDataFormat="textFormat" />
							        					<uix:styledText textBinding="MIGRATION_STATUS_INDEX" />
							     					</uix:column>	
							     					<uix:column>
							        					<uix:columnHeader>
								        						<uix:text textBinding = "ERRORS@UMUMsgs"/>
							        					</uix:columnHeader>
							        					<uix:columnFormat columnDataFormat="textFormat" />
							        					<uix:styledText textBinding="ERRORS_INDEX" />
							     					</uix:column>	
                            
							     		</uix:table>
				             </uix:dataScope>								
									</uix:header>
			          <uix:pageButtons>
					          <uix:pageButtonBar>
					              <uix:contents>
					                   <uix:submitButton text="Ok" shortDescBinding="Ok" name="event" value="cancel"/>
					               </uix:contents>
					            </uix:pageButtonBar>
					       </uix:pageButtons>
			        </uix:pageLayout>
          	</uix:form>
          </uix:body>
        </uix:document>
</uix:renderingContext>  
