<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.db.adm.sec.common.EntDBSecConstants"%>
<%@ page import="oracle.sysman.db.adm.ParameterNames"%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="java.util.ResourceBundle"%>
<%@ page import="oracle.sysman.db.rsc.sec.UMUMsg"%>
<%@ page import="oracle.sysman.emo.adm.security.umu.UMUBean"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="UMUMsgs" class="oracle.sysman.db.rsc.sec.UMUMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  	 <uix:document>
              <%@ include file="/oemTitle.jspf" %>
          
          <%ResourceBundle rb = NLSUtil.getBundle(UMUMsg.class.getName(), request);%>
          <%UMUBean umuBean = (UMUBean)request.getAttribute(ParameterNames.DEFAULT_BEAN);%>
		      
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
          </uix:metaContainer>
    
          <uix:body>  
          
          	<uix:form name="form0" method="POST"  destination="/console/database/EntDBSec/UMU">
          		<uix:formValue name="<%=ParameterNames.PAGE_NAME%>" value="<%=EntDBSecConstants.UMU_FINAL_REVIEW_URL%>"/>
          		<uix:formValue name="<%=ParameterNames.TARGET%>" valueBinding="target@servletRequest"/>
              <uix:formValue name="<%=ParameterNames.TYPE%>" valueBinding="type@servletRequest"/>	
              <uix:formValue name="<%=ParameterNames.BACK_URL%>" valueBinding="backURL@servletRequest"/>
          		<uix:pageLayout titleBinding="PAGE5_LAYOUT_TITLE@UMUMsgs">
          			<%@ include file="/enablePPR.jspf" %>
			          <%@ include file="/oemGlobal.jspf" %>
		        			        		
		        		<uix:spacer width="10" height="20"/>
		        		
		   <uix:tableLayout  width="100%">
		 
                 <uix:rowLayout>
                  <uix:cellFormat>
                        <uix:messageComponentLayout columns="2" rows="3" promptWidth="30%" fieldWidth="70%">
                                <uix:messageStyledText shortDescBinding="USERS_PROMPT@UMUMsgs" promptBinding="USERS_PROMPT@UMUMsgs" styleClass="OraInstructionTextStrong" textBinding="users@defaultBean@servletRequest"/>
                                <uix:messageStyledText shortDescBinding="DATABASE_PROMPT@UMUMsgs" promptBinding="DATABASE_PROMPT@UMUMsgs" styleClass="OraInstructionTextStrong" textBinding='<%=ParameterNames.TARGET+"@servletRequest"%>'/>
                                <%--dummy message components used to get the allignment right--%>
                                <uix:messageStyledText/>
                                <uix:messageStyledText/>
                        </uix:messageComponentLayout>
                    </uix:cellFormat>                            
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat>                            
                        <uix:spacer height="10" width="10"/>
                    </uix:cellFormat>                            
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat>
                        <uix:messageComponentLayout columns="2" rows="3" promptWidth="30%" fieldWidth="70%">
                            <uix:messageStyledText textBinding="imRealm@defaultBean@servletRequest" promptBinding="REALM_PROMPT@UMUMsgs" styleClass="OraInstructionTextStrong" vAlign="middle"/>
                            <uix:messageStyledText textBinding="userCreateBase@defaultBean@servletRequest" promptBinding="UCB_PROMPT@UMUMsgs" styleClass="OraInstructionTextStrong"/>
                            <uix:messageStyledText text='<%=rb.getString(umuBean.getEnableKerberos())%>' promptBinding="KERBEROS_PROMPT@UMUMsgs" styleClass="OraInstructionTextStrong"/>
                            <uix:messageStyledText text='<%=rb.getString(umuBean.getSchemaType())%>' promptBinding="SCHEMA_PROMPT@UMUMsgs" vAlign="middle" styleClass="OraInstructionTextStrong"/>
                            <uix:messageStyledText text='<%=rb.getString(umuBean.getMappingType())%>' promptBinding="MAPPING_SCOPE_PROMPT@UMUMsgs" styleClass="OraInstructionTextStrong" vAlign="middle"/>
                            <uix:messageStyledText text='<%=rb.getString(umuBean.getMappingLevel())%>' promptBinding="MAPPING_LEVEL_PROMPT@UMUMsgs" styleClass="OraInstructionTextStrong" vAlign="middle"/>
                        </uix:messageComponentLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  
                  <uix:rowLayout>
                  	<uix:cellFormat>
                        <uix:spacer width="10" height="20"/>
                    </uix:cellFormat>
                	</uix:rowLayout>		        		
		        		</uix:tableLayout>
		        		
		        		
		        		<uix:header textBinding="FINAL_REVIEW_HEADER@UMUMsgs">
                  <uix:tableLayout>
                      <uix:rowLayout>
                          <uix:spacer width="10" height="20"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                          <uix:styledText styleClass="OraInstructionText" textBinding="FINAL_REVIEW_INFO@UMUMsgs"/><uix:styledText styleClass="OraInstructionText" textBinding="RANDOM_NUMBER@servletRequest"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                          <uix:spacer width="10" height="10"/>
                      </uix:rowLayout>
                  </uix:tableLayout>
		        	  </uix:header>
                	
		        	  <uix:header textBinding="USERS_TO_BE_MIGRATED_HEADER@UMUMsgs">
    							<uix:dataScope currentDataBinding='<%=EntDBSecConstants.MIG_USER_RECORD_LIST+"@servletRequest"%>' >
    								<uix:table width="100%"
				              formSubmitted="true"
				              id="MIG_USER_RECORD_LIST_TABLE"
				              tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
				              valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
				              maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
				              blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
				              summaryBinding="MIG_USERS_LIST_SUMMARY@UMUMsgs"
                                              alternateTextBinding="NO_ITEMS_FOUND@UMUMsgs">
				     					<uix:tableSelection>
				     							<uix:multipleSelection shortDescBinding="MULTIPLE_SEL_SHORT_DESC@UMUMsgs" selectedBinding="<%= UIXDataSource.S_SELECT_ATTR%>" rendered="false"/>
				     					</uix:tableSelection>
				     					<uix:column>
				        					<uix:columnHeader>
					        						<uix:text textBinding = "USERNAME@UMUMsgs"/>
				        					</uix:columnHeader>
				        					<uix:columnFormat columnDataFormat="textFormat" />
				        					<uix:styledText textBinding="USER_NAME_INDEX" />
				     					</uix:column>	
				     					<uix:column>
				        					<uix:columnHeader>
					        						<uix:text textBinding = "SCHEMA@UMUMsgs"/>
				        					</uix:columnHeader>
				        					<uix:columnFormat columnDataFormat="textFormat" />
				        					<uix:styledText textBinding="OLD_SCHEMA_INDEX" />
				     					</uix:column>	
				     					<uix:column>
				        					<uix:columnHeader>
					        						<uix:text textBinding = "DIR_ENTRY_CN@UMUMsgs"/>
				        					</uix:columnHeader>
				        					<uix:columnFormat columnDataFormat="textFormat" />
				        					<uix:styledText textBinding="DIR_ENTRY_CN_INDEX" />
				     					</uix:column>	
				     					<uix:column>
				        					<uix:columnHeader>
					        						<uix:text textBinding = "USER_DN_EXISTS@UMUMsgs"/>
				        					</uix:columnHeader>
				        					<uix:columnFormat columnDataFormat="textFormat" />
				        					<uix:image source="/em/images/completeind_status.gif" hAlign="center" renderedBinding="USERDN_EXISTS_INDEX" shortDescBinding="USER_DN_EXISTS@UMUMsgs"/>
				     					</uix:column>	
				     					<uix:column>
				        					<uix:columnHeader>
					        						<uix:text textBinding = "DB_PWD_SET@UMUMsgs"/>
				        					</uix:columnHeader>
				        					<uix:columnFormat columnDataFormat="textFormat" />
				        					<uix:image source="/em/images/completeind_status.gif" hAlign="center" renderedBinding="DB_PWD_SET_INDEX" shortDescBinding="DB_PWD_SET@UMUMsgs"/>
				     					</uix:column>	
				     					<uix:column>
				        					<uix:columnHeader>
					        						<uix:text textBinding = "PASSWORD_COL_HEADER@UMUMsgs"/>
				        					</uix:columnHeader>
				        					<uix:columnFormat columnDataFormat="textFormat" />
				        					<uix:styledText textBinding="DB_PWD_INDEX" />
				     					</uix:column>	
				     		</uix:table>
	             </uix:dataScope>
               </uix:header>
		        		
		        		
		        		
		        		
		        		
		        		
		        		
		        		<uix:userInfo>
									<uix:flowLayout>
									    <uix:formattedText textBinding="OID_LOGGEDINUSER@servletRequest"  styleClass="OraTipText"/>
									    <uix:spacer width="2" height="1"/>
									    <uix:submitButton textBinding="BUTTON_LOGOUT@UMUMsgs" name="event" value="logout"/>
                                                                            <uix:rowLayout hAlign="right">
										<uix:formattedText textBinding="OID_HOSTPORT@servletRequest" styleClass="OraTipText"/>
									    </uix:rowLayout>
									</uix:flowLayout>
								</uix:userInfo>
								
				  			<uix:pageButtons>
					          <uix:pageButtonBar>
					              <uix:contents>
					                   <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
					                   <uix:navigationBar maxValue="5" formSubmitted="true" name="umuwizardnavigator" value="5"/>
					                   <uix:submitButton textBinding="BUTTON_FINISH@UMUMsgs" shortDescBinding="Finish" name="event" value="finish"/>	
					               </uix:contents>
					            </uix:pageButtonBar>
					       </uix:pageButtons>
				         <uix:location>
				           <uix:train id="UMUWizard" selectedIndex="4" formSubmitted="false">
				  	            <uix:link textBinding="WIZARD_STEP1@UMUMsgs" />
				                <uix:link textBinding="WIZARD_STEP2@UMUMsgs"/>
				                <uix:link textBinding="WIZARD_STEP3@UMUMsgs" />
				                <uix:link textBinding="WIZARD_STEP4@UMUMsgs" />
				                <uix:link textBinding="WIZARD_STEP5@UMUMsgs" />
				           </uix:train>
				         </uix:location>
						  </uix:pageLayout>
          	</uix:form>
          </uix:body>
        </uix:document>
</uix:renderingContext>
