<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.adm.sec.common.EntDBSecConstants"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.db.adm.ParameterNames"%>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="UMUMsgs" class="oracle.sysman.db.rsc.sec.UMUMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  
        <uix:document>
                     <%@ include file="/oemTitle.jspf" %>
				 
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
          </uix:metaContainer>
            <uix:body>
                <uix:form name="form0" method="POST"  destination="/console/database/EntDBSec/UMU">
                	 <uix:formValue name="<%=ParameterNames.PAGE_NAME%>" value="<%=EntDBSecConstants.UMU_OID_LOGIN_PAGE_URL%>"/>
					<uix:formValue name="<%=ParameterNames.TARGET%>" valueBinding="target@servletRequest"/>
                	 <uix:formValue name="<%=ParameterNames.TYPE%>" valueBinding="type@servletRequest"/>
					 <uix:formValue name="<%=ParameterNames.BACK_URL%>" valueBinding="backURL@servletRequest"/>
                    <uix:pageLayout titleBinding="PAGE1_LAYOUT_TITLE@UMUMsgs" >
                   	 <%@ include file="/enablePPR.jspf" %>
                     <%@ include file="/oemGlobal.jspf" %>
                      
                     <oem:messageBox messageType="error"
                     errorTableBinding="errors@servletRequest"
                     titleTextKey="titleText" mainTextKey="mainText"/>
                     
                     <oem:messageBox messageType="info"
                     errorTableBinding="info@servletRequest"
                     titleTextKey="titleText" mainTextKey="mainText"/> 
		        
                      <!-- main uix:contents -->
                      
                        <!-- main contents -->
                      
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="100%" cellSpacing="5">
                            <uix:rowLayout>
                              <uix:cellFormat>
                                    <uix:messageComponentLayout columns="2" rows="3" promptWidth="30%" fieldWidth="70%">
                                            <uix:messageStyledText shortDescBinding="USERS_PROMPT@UMUMsgs" promptBinding="USERS_PROMPT@UMUMsgs" styleClass="OraInstructionTextStrong" textBinding="users@defaultBean@servletRequest"/>
                                            <uix:messageStyledText shortDescBinding="DATABASE_PROMPT@UMUMsgs" promptBinding="DATABASE_PROMPT@UMUMsgs" styleClass="OraInstructionTextStrong" textBinding='<%=ParameterNames.TARGET+"@servletRequest"%>'/>

                                            <%--dummy message components used to get the allignment right--%>
                                            <uix:messageStyledText/>
                                            <uix:messageStyledText/>
                                    </uix:messageComponentLayout>
                                </uix:cellFormat>                            
                            </uix:rowLayout>
                        </uix:tableLayout>
                        
                        <uix:header textBinding="OID_LOGIN_HEADER@UMUMsgs" shortDescBinding="OID_LOGIN_HEADER@UMUMsgs">
                          
                            <uix:styledText textBinding="OID_LOGIN_INFO@UMUMsgs" styleClass="OraInstructionText"/>
                          
                        <uix:tableLayout cellPadding="3" >
                            <uix:rowLayout width="400">
                                          <uix:cellFormat hAlign="right">
                                            <uix:messageStyledText textBinding="USER@UMUMsgs" accessKeyBinding="USER@UMUMsgs" shortDescBinding="USER@UMUMsgs" required="uiOnly" styleClass="OraInstructionText" labeledNodeId="OID_BIND_DN"/>
                                          </uix:cellFormat>  
                                          <uix:cellFormat hAlign="left">
                                             <uix:messageTextInput id="OID_BIND_DN" name="OID_BIND_DN" 
					    textBinding="OID_BIND_DN@servletRequest" />
                                          </uix:cellFormat>
                            </uix:rowLayout>  
                                    <uix:spacer width="10" height="10"/>
                            <uix:rowLayout width="400">
                                          <uix:cellFormat hAlign="right">
                                            <uix:messageStyledText textBinding="PASSWORD@UMUMsgs" labeledNodeId="OID_PASSWORD" accessKeyBinding="PASSWORD@UMUMsgs" shortDescBinding="PASSWORD@UMUMsgs" required="uiOnly" styleClass="OraInstructionText"/>
                                          </uix:cellFormat>  
                                          <uix:cellFormat hAlign="left">
                                            <uix:messageTextInput  id="OID_PASSWORD" name="OID_PASSWORD"
					    textBinding="OID_PASSWORD@servletRequest" secret="true" noAutoComplete="true"/>
                                          </uix:cellFormat>
                            </uix:rowLayout>  
                                    <uix:spacer width="10" height="10"/>
                                <uix:rowLayout width="400">
                                              <uix:cellFormat hAlign="right">
                                                <uix:messageStyledText textBinding="HOST@UMUMsgs" accessKeyBinding="HOST@UMUMsgs" labeledNodeId="OID_HOST" shortDescBinding="HOST@UMUMsgs" required="uiOnly" styleClass="OraInstructionText"/>
                                              </uix:cellFormat>  
                                              <uix:cellFormat hAlign="left">
                                               <uix:messageTextInput id="OID_HOST" name="OID_HOST" textBinding="OID_HOST@servletRequest"/>
                                              </uix:cellFormat>
                                </uix:rowLayout> 
                                        <uix:spacer width="10" height="10"/>
                                <uix:rowLayout width="400">
                                              <uix:cellFormat hAlign="right">
                                                <uix:messageStyledText textBinding="PORT@UMUMsgs" accessKeyBinding="PORT@UMUMsgs" labeledNodeId="OID_PORT" shortDescBinding="PORT@UMUMsgs" required="uiOnly" styleClass="OraInstructionText"/>
                                              </uix:cellFormat>  
                                              <uix:cellFormat hAlign="left">
                                               <uix:messageTextInput id="OID_PORT" name="OID_PORT" textBinding="OID_PORT@servletRequest"/>
                                              </uix:cellFormat>
                                </uix:rowLayout> 
                        </uix:tableLayout>
                        </uix:header>
                        
                        <uix:pageButtons>
                             <uix:pageButtonBar>
                                <uix:contents>
                                    <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    <uix:navigationBar maxValue="5" formSubmitted="true" name="umuwizardnavigator" value="1"/>
                                </uix:contents>
                             </uix:pageButtonBar>
                        </uix:pageButtons>
                      
                       <uix:location>
                        <uix:train id="UMUWizard" selectedIndex="0" formSubmitted="false">
                          
                            <uix:link textBinding="WIZARD_STEP1@UMUMsgs" shortDescBinding="WIZARD_STEP1@UMUMsgs"/>
                            <uix:link textBinding="WIZARD_STEP2@UMUMsgs" shortDescBinding="WIZARD_STEP2@UMUMsgs"/>
                            <uix:link textBinding="WIZARD_STEP3@UMUMsgs" shortDescBinding="WIZARD_STEP3@UMUMsgs"/>
                            <uix:link textBinding="WIZARD_STEP4@UMUMsgs" shortDescBinding="WIZARD_STEP4@UMUMsgs"/>
                            <uix:link textBinding="WIZARD_STEP5@UMUMsgs" shortDescBinding="WIZARD_STEP5@UMUMsgs"/>
                          
                        </uix:train>
                      </uix:location>
                      
                    </uix:pageLayout>
                </uix:form>
            </uix:body> 	
        </uix:document>
</uix:renderingContext>


